# Mitwirkungsrichtlinien / Contributing Guidelines

Willkommen! Vielen Dank, dass du Interesse daran hast, zu meinen Projekten beizutragen. Dieses Dokument beschreibt, wie du auf strukturierte und effiziente Weise helfen kannst. Bitte lese es sorgfältig, bevor du Änderungen vorschlägst.

<!-- TOC -->

- [Mitwirkungsrichtlinien / Contributing Guidelines](#mitwirkungsrichtlinien--contributing-guidelines)
    - [Deutsch](#deutsch)
        - [Allgemeine Hinweise](#allgemeine-hinweise)
        - [Issues](#issues)
        - [Pull Requests PRs](#pull-requests-prs)
        - [Übersetzungen .po-Dateien](#%C3%BCbersetzungen-po-dateien)
        - [Tests](#tests)
        - [Kommunikation](#kommunikation)
    - [English](#english)
        - [General Guidelines](#general-guidelines)
        - [Issues](#issues)
        - [Pull Requests PRs](#pull-requests-prs)
        - [Translations .po files](#translations-po-files)
        - [Testing](#testing)
        - [Communication](#communication)

<!-- /TOC -->

---

## Deutsch

### 1. Allgemeine Hinweise
- Alle Mods stammen aus einer Hand und tragen einen einheitlichen Präfix, `Boots_`.
- Bitte achte darauf, die Namenskonventionen und Stilrichtlinien einzuhalten.
- Beiträge sind willkommen, müssen aber überprüfbar und getestet sein.

### 2. Issues
- Bitte prüfe zuerst, ob ein Issue für dein Anliegen bereits existiert, bevor du ein neues erstellst.
- Issues sollten klar formuliert sein und nach Möglichkeit Screenshots oder Logs enthalten, um das Problem nachvollziehbar zu machen.

### 3. Pull Requests (PRs)
- Forke das Repository und arbeite in einem eigenen Branch.
- Stelle sicher, dass dein Branch einen aussagekräftigen Namen hat, z. B. `feature/verbessertes-inventar`.
- Teste deine Änderungen im Singleplayer-Modus, bevor du den PR einreichst.
- PRs sollten eine klare Beschreibung enthalten:
  - Was geändert wurde
  - Warum die Änderung notwendig ist
  - Welche Auswirkungen sie hat
- Verwende die Übersetzungsfunktion für alle Texte, damit sie in `.po`-Dateien übernommen werden können:
  ```lua
  local S = minetest.get_translator("meine_mod")
  
  S("Dein Text hier")

- Vermeide direkte Änderungen an der README.md, der LICENSE oder dem Präfix ohne Absprache.

### 4. Übersetzungen (.po-Dateien)
- Alle neuen Texte müssen in der Mod über die Übersetzungsfunktion (S("Text")) eingebunden werden.
- Für jede unterstützte Sprache existiert eine .po-Datei im Ordner locale/, z. B. locale/de.po für Deutsch, locale/en.po für Englisch.
- Neue Texte werden automatisch in .pot-Dateien extrahiert und können dann in die .po-Dateien übernommen werden.
- Änderungen an .po-Dateien sollten nur neue Übersetzungen oder Korrekturen enthalten. Keine funktionalen Codeänderungen!
- Bitte teste Übersetzungen im Spiel, um sicherzustellen, dass sie korrekt angezeigt werden.

### 5. Tests
- Teste alle Änderungen lokal und stelle sicher, dass sie keine Fehler verursachen.
- Änderungen, die die Performance negativ beeinflussen oder bekannte Bugs einführen, werden nicht gemergt.

### 6. Kommunikation
- Nutze die Kommentar-Funktion in PRs und Issues, um Fragen zu stellen oder Feedback zu geben.
- Respekt und Höflichkeit sind die Grundlage jeder Zusammenarbeit.

---

## English

### 1. General Guidelines
- All mods come from a single source and use a consistent prefix, e.g., Lokator_.
- Please follow naming conventions and coding style guidelines.
- Contributions are welcome but must be verifiable and tested.

### 2. Issues
- Check if an issue already exists before opening a new one.
- Issues should be clearly written and include screenshots or logs if possible.

### 3. Pull Requests (PRs)
- Fork the repository and work on a separate branch.
- Use descriptive branch names, e.g., feature/enhanced-inventory.
- Test your changes in singleplayer mode before submitting the PR.
- PRs should include a clear description:
  - What was changed
  - Why the change is necessary
  - What impact it has
- Use the translation function for all text strings so they can be added to .po files:
  ```lua
  local S = minetest.get_translator("my_mod")

  S("Your text here")

- Avoid direct changes to the README.md, LICENSE, or the prefix without prior agreement.

### 4. Translations (.po files)
- All new text strings must be included using the translation function (S("Text")).
- For each supported language, a .po file exists in the locale/ folder, e.g., locale/de.po for German, locale/en.po for English.
- New strings are automatically extracted into .pot files and then imported into the .po files.
- Changes to .po files should only include new translations or corrections. No functional code changes!
- Please test translations in-game to ensure they display correctly.

### 5. Testing
- Test all changes locally to make sure no errors are introduced.
- Changes that negatively affect performance or introduce known bugs will not be merged.

### 6. Communication
- Use comments in PRs and issues to ask questions or provide feedback.
- Respect and politeness are the foundation of every collaboration.

---

Vielen Dank für dein Interesse und deine Hilfe! / Thank you for your interest and contribution!
