# Minetest Mod: Player Speed HUD

## English

Displays the player's speed (walking, running, falling) in **m/s** and **km/h** in the HUD.  
The display is color-coded, shows maximum speed, and can be moved to different screen positions in-game.

![Screenshot](screenshots/preview.png)

---

### Features

- 📊 Displays:
  - Horizontal speed (walking/running)
  - Vertical speed (falling/climbing)
  - Total speed (with color coding)
  - Maximum speed since login
- 🎨 Color coding:
  - **Green**: normal (< 10 km/h)
  - **Yellow**: fast (10–25 km/h)
  - **Red**: very fast (> 25 km/h)
- ⚙️ Adjustable HUD position via chat command
- 🔄 Updates every 0.1 seconds (now reliable and flicker-free)

---

### Installation

1. Download the mod folder and rename it to **`player_speed`**.  
2. Place the folder into your Minetest `mods` directory:  
   - GNU/Linux: `~/.minetest/mods/`  
   - Windows: `C:\Users\<Name>\Minetest\mods\`  
3. Enable the mod in the **game** or in the **world configuration**.  

---

### Usage

#### Speed HUD
The speed is displayed automatically when you join the game.  
**Note:** Speed is measured every 0.1 seconds to provide reliable, flicker-free values.

#### Change HUD position
Use the command:

/speedhud pos <position>

Available positions:
- `oben_links`, `oben_mitte`, `oben_rechts`
- `mitte_links`, `mitte_mitte`, `mitte_rechts`
- `unten_links`, `unten_mitte`, `unten_rechts`

Example:

/speedhud pos unten_links

---

## Deutsch

Zeigt die Geschwindigkeit des Spielers (Gehen, Laufen, Fallen) in **m/s** und **km/h** im HUD an.  
Die Anzeige ist farbcodiert, zeigt zusätzlich die maximale Geschwindigkeit an und kann im Spiel an verschiedene Bildschirmpositionen verschoben werden.

![Screenshot](screenshots/preview.png)

---

### Features

- 📊 Anzeige von:
  - Horizontaler Geschwindigkeit (Gehen/Laufen)
  - Vertikaler Geschwindigkeit (Fallen/Steigen)
  - Gesamtgeschwindigkeit (inkl. Farbcodierung)
  - Maximalgeschwindigkeit seit Login
- 🎨 Farbmarkierung:
  - **Grün**: normal (< 10 km/h)
  - **Gelb**: schnell (10–25 km/h)
  - **Rot**: sehr schnell (> 25 km/h)
- ⚙️ Einstellbare HUD-Position über Chatbefehl
- 🔄 Aktualisierung alle 0,1 Sekunden (Messung jetzt zuverlässig)

---

### Installation

1. Lade den Mod-Ordner herunter und benenne ihn zu **`player_speed`**.  
2. Lege den Ordner in dein Minetest-Modverzeichnis:  
   - GNU/Linux: `~/.minetest/mods/`  
   - Windows: `C:\Users\<Name>\Minetest\mods\`  
3. Aktiviere den Mod im **Spiel** oder in der **Weltkonfiguration**.  

---

### Nutzung

### Geschwindigkeit im HUD
Die Geschwindigkeit wird automatisch angezeigt, sobald du im Spiel bist.  
**Hinweis:** Die Berechnung erfolgt alle 0,1 Sekunden, sodass die Werte zuverlässig und flackerfrei angezeigt werden.

#### HUD-Position ändern
Benutze den Befehl:

/speedhud pos <position>


Mögliche Positionen:
- `oben_links`, `oben_mitte`, `oben_rechts`
- `mitte_links`, `mitte_mitte`, `mitte_rechts`
- `unten_links`, `unten_mitte`, `unten_rechts`

Beispiel:

/speedhud pos unten_links

---

## License
This project is licensed under the [MIT License](./LICENSE).  

## Credits
- **ChatGPT** (OpenAI).  
