minetest.register_node("3d_spikes:wood_spikes", {
    description = "Wooden Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_wood.png"},
    inventory_image = "default_wood.png^[mask:spike_inv_mask.png",
    wield_image = "default_wood.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {choppy = 2, oddly_breakable_by_hand = 1},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_wood_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.5)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 1},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})

minetest.register_node("3d_spikes:stone_spikes", {
    description = "Stone Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_stone.png"},
    inventory_image = "default_stone.png^[mask:spike_inv_mask.png",
    wield_image = "default_stone.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {cracky = 2},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_stone_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.4)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 2},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})

minetest.register_node("3d_spikes:steel_spikes", {
    description = "Steel Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_steel_block.png"},
    inventory_image = "default_steel_block.png^[mask:spike_inv_mask.png",
    wield_image = "default_steel_block.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {cracky = 2},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_metal_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.3)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 4},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})

minetest.register_node("3d_spikes:gold_spikes", {
    description = "Gold Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_gold_block.png"},
    inventory_image = "default_gold_block.png^[mask:spike_inv_mask.png",
    wield_image = "default_gold_block.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {cracky = 2},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_metal_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.1)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 1},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})

minetest.register_node("3d_spikes:mese_spikes", {
    description = "Mese Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_mese_block.png"},
    inventory_image = "default_mese_block.png^[mask:spike_inv_mask.png",
    wield_image = "default_mese_block.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {cracky = 3},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_stone_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.25)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 5},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})

minetest.register_node("3d_spikes:diamond_spikes", {
    description = "Diamond Spikes",
    drawtype = "mesh",
    mesh = "spike.obj",
    tiles = {"default_diamond_block.png"},
    inventory_image = "default_diamond_block.png^[mask:spike_inv_mask.png",
    wield_image = "default_diamond_block.png^[mask:spike_inv_mask.png",
    paramtype = "light",
    sunlight_propagates = true,
    visual_scale = 0.5,
    groups = {cracky = 3},
    walkable = true,
    selection_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    collision_box = {
        type = "fixed",
        fixed = {-0.35, -0.5, -0.35, 0.35, 0.0, 0.35},
    },
    sounds = default.node_sound_stone_defaults(),

    on_construct = function(pos)
        minetest.get_node_timer(pos):start(0.25)
    end,

    on_timer = function(pos)
        local objs = minetest.get_objects_inside_radius(pos, 0.6)
        for _, obj in ipairs(objs) do
            if obj:is_player() or obj:get_luaentity() then
                obj:punch(obj, 1.0, {
                    full_punch_interval = 1.0,
                    damage_groups = {fleshy = 6},
                }, nil)

                minetest.sound_play("spike_hit", {
                    pos = pos,
                    max_hear_distance = 8,
                    gain = 1.0,
                })

                minetest.add_particlespawner({
                    amount = 8,
                    time = 0.1,
                    minpos = {x = pos.x - 0.1, y = pos.y + 0.2, z = pos.z - 0.1},
                    maxpos = {x = pos.x + 0.1, y = pos.y + 0.4, z = pos.z + 0.1},
                    minvel = {x = -2, y = 2, z = -2},
                    maxvel = {x = 2, y = 4, z = 2},
                    minacc = {x = 0, y = -6, z = 0},
                    maxacc = {x = 0, y = -9, z = 0},
                    minexptime = 0.2,
                    maxexptime = 0.4,
                    minsize = 2,
                    maxsize = 4,
                    texture = "blood_particle.png",
                    glow = 5,
                })
            end
        end
        return true
    end,
})