require("mineunit")

mineunit("core")
mineunit("player")
mineunit("default/functions")

sourcefile("spec/common")
sourcefile("init")

describe("get_schemapart_offset test", function()
	it("returns the proper coordinates", function()
		local offset, offset_max = blockexchange.get_schemapart_offset({x=10,y=10,z=10}, {x=10,y=10,z=10})
		assert.not_nil(offset)
		assert.equal(0, offset.x)
		assert.equal(0, offset.y)
		assert.equal(0, offset.z)
		assert.not_nil(offset_max)
		assert.equal(15, offset_max.x)
		assert.equal(15, offset_max.y)
		assert.equal(15, offset_max.z)

		offset, offset_max = blockexchange.get_schemapart_offset({x=10,y=10,z=10}, {x=11,y=11,z=11})
		assert.not_nil(offset)
		assert.equal(0, offset.x)
		assert.equal(0, offset.y)
		assert.equal(0, offset.z)
		assert.not_nil(offset_max)
		assert.equal(15, offset_max.x)
		assert.equal(15, offset_max.y)
		assert.equal(15, offset_max.z)

		offset, offset_max = blockexchange.get_schemapart_offset({x=1000,y=10,z=10}, {x=1011,y=11,z=11})
		assert.not_nil(offset)
		assert.equal(0, offset.x)
		assert.equal(0, offset.y)
		assert.equal(0, offset.z)
		assert.not_nil(offset_max)
		assert.equal(15, offset_max.x)
		assert.equal(15, offset_max.y)
		assert.equal(15, offset_max.z)

		offset, offset_max = blockexchange.get_schemapart_offset({x=1000,y=10,z=10}, {x=1016,y=11,z=11})
		assert.not_nil(offset)
		assert.equal(16, offset.x)
		assert.equal(0, offset.y)
		assert.equal(0, offset.z)
		assert.not_nil(offset_max)
		assert.equal(31, offset_max.x)
		assert.equal(15, offset_max.y)
		assert.equal(15, offset_max.z)
	end)
	it("returns the proper negative coordinates", function()
		local offset, offset_max = blockexchange.get_schemapart_offset({x=10,y=10,z=10}, {x=9,y=9,z=9})
		assert.not_nil(offset)
		assert.equal(-16, offset.x)
		assert.equal(-16, offset.y)
		assert.equal(-16, offset.z)
		assert.not_nil(offset_max)
		assert.equal(-1, offset_max.x)
		assert.equal(-1, offset_max.y)
		assert.equal(-1, offset_max.z)
	end)
end)
