require("mineunit")

mineunit("core")
mineunit("player")
mineunit("default/functions")

sourcefile("spec/common")
sourcefile("init")

describe("blockexchange.get_base_pos", function()
	it("returns proper positive coordinates", function()
		local pos = blockexchange.get_base_pos({x=0, y=0, z=0}, {x=5, y=1, z=0})
		assert.not_nil(pos)
		assert.equals(0, pos.x)
		assert.equals(0, pos.y)
		assert.equals(0, pos.z)

		pos = blockexchange.get_base_pos({x=0, y=0, z=0}, {x=5, y=16, z=0})
		assert.not_nil(pos)
		assert.equals(0, pos.x)
		assert.equals(16, pos.y)
		assert.equals(0, pos.z)
	end)

	it("returns proper negative coordinates", function()
		local pos = blockexchange.get_base_pos({x=0, y=0, z=0}, {x=-5, y=0, z=0})
		assert.not_nil(pos)
		assert.equals(-16, pos.x)
		assert.equals(0, pos.y)
		assert.equals(0, pos.z)

		pos = blockexchange.get_base_pos({x=0, y=0, z=0}, {x=-5, y=-17, z=0})
		assert.not_nil(pos)
		assert.equals(-16, pos.x)
		assert.equals(-32, pos.y)
		assert.equals(0, pos.z)
	end)
end)
