local update_formspec = function(meta)
	local text = meta:get_string("text")
	meta:set_string("infotext", "Chat block: '" .. text .. "'")

	meta:set_string("formspec", "size[8,2;]" ..
		-- col 1
		"field[0.2,0.5;8,1;text;Text;" .. text .. "]" ..

		-- col 2
		"button_exit[0.1,1.5;8,1;save;Save]" ..
		"")
end

minetest.register_node("epic:message", {
	description = "Epic message block: displays a chat message to the player",
	tiles = epic.create_texture("action", "epic_bubble.png"),
	paramtype2 = "facedir",
	groups = {cracky=3,oddly_breakable_by_hand=3,epic=1},
	on_rotate = epic.on_rotate,

	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("text", "Hello world")
		update_formspec(meta, pos)
	end,

	on_receive_fields = function(pos, _, fields, sender)
		local meta = minetest.get_meta(pos);

		if not sender or minetest.is_protected(pos, sender:get_player_name()) then
			-- not allowed
			return
		end

		if fields.text then
			local text = fields.text or "Hello world"
			meta:set_string("text", text)
			update_formspec(meta, pos)
		end

	end,

	epic = {
		on_enter = function(_, meta, player, ctx)
			minetest.chat_send_player(player:get_player_name(), meta:get_string("text"))
			ctx.next()
		end
	}
})
