
substances
----------

### ore ###

The technic mod makes extensive use of not just the default ores but also
some that are added by mods.  You will need to mine for all the ore types
in the course of the game.  Each ore type is found at a specific range of
elevations, and while the ranges mostly overlap, some have non-overlapping
ranges, so you will ultimately need to mine at more than one elevation
to find all the ores.  Also, because one of the best elevations to mine
at is very deep, you will be unable to mine there early in the game.

Elevation is measured in meters, relative to a reference plane that
is not quite sea level.  (The standard sea level is at an elevation
of about +1.4.)  Positive elevations are above the reference plane and
negative elevations below.  Because elevations are always described this
way round, greater numbers when higher, we avoid the word "depth".

The ores that matter in technic are coal, iron, copper, tin, zinc,
chromium, uranium, silver, gold, mithril, mese, and diamond.

Coal is part of the basic Minetest game.  It is found from elevation
+64 downwards, so is available right on the surface at the start of
the game, but it is far less abundant above elevation 0 than below.
It is initially used as a fuel, driving important machines in the early
part of the game.  It becomes less important as a fuel once most of your
machines are electrically powered, but burning fuel remains a way to
generate electrical power.  Coal is also used, usually in dust form, as
an ingredient in alloying recipes, wherever elemental carbon is required.

Iron is part of the basic Minetest game.  It is found from elevation
+2 downwards, and its abundance increases in stages as one descends,
reaching its maximum from elevation -64 downwards.  It is a common metal,
used frequently as a structural component.  In technic, unlike the basic
game, iron is used in multiple forms, mainly alloys based on iron and
including carbon (coal).

Copper is part of the basic Minetest game (having migrated there from
moreores).  It is found from elevation -16 downwards, but is more abundant
from elevation -64 downwards.  It is a common metal, used either on its
own for its electrical conductivity, or as the base component of alloys.
Although common, it is very heavily used, and most of the time it will
be the material that most limits your activity.

Tin is part of the basic Minetest game (having migrated there from
moreores).  It is found from elevation +8 downwards, with no
elevation-dependent variations in abundance beyond that point.
It is a common metal.  Its main use in pure form is as a component
of electrical batteries.  Apart from that its main purpose is
as the secondary ingredient in bronze (the base being copper), but bronze
is itself little used.  Its abundance is well in excess of its usage,
so you will usually have a surplus of it.

Zinc is supplied by technic.  It is found from elevation +2 downwards,
with no elevation-dependent variations in abundance beyond that point.
It is a common metal.  Its main use is as the secondary ingredient
in brass (the base being copper), but brass is itself little used.
Its abundance is well in excess of its usage, so you will usually have
a surplus of it.

Chromium is supplied by technic.  It is found from elevation -100
downwards, with no elevation-dependent variations in abundance beyond
that point.  It is a moderately common metal.  Its main use is as the
secondary ingredient in stainless steel (the base being iron).

Uranium is supplied by technic.  It is found only from elevation -80 down
to -300; using it therefore requires one to mine above elevation -300 even
though deeper mining is otherwise more productive.  It is a moderately
common metal, useful only for reasons related to radioactivity: it forms
the fuel for nuclear reactors, and is also one of the best radiation
shielding materials available.  It is not difficult to find enough uranium
ore to satisfy these uses.  Beware that the ore is slightly radioactive:
it will slightly harm you if you stand as close as possible to it.
It is safe when more than a meter away or when mined.

Silver is supplied by the moreores mod.  It is found from elevation -2
downwards, with no elevation-dependent variations in abundance beyond
that point.  It is a semi-precious metal.  It is little used, being most
notably used in electrical items due to its conductivity, being the best
conductor of all the pure elements.

Gold is part of the basic Minetest game (having migrated there from
moreores).  It is found from elevation -64 downwards, but is more
abundant from elevation -256 downwards.  It is a precious metal.  It is
little used, being most notably used in electrical items due to its
combination of good conductivity (third best of all the pure elements)
and corrosion resistance.

Mithril is supplied by the moreores mod.  It is found from elevation
-512 downwards, the deepest ceiling of any minable substance, with
no elevation-dependent variations in abundance beyond that point.
It is a rare precious metal, and unlike all the other metals described
here it is entirely fictional, being derived from J. R. R. Tolkien's
Middle-Earth setting.  It is little used.

Mese is part of the basic Minetest game.  It is found from elevation
-64 downwards.  The ore is more abundant from elevation -256 downwards,
and from elevation -1024 downwards there are also occasional blocks of
solid mese (each yielding as much mese as nine blocks of ore).  It is a
precious gemstone, and unlike diamond it is entirely fictional.  It is
used in many recipes, though mainly not in large quantities, wherever
some magical quality needs to be imparted.

Diamond is part of the basic Minetest game (having migrated there from
technic).  It is found from elevation -128 downwards, but is more abundant
from elevation -256 downwards.  It is a precious gemstone.  It is used
moderately, mainly for reasons connected to its extreme hardness.

### rock ###

In addition to the ores, there are multiple kinds of rock that need to be
mined in their own right, rather than for minerals.  The rock types that
matter in technic are standard stone, desert stone, marble, and granite.

Standard stone is part of the basic Minetest game.  It is extremely
common.  As in the basic game, when dug it yields cobblestone, which can
be cooked to turn it back into standard stone.  Cobblestone is used in
recipes only for some relatively primitive machines.  Standard stone is
used in a couple of machine recipes.  These rock types gain additional
significance with technic because the grinder can be used to turn them
into dirt and sand.  This, especially when combined with an automated
cobblestone generator, can be an easier way to acquire sand than
collecting it where it occurs naturally.

Desert stone is part of the basic Minetest game.  It is found specifically
in desert biomes, and only from elevation +2 upwards.  Although it is
easily accessible, therefore, its quantity is ultimately quite limited.
It is used in a few recipes.

Marble is supplied by technic.  It is found in dense clusters from
elevation -50 downwards.  It has mainly decorative use, but also appears
in one machine recipe.

Granite is supplied by technic.  It is found in dense clusters from
elevation -150 downwards.  It is much harder to dig than standard stone,
so impedes mining when it is encountered.  It has mainly decorative use,
but also appears in a couple of machine recipes.

### rubber ###

Rubber is a biologically-derived material that has industrial uses due
to its electrical resistivity and its impermeability.  In technic, it
is used in a few recipes, and it must be acquired by tapping rubber trees.

If you have the moretrees mod installed, the rubber trees you need
are those defined by that mod.  If not, technic supplies a copy of the
moretrees rubber tree.

Extracting rubber requires a specific tool, a tree tap.  Using the tree
tap (by left-clicking) on a rubber tree trunk block extracts a lump of
raw latex from the trunk.  Each trunk block can be repeatedly tapped for
latex, at intervals of several minutes; its appearance changes to show
whether it is currently ripe for tapping.  Each tree has several trunk
blocks, so several latex lumps can be extracted from a tree in one visit.

Raw latex isn't used directly.  It must be vulcanized to produce finished
rubber.  This can be performed by alloying the latex with coal dust.

### metal ###

Many of the substances important in technic are metals, and there is
a common pattern in how metals are handled.  Generally, each metal can
exist in five forms: ore, lump, dust, ingot, and block.  With a couple of
tricky exceptions in mods outside technic, metals are only *used* in dust,
ingot, and block forms.  Metals can be readily converted between these
three forms, but can't be converted from them back to ore or lump forms.

As in the basic Minetest game, a "lump" of metal is acquired directly by
digging ore, and will then be processed into some other form for use.
A lump is thus more akin to ore than to refined metal.  (In real life,
metal ore rarely yields lumps ("nuggets") of pure metal directly.
More often the desired metal is chemically bound into the rock as an
oxide or some other compound, and the ore must be chemically processed
to yield pure metal.)

Not all metals occur directly as ore.  Generally, elemental metals (those
consisting of a single chemical element) occur as ore, and alloys (those
consisting of a mixture of multiple elements) do not.  In fact, if the
fictional mithril is taken to be elemental, this pattern is currently
followed perfectly.  (It is not clear in the Middle-Earth setting whether
mithril is elemental or an alloy.)  This might change in the future:
in real life some alloys do occur as ore, and some elemental metals
rarely occur naturally outside such alloys.  Metals that do not occur
as ore also lack the "lump" form.

The basic Minetest game offers a single way to refine metals: cook a lump
in a furnace to produce an ingot.  With technic this refinement method
still exists, but is rarely used outside the early part of the game,
because technic offers a more efficient method once some machines have
been built.  The grinder, available only in electrically-powered forms,
can grind a metal lump into two piles of metal dust.  Each dust pile
can then be cooked into an ingot, yielding two ingots from one lump.
This doubling of material value means that you should only cook a lump
directly when you have no choice, mainly early in the game when you
haven't yet built a grinder.

An ingot can also be ground back to (one pile of) dust.  Thus it is always
possible to convert metal between ingot and dust forms, at the expense
of some energy consumption.  Nine ingots of a metal can be crafted into
a block, which can be used for building.  The block can also be crafted
back to nine ingots.  Thus it is possible to freely convert metal between
ingot and block forms, which is convenient to store the metal compactly.
Every metal has dust, ingot, and block forms.

Alloying recipes in which a metal is the base ingredient, to produce a
metal alloy, always come in two forms, using the metal either as dust
or as an ingot.  If the secondary ingredient is also a metal, it must
be supplied in the same form as the base ingredient.  The output alloy
is also returned in the same form.  For example, brass can be produced
by alloying two copper ingots with one zinc ingot to make three brass
ingots, or by alloying two piles of copper dust with one pile of zinc
dust to make three piles of brass dust.  The two ways of alloying produce
equivalent results.

### iron and its alloys ###

Iron forms several important alloys.  In real-life history, iron was the
second metal to be used as the base component of deliberately-constructed
alloys (the first was copper), and it was the first metal whose working
required processes of any metallurgical sophistication.  The game
mechanics around iron broadly imitate the historical progression of
processes around it, rather than the less-varied modern processes.

The two-component alloying system of iron with carbon is of huge
importance, both in the game and in real life.  The basic Minetest game
doesn't distinguish between these pure iron and these alloys at all,
but technic introduces a distinction based on the carbon content, and
renames some items of the basic game accordingly.

The iron/carbon spectrum is represented in the game by three metal
substances: wrought iron, carbon steel, and cast iron.  Wrought iron
has low carbon content (less than 0.25%), resists shattering, and
is easily welded, but is relatively soft and susceptible to rusting.
In real-life history it was used for rails, gates, chains, wire, pipes,
fasteners, and other purposes.  Cast iron has high carbon content
(2.1% to 4%), is especially hard, and resists corrosion, but is
relatively brittle, and difficult to work.  Historically it was used
to build large structures such as bridges, and for cannons, cookware,
and engine cylinders.  Carbon steel has medium carbon content (0.25%
to 2.1%), and intermediate properties: moderately hard and also tough,
somewhat resistant to corrosion.  In real life it is now used for most
of the purposes previously satisfied by wrought iron and many of those
of cast iron, but has historically been especially important for its
use in swords, armor, skyscrapers, large bridges, and machines.

In real-life history, the first form of iron to be refined was
wrought iron, which is nearly pure iron, having low carbon content.
It was produced from ore by a low-temperature furnace process (the
"bloomery") in which the ore/iron remains solid and impurities (slag)
are progressively removed by hammering ("working", hence "wrought").
This began in the middle East, around 1800 BCE.

Historically, the next forms of iron to be refined were those of high
carbon content.  This was the result of the development of a more
sophisticated kind of furnace, the blast furnace, capable of reaching
higher temperatures.  The real advantage of the blast furnace is that it
melts the metal, allowing it to be cast straight into a shape supplied by
a mould, rather than having to be gradually beaten into the desired shape.
A side effect of the blast furnace is that carbon from the furnace's fuel
is unavoidably incorporated into the metal.  Normally iron is processed
twice through the blast furnace: once producing "pig iron", which has
very high carbon content and lots of impurities but lower melting point,
casting it into rough ingots, then remelting the pig iron and casting it
into the final moulds.  The result is called "cast iron".  Pig iron was
first produced in China around 1200 BCE, and cast iron later in the 5th
century BCE.  Incidentally, the Chinese did not have the bloomery process,
so this was their first iron refining process, and, unlike the rest of
the world, their first wrought iron was made from pig iron rather than
directly from ore.

Carbon steel, with intermediate carbon content, was developed much later,
in Europe in the 17th century CE.  It required a more sophisticated
process, because the blast furnace made it extremely difficult to achieve
a controlled carbon content.  Tweaks of the blast furnace would sometimes
produce an intermediate carbon content by luck, but the first processes to
reliably produce steel were based on removing almost all the carbon from
pig iron and then explicitly mixing a controlled amount of carbon back in.

In the game, the bloomery process is represented by ordinary cooking
or grinding of an iron lump.  The lump represents unprocessed ore,
and is identified only as "iron", not specifically as wrought iron.
This standard refining process produces dust or an ingot which is
specifically identified as wrought iron.  Thus the standard refining
process produces the (nearly) pure metal.

Cast iron is trickier.  You might expect from the real-life notes above
that cooking an iron lump (representing ore) would produce pig iron that
can then be cooked again to produce cast iron.  This is kind of the case,
but not exactly, because as already noted cooking an iron lump produces
wrought iron.  The game doesn't distinguish between low-temperature
and high-temperature cooking processes: the same furnace is used not
just to cast all kinds of metal but also to cook food.  So there is no
distinction between cooking processes to produce distinct wrought iron
and pig iron.  But repeated cooking *is* available as a game mechanic,
and is indeed used to produce cast iron: re-cooking a wrought iron ingot
produces a cast iron ingot.  So pig iron isn't represented in the game as
a distinct item; instead wrought iron stands in for pig iron in addition
to its realistic uses as wrought iron.

Carbon steel is produced by a more regular in-game process: alloying
wrought iron with coal dust (which is essentially carbon).  This bears
a fair resemblance to the historical development of carbon steel.
This alloying recipe is relatively time-consuming for the amount of
material processed, when compared against other alloying recipes, and
carbon steel is heavily used, so it is wise to alloy it in advance,
when you're not waiting for it.

There are additional recipes that permit all three of these types of iron
to be converted into each other.  Alloying carbon steel again with coal
dust produces cast iron, with its higher carbon content.  Cooking carbon
steel or cast iron produces wrought iron, in an abbreviated form of the
bloomery process.

There's one more iron alloy in the game: stainless steel.  It is managed
in a completely regular manner, created by alloying carbon steel with
chromium.

### uranium enrichment ###

When uranium is to be used to fuel a nuclear reactor, it is not
sufficient to merely isolate and refine uranium metal.  It is necessary
to control its isotopic composition, because the different isotopes
behave differently in nuclear processes.

The main isotopes of interest are U-235 and U-238.  U-235 is good at
sustaining a nuclear chain reaction, because when a U-235 nucleus is
bombarded with a neutron it will usually fission (split) into fragments.
It is therefore described as "fissile".  U-238, on the other hand,
is not fissile: if bombarded with a neutron it will usually capture it,
becoming U-239, which is very unstable and quickly decays into semi-stable
(and fissile) plutonium-239.

Inconveniently, the fissile U-235 makes up only about 0.7% of natural
uranium, almost all of the other 99.3% being U-238.  Natural uranium
therefore doesn't make a great nuclear fuel.  (In real life there are
a small number of reactor types that can use it, but technic doesn't
have such a reactor.)  Better nuclear fuel needs to contain a higher
proportion of U-235.

Achieving a higher U-235 content isn't as simple as separating the U-235
from the U-238 and just using the required amount of U-235.  Because
U-235 and U-238 are both uranium, and therefore chemically identical,
they cannot be chemically separated, in the way that different elements
are separated from each other when refining metal.  They do differ
in atomic mass, so they can be separated by centrifuging, but because
their atomic masses are very close, centrifuging doesn't separate them
very well.  They cannot be separated completely, but it is possible to
produce uranium that has the isotopes mixed in different proportions.
Uranium with a significantly larger fissile U-235 fraction than natural
uranium is called "enriched", and that with a significantly lower fissile
fraction is called "depleted".

A single pass through a centrifuge produces two output streams, one with
a fractionally higher fissile proportion than the input, and one with a
fractionally lower fissile proportion.  To alter the fissile proportion
by a significant amount, these output streams must be centrifuged again,
repeatedly.  The usual arrangement is a "cascade", a linear arrangement
of many centrifuges.  Each centrifuge takes as input uranium with some
specific fissile proportion, and passes its two output streams to the
two adjacent centrifuges.  Natural uranium is input somewhere in the
middle of the cascade, and the two ends of the cascade produce properly
enriched and depleted uranium.

Fuel for technic's nuclear reactor consists of enriched uranium of which
3.5% is fissile.  (This is a typical value for a real-life light water
reactor, a common type for power generation.)  To enrich uranium in the
game, it must first be in dust form: the centrifuge will not operate
on ingots.  (In real life uranium enrichment is done with the uranium
in the form of a gas.)  It is best to grind uranium lumps directly to
dust, rather than cook them to ingots first, because this yields twice
as much metal dust.  When uranium is in refined form (dust, ingot, or
block), the name of the inventory item indicates its fissile proportion.
Uranium of any available fissile proportion can be put through all the
usual processes for metal.

A single centrifuge operation takes two uranium dust piles, and produces
as output one dust pile with a fissile proportion 0.1% higher and one with
a fissile proportion 0.1% lower.  Uranium can be enriched up to the 3.5%
required for nuclear fuel, and depleted down to 0.0%.  Thus a cascade
covering the full range of fissile fractions requires 34 cascade stages.
(In real life, enriching to 3.5% uses thousands of cascade stages.
Also, centrifuging is less effective when the input isotope ratio
is more skewed, so the steps in fissile proportion are smaller for
relatively depleted uranium.  Zero fissile content is only asymptotically
approachable, and natural uranium relatively cheap, so uranium is normally
only depleted to around 0.3%.  On the other hand, much higher enrichment
than 3.5% isn't much more difficult than enriching that far.)

Although centrifuges can be used manually, it is not feasible to perform
uranium enrichment by hand.  It is a practical necessity to set up
an automated cascade, using pneumatic tubes to transfer uranium dust
piles between centrifuges.  Because both outputs from a centrifuge are
ejected into the same tube, sorting tubes are needed to send the outputs
in different directions along the cascade.  It is possible to send items
into the centrifuges through the same tubes that take the outputs, so the
simplest version of the cascade structure has a line of 34 centrifuges
linked by a line of 34 sorting tube segments.

Assuming that the cascade depletes uranium all the way to 0.0%,
producing one unit of 3.5%-fissile uranium requires the input of five
units of 0.7%-fissile (natural) uranium, takes 490 centrifuge operations,
and produces four units of 0.0%-fissile (fully depleted) uranium as a
byproduct.  It is possible to reduce the number of required centrifuge
operations by using more natural uranium input and outputting only
partially depleted uranium, but (unlike in real life) this isn't usually
an economical approach.  The 490 operations are not spread equally over
the cascade stages: the busiest stage is the one taking 0.7%-fissile
uranium, which performs 28 of the 490 operations.  The least busy is the
one taking 3.4%-fissile uranium, which performs 1 of the 490 operations.

A centrifuge cascade will consume quite a lot of energy.  It is
worth putting a battery upgrade in each centrifuge.  (Only one can be
accommodated, because a control logic unit upgrade is also required for
tube operation.)  An MV centrifuge, the only type presently available,
draws 7 kEU/s in this state, and takes 5 s for each uranium centrifuging
operation.  It thus takes 35 kEU per operation, and the cascade requires
17.15 MEU to produce each unit of enriched uranium.  It takes five units
of enriched uranium to make each fuel rod, and six rods to fuel a reactor,
so the enrichment cascade requires 514.5 MEU to process a full set of
reactor fuel.  This is about 0.85% of the 6.048 GEU that the reactor
will generate from that fuel.

If there is enough power available, and enough natural uranium input,
to keep the cascade running continuously, and exactly one centrifuge
at each stage, then the overall speed of the cascade is determined by
the busiest stage, the 0.7% stage.  It can perform its 28 operations
towards the enrichment of a single uranium unit in 140 s, so that is
the overall cycle time of the cascade.  It thus takes 70 min to enrich
a full set of reactor fuel.  While the cascade is running at this full
speed, its average power consumption is 122.5 kEU/s.  The instantaneous
power consumption varies from second to second over the 140 s cycle,
and the maximum possible instantaneous power consumption (with all 34
centrifuges active simultaneously) is 238 kEU/s.  It is recommended to
have some battery boxes to smooth out these variations.

If the power supplied to the centrifuge cascade averages less than
122.5 kEU/s, then the cascade can't run continuously.  (Also, if the
power supply is intermittent, such as solar, then continuous operation
requires more battery boxes to smooth out the supply variations, even if
the average power is high enough.)  Because it's automated and doesn't
require continuous player attention, having the cascade run at less
than full speed shouldn't be a major problem.  The enrichment work will
consume the same energy overall regardless of how quickly it's performed,
and the speed will vary in direct proportion to the average power supply
(minus any supply lost because battery boxes filled completely).

If there is insufficient power to run both the centrifuge cascade at
full speed and whatever other machines require power, all machines on
the same power network as the centrifuge will be forced to run at the
same fractional speed.  This can be inconvenient, especially if use
of the other machines is less automated than the centrifuge cascade.
It can be avoided by putting the centrifuge cascade on a separate power
network from other machines, and limiting the proportion of the generated
power that goes to it.

If there is sufficient power and it is desired to enrich uranium faster
than a single cascade can, the process can be speeded up more economically
than by building an entire second cascade.  Because the stages of the
cascade do different proportions of the work, it is possible to add a
second and subsequent centrifuges to only the busiest stages, and have
the less busy stages still keep up with only a single centrifuge each.

Another possible approach to uranium enrichment is to have no fixed
assignment of fissile proportions to centrifuges, dynamically putting
whatever uranium is available into whichever centrifuges are available.
Theoretically all of the centrifuges can be kept almost totally busy all
the time, making more efficient use of capital resources, and the number
of centrifuges used can be as little (down to one) or as large as desired.
The difficult part is that it is not sufficient to put each uranium dust
pile individually into whatever centrifuge is available: they must be
input in matched pairs.  Any odd dust pile in a centrifuge will not be
processed and will prevent that centrifuge from accepting any other input.

### concrete ###

Concrete is a synthetic building material.  The technic modpack implements
it in the game.

Two forms of concrete are available as building blocks: ordinary
"concrete" and more advanced "blast-resistant concrete".  Despite its
name, the latter has no special resistance to explosions or to any other
means of destruction.

Concrete can also be used to make fences.  They act just like wooden
fences, but aren't flammable.  Confusingly, the item that corresponds
to a wooden "fence" is called "concrete post".  Posts placed adjacently
will implicitly create fence between them.  Fencing also appears between
a post and adjacent concrete block.
