--CrushingFurnace mod by sfan5
--v1.1

local function get_furnace_active_formspec(pos, percent)
	local formspec =
		"size[8,9]"..
		"image[2,2;1,1;default_furnace_fire_bg.png^[lowpart:"..
		(100-percent)..":default_furnace_fire_fg.png]"..
		"list[current_name;fuel;2,3;1,1;]"..
		"list[current_name;src;2,1;1,1;]"..
		"list[current_name;dst;5,1;2,2;]"..
		"list[current_player;main;0,5;8,4;]"
	return formspec
end

local furnace_inactive_formspec =
	"size[8,9]"..
	"image[2,2;1,1;default_furnace_fire_bg.png]"..
	"list[current_name;fuel;2,3;1,1;]"..
	"list[current_name;src;2,1;1,1;]"..
	"list[current_name;dst;5,1;2,2;]"..
	"list[current_player;main;0,5;8,4;]"

local crushingfurnace_receipes = {
	--input                 output            time
	{"default:cobble", "default:gravel",      8},
	{"default:gravel", "default:sand",        5},
	{"default:sand", "default:dirt",        5},
	{"default:dirt", "default:clay_lump",     5},
	{"default:desert_cobble", "default:desert_sand", 5},
}

function crushingfurnace_get_craft_result(input)
	if input.method ~= "cooking" then return nil end
	if input.width ~= 1 then return nil end
	for _, e in ipairs(crushingfurnace_receipes) do
		if e[1] == input.items[1]:get_name() then
			local outstack = input.items[1]
			outstack:take_item()
			return {item = ItemStack(e[2]), time=e[3]}, {items = {outstack}}
		end
	end
	return {item = ItemStack(""), time=0}, {items = ItemStack("")}
end

minetest.register_node("crushingfurnace:furnace", {
	description = "Grinder",
	drawtype = "nodebox",
	tiles = {"crushingfurnace_top.png", "crushingfurnace_bottom.png", "crushingfurnace_side.png",
		"crushingfurnace_side.png", "crushingfurnace_side.png", "crushingfurnace_side.png"},
	paramtype2 = "facedir",
	groups = {cracky=2},
	legacy_facedir_simple = true,
	node_box = {
		type = "fixed",
		fixed = {{-0.5, 0.5, -0.5, 0.5, 0+1/16, 0.5},
				{-0.5+1/16, 0+1/16, -0.5+1/16, 0.5-1/16, 0-1/16, 0.5-1/16},
				{-0.5, -0.5, -0.5, 0.5, 0-1/16, 0.5},}
	},
	sounds = default.node_sound_stone_defaults(),
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", furnace_inactive_formspec)
		meta:set_string("infotext", "Grinder")
		local inv = meta:get_inventory()
		inv:set_size("fuel", 1)
		inv:set_size("src", 1)
		inv:set_size("dst", 4)
	end,
	can_dig = function(pos,player)
		local meta = minetest.get_meta(pos);
		local inv = meta:get_inventory()
		if not inv:is_empty("fuel") then
			return false
		elseif not inv:is_empty("dst") then
			return false
		elseif not inv:is_empty("src") then
			return false
		end
		return true
	end,
	allow_metadata_inventory_put = function(pos, listname, index, stack, player)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		if listname == "fuel" then
			if minetest.get_craft_result({method="fuel",width=1,items={stack}}).time ~= 0 then
				if inv:is_empty("src") then
					meta:set_string("infotext","Grinder is empty")
				end
				return stack:get_count()
			else
				return 0
			end
		elseif listname == "src" then
			return stack:get_count()
		elseif listname == "dst" then
			return 0
		end
	end,
	allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		local stack = inv:get_stack(from_list, from_index)
		if to_list == "fuel" then
			if minetest.get_craft_result({method="fuel",width=1,items={stack}}).time ~= 0 then
				if inv:is_empty("src") then
					meta:set_string("infotext","Grinder is empty")
				end
				return count
			else
				return 0
			end
		elseif to_list == "src" then
			return count
		elseif to_list == "dst" then
			return 0
		end
	end,
})

minetest.register_node("crushingfurnace:furnace_active", {
	drawtype = "nodebox",
	tiles = {"crushingfurnace_top.png", "crushingfurnace_bottom.png", "crushingfurnace_side_active.png",
		"crushingfurnace_side_active.png", "crushingfurnace_side_active.png", "crushingfurnace_side_active.png"},
	paramtype2 = "facedir",
	light_source = 5,
	drop = "crushingfurnace:furnace",
	groups = {cracky=2, not_in_creative_inventory=1,hot=1},
	node_box = {
		type = "fixed",
		fixed = {{-0.5, 0.5, -0.5, 0.5, 0+1/16, 0.5},
				{-0.5+1/16, 0+1/16, -0.5+1/16, 0.5-1/16, 0-1/16, 0.5-1/16},
				{-0.5, -0.5, -0.5, 0.5, 0-1/16, 0.5},}
	},
	sounds = default.node_sound_stone_defaults(),
	on_construct = function(pos)
		local meta = minetest.get_meta(pos)
		meta:set_string("formspec", furnace_inactive_formspec)
		meta:set_string("infotext", "Grinder");
		local inv = meta:get_inventory()
		inv:set_size("fuel", 1)
		inv:set_size("src", 1)
		inv:set_size("dst", 4)
	end,
	can_dig = function(pos,player)
		local meta = minetest.get_meta(pos);
		local inv = meta:get_inventory()
		if not inv:is_empty("fuel") then
			return false
		elseif not inv:is_empty("dst") then
			return false
		elseif not inv:is_empty("src") then
			return false
		end
		return true
	end,
	allow_metadata_inventory_put = function(pos, listname, index, stack, player)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		if listname == "fuel" then
			if minetest.get_craft_result({method="fuel",width=1,items={stack}}).time ~= 0 then
				if inv:is_empty("src") then
					meta:set_string("infotext","Grinder is empty")
				end
				return stack:get_count()
			else
				return 0
			end
		elseif listname == "src" then
			return stack:get_count()
		elseif listname == "dst" then
			return 0
		end
	end,
	allow_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
		local meta = minetest.get_meta(pos)
		local inv = meta:get_inventory()
		local stack = inv:get_stack(from_list, from_index)
		if to_list == "fuel" then
			if minetest.get_craft_result({method="fuel",width=1,items={stack}}).time ~= 0 then
				if inv:is_empty("src") then
					meta:set_string("infotext","Grinder is empty")
				end
				return count
			else
				return 0
			end
		elseif to_list == "src" then
			return count
		elseif to_list == "dst" then
			return 0
		end
	end,
})

function hacky_swap_node(pos,name)
	local node = minetest.get_node(pos)
	local meta = minetest.get_meta(pos)
	if node.name == name then
		return
	end
	local meta0 = meta:to_table()
	node.name = name
	minetest.set_node(pos,node)
	meta = minetest.get_meta(pos)
	meta:from_table(meta0)
end

minetest.register_abm({
	nodenames = {"crushingfurnace:furnace","crushingfurnace:furnace_active"},
	interval = 1.0,
	chance = 1,
	action = function(pos, node, active_object_count, active_object_count_wider)
		local meta = minetest.get_meta(pos)
		for i, name in ipairs({
				"fuel_totaltime",
				"fuel_time",
				"src_totaltime",
				"src_time"
		}) do
			if meta:get_string(name) == "" then
				meta:set_float(name, 0.0)
			end
		end

		local inv = meta:get_inventory()

		local srclist = inv:get_list("src")
		local cooked = nil
		local aftercooked
		
		if srclist then
			cooked, aftercooked = crushingfurnace_get_craft_result({method = "cooking", width = 1, items = srclist})
		end
		
		local was_active = false
		
		if meta:get_float("fuel_time") < meta:get_float("fuel_totaltime") then
			was_active = true
			meta:set_float("fuel_time", meta:get_float("fuel_time") + 1)
			meta:set_float("src_time", meta:get_float("src_time") + 1)
			if cooked and cooked.item and meta:get_float("src_time") >= cooked.time then
				-- check if there's room for output in "dst" list
				if inv:room_for_item("dst",cooked.item) then
					-- Put result in "dst" list
					inv:add_item("dst", cooked.item)
					-- take stuff from "src" list
					inv:set_stack("src", 1, aftercooked.items[1])
				else
					print("Could not insert '"..cooked.item:to_string().."'")
				end
				meta:set_string("src_time", 0)
			end
		end
		
		if meta:get_float("fuel_time") < meta:get_float("fuel_totaltime") then
			local percent = math.floor(meta:get_float("fuel_time") /
					meta:get_float("fuel_totaltime") * 100)
			meta:set_string("infotext","Grinder active: "..percent.."%")
			hacky_swap_node(pos,"crushingfurnace:furnace_active")
			meta:set_string("formspec", get_furnace_active_formspec(pos, percent))
			return
		end

		local fuel = nil
		local afterfuel
		local cooked = nil
		local fuellist = inv:get_list("fuel")
		local srclist = inv:get_list("src")
		
		if srclist then
			cooked = crushingfurnace_get_craft_result({method = "cooking", width = 1, items = srclist})
		end
		if fuellist then
			fuel, afterfuel = minetest.get_craft_result({method = "fuel", width = 1, items = fuellist})
		end

		if fuel.time <= 0 then
			meta:set_string("infotext", "Grinder out of fuel")
			hacky_swap_node(pos, "crushingfurnace:furnace")
			meta:set_string("formspec", furnace_inactive_formspec)
			return
		end

		if cooked.item:is_empty() then
			if was_active then
				meta:set_string("infotext", "Grinder is empty")
				hacky_swap_node(pos, "crushingfurnace:furnace")
				meta:set_string("formspec", furnace_inactive_formspec)
			end
			return
		end

		meta:set_string("fuel_totaltime", fuel.time)
		meta:set_string("fuel_time", 0)
		
		inv:set_stack("fuel", 1, afterfuel.items[1])
	end,
})

minetest.register_craft({
	output = 'crushingfurnace:furnace',
	recipe = {
		{'group:stone', 'group:stone', 'group:stone'},
		{'', 'default:stick', ''},
		{'group:stone', 'group:stone', 'group:stone'},
	}
})

if minetest.global_exists("smart_inventory") and smart_inventory.crecipes.add_recipes_from_list then
	-- add grinder recipes to smart inventory database
	local crecipes = smart_inventory.crecipes
	local cache = smart_inventory.cache
	local function fill_citem_recipes()
		local recipelist = {}
		for _, e in ipairs(crushingfurnace_receipes) do
			table.insert(recipelist, {
					output = e[2],
					items = {e[1]},
					type = "grinding"
				})
		end
		crecipes.add_recipes_from_list(recipelist)
	end
	 cache.register_on_cache_filled(fill_citem_recipes)
end
