-- default/subnodes.lua
local S = default.get_translator

subnodes.register_subnodes("default:acacia_tree", {
	["stairs:inner_stair"] = {
		description = S("Inner Acacia Tree Stair"),
		tiles = {
			"default_acacia_tree_top.png", "default_acacia_tree_top.png",
			"default_acacia_tree_split_left.png", "default_acacia_tree.png",
			"default_acacia_tree.png", "default_acacia_tree_split_right.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Acacia Tree Stair"),
		tiles = {
			"default_acacia_tree_top.png", "default_acacia_tree_top.png",
			"default_acacia_tree_split_right.png", "default_acacia_tree.png",
			"default_acacia_tree.png", "default_acacia_tree_split_left.png"
		},
	},
	["stairs:slab"] = {
		description = S("Acacia Tree Slab"),
	},
	["stairs:stair"] = {
		description = S("Acacia Tree Stair"),
		tiles = {
			"default_acacia_tree_top.png", "default_acacia_tree_top.png",
			"default_acacia_tree.png", "default_acacia_tree.png",
			"default_acacia_tree.png", "default_acacia_tree_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Acacia Tree Half Stair"),
		tiles = {
			"default_acacia_tree_top.png", "default_acacia_tree_top.png",
			"default_acacia_tree.png", "default_acacia_tree.png",
			"default_acacia_tree.png", "default_acacia_tree_split.png"
		},
	},
	["stairsplus:micro"] = {
		description = S("Acacia Tree Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Acacia Tree Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Acacia Tree Half Stair"),
		tiles = {
			"default_acacia_tree_top.png", "default_acacia_tree_top.png",
			"default_acacia_tree.png", "default_acacia_tree.png",
			"default_acacia_tree.png", "default_acacia_tree_split.png"
		},
	},
})

subnodes.register_subnodes("default:acacia_wood", {
	["stairs:inner_stair"] = {
		description = S("Inner Acacia Wood Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Acacia Wood Stair"),
	},
	["stairs:slab"] = {
		description = S("Acacia Wood Slab"),
	},
	["stairs:stair"] = {
		description = S("Acacia Wood Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Acacia Wood Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Acacia Wood Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Acacia Wood Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Acacia Wood Half Stair"),
	},
})

subnodes.register_subnodes("default:birch_tree", {
	["stairs:inner_stair"] = {
		description = S("Inner Birch Tree Stair"),
		tiles = {
			"default_aspen_tree_top.png", "default_aspen_tree_top.png",
			"default_aspen_tree_split_left.png", "default_aspen_tree.png",
			"default_aspen_tree.png", "default_aspen_tree_split_right.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Birch Tree Stair"),
		tiles = {
			"default_aspen_tree_top.png", "default_aspen_tree_top.png",
			"default_aspen_tree_split_right.png", "default_aspen_tree.png",
			"default_aspen_tree.png", "default_aspen_tree_split_left.png"
		},
	},
	["stairs:slab"] = {
		description = S("Birch Tree Slab"),
	},
	["stairs:stair"] = {
		description = S("Birch Tree Stair"),
		tiles = {
			"default_aspen_tree_top.png", "default_aspen_tree_top.png",
			"default_aspen_tree.png", "default_aspen_tree.png",
			"default_aspen_tree.png", "default_aspen_tree_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Birch Tree Half Stair"),
		tiles = {
			"default_aspen_tree_top.png", "default_aspen_tree_top.png",
			"default_aspen_tree.png", "default_aspen_tree.png",
			"default_aspen_tree.png", "default_aspen_tree_split.png"
		},
	},
	["stairsplus:micro"] = {
		description = S("Birch Tree Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Birch Tree Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Birch Tree Half Stair"),
		tiles = {
			"default_aspen_tree_top.png", "default_aspen_tree_top.png",
			"default_aspen_tree.png", "default_aspen_tree.png",
			"default_aspen_tree.png", "default_aspen_tree_split.png"
		},
	},
})

subnodes.register_subnodes("default:birch_wood", {
	["stairs:inner_stair"] = {
		description = S("Inner Birch Wood Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Birch Wood Stair"),
	},
	["stairs:slab"] = {
		description = S("Birch Wood Slab"),
	},
	["stairs:stair"] = {
		description = S("Birch Wood Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Birch Wood Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Birch Wood Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Birch Wood Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Birch Wood Half Stair"),
	},
})

subnodes.register_subnodes("default:brick", {
	["stairs:inner_stair"] = {
		description = S("Inner Brick Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Brick Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Brick Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Brick Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Brick Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Brick Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Brick Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Brick Block Half Stair"),
	},
})

subnodes.register_subnodes("default:bronzeblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Bronze Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Bronze Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Bronze Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Bronze Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Bronze Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Bronze Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Bronze Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Bronze Block Half Stair"),
	},
})

subnodes.register_subnodes("default:clay", {
	["stairs:inner_stair"] = {
		description = S("Inner Clay Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Clay Stair"),
	},
	["stairs:slab"] = {
		description = S("Clay Slab"),
	},
	["stairs:stair"] = {
		description = S("Clay Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Clay Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Clay Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Clay Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Clay Half Stair"),
	},
})

subnodes.register_subnodes("default:coalblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Coal Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Coal Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Coal Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Coal Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Coal Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Coal Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Coal Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Coal Block Half Stair"),
	},
})

subnodes.register_subnodes("default:cobble", {
	["stairs:inner_stair"] = {
		description = S("Inner Cobblestone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Cobblestone Stair"),
	},
	["stairs:slab"] = {
		description = S("Cobblestone Slab"),
	},
	["stairs:stair"] = {
		description = S("Cobblestone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Cobblestone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Cobblestone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Cobblestone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Cobblestone Half Stair"),
	},
})

subnodes.register_subnodes("default:copperblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Copper Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Copper Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Copper Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Copper Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Copper Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Copper Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Copper Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Copper Block Half Stair"),
	},
})

subnodes.register_subnodes("default:coral_brown", {
	["stairs:inner_stair"] = {
		description = S("Inner Brown Coral Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Brown Coral Stair"),
	},
	["stairs:slab"] = {
		description = S("Brown Coral Slab"),
	},
	["stairs:stair"] = {
		description = S("Brown Coral Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Brown Coral Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Brown Coral Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Brown Coral Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Brown Coral Half Stair"),
	},
})

subnodes.register_subnodes("default:coral_orange", {
	["stairs:inner_stair"] = {
		description = S("Inner Orange Coral Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Orange Coral Stair"),
	},
	["stairs:slab"] = {
		description = S("Orange Coral Slab"),
	},
	["stairs:stair"] = {
		description = S("Orange Coral Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Orange Coral Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Orange Coral Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Orange Coral Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Orange Coral Half Stair"),
	},
})

subnodes.register_subnodes("default:coral_purple", {
	["stairs:inner_stair"] = {
		description = S("Inner Purple Coral Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Purple Coral Stair"),
	},
	["stairs:slab"] = {
		description = S("Purple Coral Slab"),
	},
	["stairs:stair"] = {
		description = S("Purple Coral Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Purple Coral Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Purple Coral Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Purple Coral Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Purple Coral Half Stair"),
	},
})

subnodes.register_subnodes("default:coral_skeleton", {
	["stairs:inner_stair"] = {
		description = S("Inner Coral Skeleton Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Coral Skeleton Stair"),
	},
	["stairs:slab"] = {
		description = S("Coral Skeleton Slab"),
	},
	["stairs:stair"] = {
		description = S("Coral Skeleton Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Coral Skeleton Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Coral Skeleton Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Coral Skeleton Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Coral Skeleton Half Stair"),
	},
})

subnodes.register_subnodes("default:desert_sand", {
	["stairs:inner_stair"] = {
		description = S("Inner Desert Sand Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Desert Sand Stair"),
	},
	["stairs:slab"] = {
		description = S("Desert Sand Slab"),
	},
	["stairs:stair"] = {
		description = S("Desert Sand Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Desert Sand Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Desert Sand Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Desert Sand Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Desert Sand Half Stair"),
	},
})

subnodes.register_subnodes("default:desert_stone", {
	["stairs:inner_stair"] = {
		description = S("Inner Desert Stone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Desert Stone Stair"),
	},
	["stairs:slab"] = {
		description = S("Desert Stone Slab"),
	},
	["stairs:stair"] = {
		description = S("Desert Stone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Desert Stone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Desert Stone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Desert Stone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Desert Stone Half Stair"),
	},
})

subnodes.register_subnodes("default:desert_stone_block", {
	["stairs:inner_stair"] = {
		description = S("Inner Desert Stone Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Desert Stone Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Desert Stone Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Desert Stone Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Desert Stone Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Desert Stone Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Desert Stone Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Desert Stone Block Half Stair"),
	},
})

subnodes.register_subnodes("default:desert_stonebrick", {
	["stairs:inner_stair"] = {
		description = S("Inner Desert Stone Brick Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Desert Stone Brick Stair"),
	},
	["stairs:slab"] = {
		description = S("Desert Stone Brick Slab"),
	},
	["stairs:stair"] = {
		description = S("Desert Stone Brick Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Desert Stone Brick Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Desert Stone Brick Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Desert Stone Brick Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Desert Stone Brick Half Stair"),
	},
})

subnodes.register_subnodes("default:diamondblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Diamond Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Diamond Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Diamond Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Diamond Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Diamond Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Diamond Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Diamond Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Diamond Block Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt_with_coniferous_litter", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt with Coniferous Litter Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt with Coniferous Litter Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt with Coniferous Litter Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt with Coniferous Litter Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt with Coniferous Litter Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt with Coniferous Litter Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt with Coniferous Litter Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt with Coniferous Litter Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt_with_dry_grass", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt with Savanna Grass Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt with Savanna Grass Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt with Savanna Grass Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt with Savanna Grass Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt with Savanna Grass Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt with Savanna Grass Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt with Savanna Grass Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt with Savanna Grass Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt_with_grass", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt with Grass Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt with Grass Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt with Grass Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt with Grass Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt with Grass Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt with Grass Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt with Grass Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt with Grass Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt_with_rainforest_litter", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt with Rainforest Litter Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt with Rainforest Litter Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt with Rainforest Litter Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt with Rainforest Litter Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt with Rainforest Litter Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt with Rainforest Litter Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt with Rainforest Litter Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt with Rainforest Litter Half Stair"),
	},
})

subnodes.register_subnodes("default:dirt_with_snow", {
	["stairs:inner_stair"] = {
		description = S("Inner Dirt with Snow Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Dirt with Snow Stair"),
	},
	["stairs:slab"] = {
		description = S("Dirt with Snow Slab"),
	},
	["stairs:stair"] = {
		description = S("Dirt with Snow Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Dirt with Snow Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Dirt with Snow Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Dirt with Snow Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Dirt with Snow Half Stair"),
	},
})

subnodes.register_subnodes("default:dry_dirt", {
	["stairs:inner_stair"] = {
		description = S("Inner Savanna Dirt Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Savanna Dirt Stair"),
	},
	["stairs:slab"] = {
		description = S("Savanna Dirt Slab"),
	},
	["stairs:stair"] = {
		description = S("Savanna Dirt Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Savanna Dirt Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Savanna Dirt Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Savanna Dirt Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Savanna Dirt Half Stair"),
	},
})

subnodes.register_subnodes("default:dry_dirt_with_dry_grass", {
	["stairs:inner_stair"] = {
		description = S("Inner Savanna Dirt with Savanna Grass Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Savanna Dirt with Savanna Grass Stair"),
	},
	["stairs:slab"] = {
		description = S("Savanna Dirt with Savanna Grass Slab"),
	},
	["stairs:stair"] = {
		description = S("Savanna Dirt with Savanna Grass Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Savanna Dirt with Savanna Grass Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Savanna Dirt with Savanna Grass Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Savanna Dirt with Savanna Grass Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Savanna Dirt with Savanna Grass Half Stair"),
	},
})

subnodes.register_subnodes("default:glass", {
	["stairs:inner_stair"] = {
		description = S("Inner Glass Stair"),
		tiles = {
			"stairs_glass_stairside.png^[transformR270", "default_glass.png",
			"stairs_glass_stairside.png^[transformFX", "default_glass.png",
			"default_glass.png", "stairs_glass_stairside.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Glass Stair"),
		tiles = {
			"stairs_glass_stairside.png^[transformR90", "default_glass.png",
			"stairs_glass_outer_stairside.png", "stairs_glass_stairside.png",
			"stairs_glass_stairside.png^[transformR90","stairs_glass_outer_stairside.png"
		},
	},
	["stairs:slab"] = {
		description = S("Glass Slab"),
		tiles = {"default_glass.png", "default_glass.png", "stairs_glass_split.png"},
	},
	["stairs:stair"] = {
		description = S("Glass Stair"),
		tiles = {
			"stairs_glass_split.png", "default_glass.png",
			"stairs_glass_stairside.png^[transformFX", "stairs_glass_stairside.png",
			"default_glass.png", "stairs_glass_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Glass Half Stair"),
		tiles = {
			"stairs_glass_outer_stairside.png^[transformR90", "stairs_glass_split.png^[transformR90",
			"stairs_glass_stairside.png^[transformR90", "stairs_glass_stairside.png",
			"stairs_glass_split.png^[transformR90", "stairs_glass_outer_stairside.png^[transformR90",
		},
	},
	["stairsplus:micro"] = {
		description = S("Glass Microblock"),
		tiles = {
			"stairs_glass_stairside.png^[transformFX", "stairs_glass_stairside.png^[transformR180",
			"stairs_glass_stairside.png^[transformR270", "stairs_glass_stairside.png^[transformR180",
			"stairs_glass_stairside.png^[transformR270", "stairs_glass_stairside.png^[transformR180",
		},
	},
	["stairsplus:panel"] = {
		description = S("Glass Panel"),
		tiles = {
			"stairs_glass_split.png", "stairs_glass_split.png",
			"stairs_glass_stairside.png^[transformR270", "stairs_glass_stairside.png^[transformR180",
			"stairs_glass_split.png", "stairs_glass_split.png"
		},
	},
	["stairsplus:right_halfstair"] = {
		description = S("Glass Half Stair"),
		tiles = {
			"stairs_glass_outer_stairside.png^[transformR270", "stairs_glass_split.png^[transformR270",
			"stairs_glass_stairside.png^[transformR90", "stairs_glass_stairside.png",
			"stairs_glass_split.png^[transformR270", "stairs_glass_outer_stairside.png^[transformR270"
		},
	},
})

subnodes.register_subnodes("default:goldblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Gold Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Gold Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Gold Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Gold Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Gold Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Gold Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Gold Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Gold Block Half Stair"),
	},
})

subnodes.register_subnodes("default:granite", {
	["stairs:inner_stair"] = {
		description = S("Inner Granite Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Granite Stair"),
	},
	["stairs:slab"] = {
		description = S("Granite Slab"),
	},
	["stairs:stair"] = {
		description = S("Granite Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Granite Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Granite Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Granite Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Granite Half Stair"),
	},
})

subnodes.register_subnodes("default:granite_block", {
	["stairs:inner_stair"] = {
		description = S("Inner Granite Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Granite Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Granite Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Granite Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Granite Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Granite Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Granite Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Granite Block Half Stair"),
	},
})

subnodes.register_subnodes("default:granite_brick", {
	["stairs:inner_stair"] = {
		description = S("Inner Granite Brick Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Granite Brick Stair"),
	},
	["stairs:slab"] = {
		description = S("Granite Brick Slab"),
	},
	["stairs:stair"] = {
		description = S("Granite Brick Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Granite Brick Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Granite Brick Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Granite Brick Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Granite Brick Half Stair"),
	},
})

subnodes.register_subnodes("default:gravel", {
	["stairs:inner_stair"] = {
		description = S("Inner Gravel Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Gravel Stair"),
	},
	["stairs:slab"] = {
		description = S("Gravel Slab"),
	},
	["stairs:stair"] = {
		description = S("Gravel Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Gravel Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Gravel Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Gravel Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Gravel Half Stair"),
	},
})

subnodes.register_subnodes("default:hardened_rock", {
	["stairs:inner_stair"] = {
		description = S("Inner Hardened Rock Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Hardened Rock Stair"),
	},
	["stairs:slab"] = {
		description = S("Hardened Rock Slab"),
	},
	["stairs:stair"] = {
		description = S("Hardened Rock Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Hardened Rock Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Hardened Rock Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Hardened Rock Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Hardened Rock Half Stair"),
	},
})

subnodes.register_subnodes("default:hardened_rock_brick", {
	["stairs:inner_stair"] = {
		description = S("Inner Hardened Rock Brick Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Hardened Rock Brick Stair"),
	},
	["stairs:slab"] = {
		description = S("Hardened Rock Brick Slab"),
	},
	["stairs:stair"] = {
		description = S("Hardened Rock Brick Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Hardened Rock Brick Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Hardened Rock Brick Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Hardened Rock Brick Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Hardened Rock Brick Half Stair"),
	},
})

subnodes.register_subnodes("default:ironblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Iron Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Iron Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Iron Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Iron Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Iron Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Iron Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Iron Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Iron Block Half Stair"),
	},
})

subnodes.register_subnodes("default:jungletree", {
	["stairs:inner_stair"] = {
		description = S("Inner Jungle Tree Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Jungle Tree Stair"),
	},
	["stairs:slab"] = {
		description = S("Jungle Tree Slab"),
	},
	["stairs:stair"] = {
		description = S("Jungle Tree Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Jungle Tree Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Jungle Tree Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Jungle Tree Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Jungle Tree Half Stair"),
	},
})

subnodes.register_subnodes("default:junglewood", {
	["stairs:inner_stair"] = {
		description = S("Inner Jungle Wood Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Jungle Wood Stair"),
	},
	["stairs:slab"] = {
		description = S("Jungle Wood Slab"),
	},
	["stairs:stair"] = {
		description = S("Jungle Wood Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Jungle Wood Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Jungle Wood Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Jungle Wood Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Jungle Wood Half Stair"),
	},
})

subnodes.register_subnodes("default:mese", {
	["stairs:inner_stair"] = {
		description = S("Inner Mese Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Mese Stair"),
	},
	["stairs:slab"] = {
		description = S("Mese Slab"),
	},
	["stairs:stair"] = {
		description = S("Mese Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Mese Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Mese Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Mese Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Mese Half Stair"),
	},
})

subnodes.register_subnodes("default:meselamp", {
	["stairs:inner_stair"] = {
		description = S("Inner Mese Lamp Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Mese Lamp Stair"),
	},
	["stairs:slab"] = {
		description = S("Mese Lamp Slab"),
	},
	["stairs:stair"] = {
		description = S("Mese Lamp Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Mese Lamp Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Mese Lamp Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Mese Lamp Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Mese Lamp Half Stair"),
	},
})

subnodes.register_subnodes("default:molten_rock", {
	["stairs:inner_stair"] = {
		description = S("Inner Molten Rock Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Molten Rock Stair"),
	},
	["stairs:slab"] = {
		description = S("Molten Rock Slab"),
	},
	["stairs:stair"] = {
		description = S("Molten Rock Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Molten Rock Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Molten Rock Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Molten Rock Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Molten Rock Half Stair"),
	},
})

subnodes.register_subnodes("default:mossycobble", {
	["stairs:inner_stair"] = {
		description = S("Inner Mossy Cobblestone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Mossy Cobblestone Stair"),
	},
	["stairs:slab"] = {
		description = S("Mossy Cobblestone Slab"),
	},
	["stairs:stair"] = {
		description = S("Mossy Cobblestone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Mossy Cobblestone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Mossy Cobblestone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Mossy Cobblestone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Mossy Cobblestone Half Stair"),
	},
})

subnodes.register_subnodes("default:obsidian", {
	["stairs:inner_stair"] = {
		description = S("Inner Obsidian Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Obsidian Stair"),
	},
	["stairs:slab"] = {
		description = S("Obsidian Slab"),
	},
	["stairs:stair"] = {
		description = S("Obsidian Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Obsidian Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Obsidian Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Obsidian Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Obsidian Half Stair"),
	},
})

subnodes.register_subnodes("default:obsidian_block", {
	["stairs:inner_stair"] = {
		description = S("Inner Obsidian Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Obsidian Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Obsidian Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Obsidian Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Obsidian Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Obsidian Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Obsidian Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Obsidian Block Half Stair"),
	},
})

subnodes.register_subnodes("default:obsidian_glass", {
	["stairs:inner_stair"] = {
		description = S("Inner Obsidian Glass Stair"),
		tiles = {
			"stairs_obsidian_glass_stairside.png^[transformR270", "default_obsidian_glass.png",
			"stairs_obsidian_glass_stairside.png^[transformFX", "default_obsidian_glass.png",
			"default_obsidian_glass.png", "stairs_obsidian_glass_stairside.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Obsidian Glass Stair"),
		tiles = {
			"stairs_obsidian_glass_stairside.png^[transformR90", "default_obsidian_glass.png",
			"stairs_obsidian_glass_outer_stairside.png", "stairs_obsidian_glass_stairside.png",
			"stairs_obsidian_glass_stairside.png^[transformR90","stairs_obsidian_glass_outer_stairside.png"
		},
	},
	["stairs:slab"] = {
		description = S("Obsidian Glass Slab"),
		tiles = {"default_obsidian_glass.png", "default_obsidian_glass.png", "stairs_obsidian_glass_split.png"},
	},
	["stairs:stair"] = {
		description = S("Obsidian Glass Stair"),
		tiles = {
			"stairs_obsidian_glass_split.png", "default_obsidian_glass.png",
			"stairs_obsidian_glass_stairside.png^[transformFX", "stairs_obsidian_glass_stairside.png",
			"default_obsidian_glass.png", "stairs_obsidian_glass_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Obsidian Glass Half Stair"),
		tiles = {
			"stairs_obsidian_glass_outer_stairside.png^[transformR90",
			"stairs_obsidian_glass_split.png^[transformR90",
			"stairs_obsidian_glass_stairside.png^[transformR90",
			"stairs_obsidian_glass_stairside.png",
			"stairs_obsidian_glass_split.png^[transformR90",
			"stairs_obsidian_glass_outer_stairside.png^[transformR90",
		},
	},
	["stairsplus:micro"] = {
		description = S("Obsidian Glass Microblock"),
		tiles = {
			"stairs_obsidian_glass_stairside.png^[transformFX",
			"stairs_obsidian_glass_stairside.png^[transformR180",
			"stairs_obsidian_glass_stairside.png^[transformR270",
			"stairs_obsidian_glass_stairside.png^[transformR180",
			"stairs_obsidian_glass_stairside.png^[transformR270",
			"stairs_obsidian_glass_stairside.png^[transformR180",
		},
	},
	["stairsplus:panel"] = {
		description = S("Obsidian Glass Panel"),
		tiles = {
			"stairs_obsidian_glass_split.png",
			"stairs_obsidian_glass_split.png",
			"stairs_obsidian_glass_stairside.png^[transformR270",
			"stairs_obsidian_glass_stairside.png^[transformR180",
			"stairs_obsidian_glass_split.png",
			"stairs_obsidian_glass_split.png"
		},
	},
	["stairsplus:right_halfstair"] = {
		description = S("Obsidian Glass Half Stair"),
		tiles = {
			"stairs_obsidian_glass_outer_stairside.png^[transformR270",
			"stairs_obsidian_glass_split.png^[transformR270",
			"stairs_obsidian_glass_stairside.png^[transformR90",
			"stairs_obsidian_glass_stairside.png",
			"stairs_obsidian_glass_split.png^[transformR270",
			"stairs_obsidian_glass_outer_stairside.png^[transformR270"
		},
	},
})

subnodes.register_subnodes("default:permafrost", {
	["stairs:inner_stair"] = {
		description = S("Inner Permafrost Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Permafrost Stair"),
	},
	["stairs:slab"] = {
		description = S("Permafrost Slab"),
	},
	["stairs:stair"] = {
		description = S("Permafrost Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Permafrost Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Permafrost Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Permafrost Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Permafrost Half Stair"),
	},
})

subnodes.register_subnodes("default:permafrost_with_moss", {
	["stairs:inner_stair"] = {
		description = S("Inner Permafrost with Moss Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Permafrost with Moss Stair"),
	},
	["stairs:slab"] = {
		description = S("Permafrost with Moss Slab"),
	},
	["stairs:stair"] = {
		description = S("Permafrost with Moss Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Permafrost with Moss Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Permafrost with Moss Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Permafrost with Moss Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Permafrost with Moss Half Stair"),
	},
})

subnodes.register_subnodes("default:permafrost_with_stones", {
	["stairs:inner_stair"] = {
		description = S("Inner Permafrost with Stones Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Permafrost with Stones Stair"),
	},
	["stairs:slab"] = {
		description = S("Permafrost with Stones Slab"),
	},
	["stairs:stair"] = {
		description = S("Permafrost with Stones Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Permafrost with Stones Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Permafrost with Stones Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Permafrost with Stones Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Permafrost with Stones Half Stair"),
	},
})

subnodes.register_subnodes("default:pine_tree", {
	["stairs:inner_stair"] = {
		description = S("Inner Pine Tree Stair"),
		tiles = {
			"default_pine_tree_top.png", "default_pine_tree_top.png",
			"default_pine_tree_split_left.png", "default_pine_tree.png",
			"default_pine_tree.png", "default_pine_tree_split_right.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Pine Tree Stair"),
		tiles = {
			"default_pine_tree_top.png", "default_pine_tree_top.png",
			"default_pine_tree_split_right.png", "default_pine_tree.png",
			"default_pine_tree.png", "default_pine_tree_split_left.png"
		},
	},
	["stairs:slab"] = {
		description = S("Pine Tree Slab"),
	},
	["stairs:stair"] = {
		description = S("Pine Tree Stair"),
		tiles = {
			"default_pine_tree_top.png", "default_pine_tree_top.png",
			"default_pine_tree.png", "default_pine_tree.png",
			"default_pine_tree.png", "default_pine_tree_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Pine Tree Half Stair"),
		tiles = {
			"default_pine_tree_top.png", "default_pine_tree_top.png",
			"default_pine_tree.png", "default_pine_tree.png",
			"default_pine_tree.png", "default_pine_tree_split.png"
		},
	},
	["stairsplus:micro"] = {
		description = S("Pine Tree Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Pine Tree Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Pine Tree Half Stair"),
		tiles = {
			"default_pine_tree_top.png", "default_pine_tree_top.png",
			"default_pine_tree.png", "default_pine_tree.png",
			"default_pine_tree.png", "default_pine_tree_split.png"
		},
	},
})

subnodes.register_subnodes("default:pine_wood", {
	["stairs:inner_stair"] = {
		description = S("Inner Pine Wood Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Pine Wood Stair"),
	},
	["stairs:slab"] = {
		description = S("Pine Wood Slab"),
	},
	["stairs:stair"] = {
		description = S("Pine Wood Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Pine Wood Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Pine Wood Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Pine Wood Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Pine Wood Half Stair"),
	},
})

subnodes.register_subnodes("default:sand", {
	["stairs:inner_stair"] = {
		description = S("Inner Sand Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Sand Stair"),
	},
	["stairs:slab"] = {
		description = S("Sand Slab"),
	},
	["stairs:stair"] = {
		description = S("Sand Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Sand Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Sand Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Sand Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Sand Half Stair"),
	},
})

subnodes.register_subnodes("default:sandstone", {
	["stairs:inner_stair"] = {
		description = S("Inner Sandstone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Sandstone Stair"),
	},
	["stairs:slab"] = {
		description = S("Sandstone Slab"),
	},
	["stairs:stair"] = {
		description = S("Sandstone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Sandstone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Sandstone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Sandstone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Sandstone Half Stair"),
	},
})

subnodes.register_subnodes("default:sandstone_block", {
	["stairs:inner_stair"] = {
		description = S("Inner Sandstone Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Sandstone Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Sandstone Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Sandstone Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Sandstone Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Sandstone Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Sandstone Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Sandstone Block Half Stair"),
	},
})

subnodes.register_subnodes("default:sandstonebrick", {
	["stairs:inner_stair"] = {
		description = S("Inner Sandstone Brick Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Sandstone Brick Stair"),
	},
	["stairs:slab"] = {
		description = S("Sandstone Brick Slab"),
	},
	["stairs:stair"] = {
		description = S("Sandstone Brick Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Sandstone Brick Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Sandstone Brick Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Sandstone Brick Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Sandstone Brick Half Stair"),
	},
})

subnodes.register_subnodes("default:snowblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Snow Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Snow Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Snow Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Snow Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Snow Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Snow Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Snow Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Snow Block Half Stair"),
	},
})

subnodes.register_subnodes("default:steelblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Steel Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Steel Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Steel Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Steel Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Steel Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Steel Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Steel Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Steel Block Half Stair"),
	},
})

subnodes.register_subnodes("default:stone", {
	["stairs:inner_stair"] = {
		description = S("Inner Stone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Stone Stair"),
	},
	["stairs:slab"] = {
		description = S("Stone Slab"),
	},
	["stairs:stair"] = {
		description = S("Stone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Stone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Stone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Stone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Stone Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_block", {
	["stairs:inner_stair"] = {
		description = S("Inner Stone Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Stone Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Stone Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Stone Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Stone Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Stone Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Stone Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Stone Block Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_crumbled", {
	["stairs:inner_stair"] = {
		description = S("Inner Crumbled Stone Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Crumbled Stone Stair"),
	},
	["stairs:slab"] = {
		description = S("Crumbled Stone Slab"),
	},
	["stairs:stair"] = {
		description = S("Crumbled Stone Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Crumbled Stone Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Crumbled Stone Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Crumbled Stone Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Crumbled Stone Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_coal", {
	["stairs:inner_stair"] = {
		description = S("Inner Coal Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Coal Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Coal Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Coal Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Coal Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Coal Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Coal Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Coal Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_copper", {
	["stairs:inner_stair"] = {
		description = S("Inner Copper Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Copper Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Copper Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Copper Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Copper Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Copper Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Copper Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Copper Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_diamond", {
	["stairs:inner_stair"] = {
		description = S("Inner Diamond Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Diamond Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Diamond Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Diamond Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Diamond Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Diamond Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Diamond Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Diamond Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_gold", {
	["stairs:inner_stair"] = {
		description = S("Inner Gold Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Gold Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Gold Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Gold Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Gold Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Gold Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Gold Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Gold Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_iron", {
	["stairs:inner_stair"] = {
		description = S("Inner Iron Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Iron Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Iron Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Iron Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Iron Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Iron Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Iron Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Iron Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_mese", {
	["stairs:inner_stair"] = {
		description = S("Inner Mese Crystal Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Mese Crystal Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Mese Crystal Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Mese Crystal Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Mese Crystal Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Mese Crystal Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Mese Crystal Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Mese Crystal Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stone_with_tin", {
	["stairs:inner_stair"] = {
		description = S("Inner Tin Ore Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Tin Ore Stair"),
	},
	["stairs:slab"] = {
		description = S("Tin Ore Slab"),
	},
	["stairs:stair"] = {
		description = S("Tin Ore Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Tin Ore Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Tin Ore Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Tin Ore Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Tin Ore Half Stair"),
	},
})

subnodes.register_subnodes("default:stonebrick", {
	["stairs:inner_stair"] = {
		description = S("Inner Stone Brick Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Stone Brick Stair"),
	},
	["stairs:slab"] = {
		description = S("Stone Brick Slab"),
	},
	["stairs:stair"] = {
		description = S("Stone Brick Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Stone Brick Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Stone Brick Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Stone Brick Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Stone Brick Half Stair"),
	},
})

subnodes.register_subnodes("default:tinblock", {
	["stairs:inner_stair"] = {
		description = S("Inner Tin Block Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Tin Block Stair"),
	},
	["stairs:slab"] = {
		description = S("Tin Block Slab"),
	},
	["stairs:stair"] = {
		description = S("Tin Block Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Tin Block Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Tin Block Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Tin Block Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Tin Block Half Stair"),
	},
})

subnodes.register_subnodes("default:tree", {
	["stairs:inner_stair"] = {
		description = S("Inner Apple Tree Stair"),
		tiles = {
			"default_tree_top.png", "default_tree_top.png",
			"default_tree_split_left.png", "default_tree.png",
			"default_tree.png", "default_tree_split_right.png"
		},
	},
	["stairs:outer_stair"] = {
		description = S("Outer Apple Tree Stair"),
		tiles = {
			"default_tree_top.png", "default_tree_top.png",
			"default_tree_split_right.png", "default_tree.png",
			"default_tree.png", "default_tree_split_left.png"
		},
	},
	["stairs:slab"] = {
		description = S("Apple Tree Slab"),
	},
	["stairs:stair"] = {
		description = S("Apple Tree Stair"),
		tiles = {
			"default_tree_top.png", "default_tree_top.png",
			"default_tree.png", "default_tree.png",
			"default_tree.png", "default_tree_split.png"
		},
	},
	["stairsplus:halfstair"] = {
		description = S("Apple Tree Half Stair"),
		tiles = {
			"default_tree_top.png", "default_tree_top.png",
			"default_tree.png", "default_tree.png",
			"default_tree.png", "default_tree_split.png"
		},
	},
	["stairsplus:micro"] = {
		description = S("Apple Tree Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Apple Tree Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Apple Tree Half Stair"),
		tiles = {
			"default_tree_top.png", "default_tree_top.png",
			"default_tree.png", "default_tree.png",
			"default_tree.png", "default_tree_split.png"
		},
	},
})

subnodes.register_subnodes("default:wood", {
	["stairs:inner_stair"] = {
		description = S("Inner Apple Wood Stair"),
	},
	["stairs:outer_stair"] = {
		description = S("Outer Apple Wood Stair"),
	},
	["stairs:slab"] = {
		description = S("Apple Wood Slab"),
	},
	["stairs:stair"] = {
		description = S("Apple Wood Stair"),
	},
	["stairsplus:halfstair"] = {
		description = S("Apple Wood Half Stair"),
	},
	["stairsplus:micro"] = {
		description = S("Apple Wood Microblock"),
	},
	["stairsplus:panel"] = {
		description = S("Apple Wood Panel"),
	},
	["stairsplus:right_halfstair"] = {
		description = S("Apple Wood Half Stair"),
	},
})
