# Mobs API for Voxelgarden

## About

This mod allows the creation of mobs. Mobs are moving creatures that players can
interact with. This includes animals and monsters.

It was created for Repixture by Wuzzy from scratch to bring some life to the
game. Then, it was forked for Voxelgarden by rudzik8.
It does not contain any mobs itself, but only the technical framework for it.

Original mod: <https://codeberg.org/Wuzzy/Repixture/src/branch/master/mods/rp_mobs>


## Features

* Introduces a 'task queue' system allowing mobs to do stuff in sequence and in parallel
* Resembles player properties: health, fall damage, node damage, drowning and more
* Feeding, taming and breeding (for animals)
* Child mobs
* Lasso and net to capture mobs as item
* Built-in minimal death effect
* Flexible modular design so mobs only use the features they need; almost everything is optional
* Behavior templates for commonly-used primitive behaviors


## Priorities

There are many mob mods for Luanti, but Voxelgarden has its own mob API, based
on Repixture's. The priorities of the Voxelgarden Mobs API are:

* Flexibility: The API should not restrict what mobs can do
* Performance: Inefficient algorithms are avoided like the plague
* Useful functions: The API offers enough built-in functions so developers don't
  have to start from zero for every mob
* Voxelgarden-centered: Mod is tailored towards Voxelgarden


## For developers

See `API.md` for the API documentation for developers.


## Credits and licensing

Media file license: CC BY-SA 4.0
* `mobs_capture_succeed.ogg`: by Wuzzy, CC0
* `mobs_chicken_egg*`: by TenPlus1, CC0
* `mobs_lasso_swing.ogg`: by CrossCut Games, CC0
* `mobs_swing.ogg`: by CrossCut Games, CC0
* `mobs_lasso_swing_hit_hit.ogg`: CC0
* `mobs_lasso_swing_hit_swing.ogg`: CC0
* `mobs_swing_hit_hit.ogg`: CC0
* `mobs_swing_hit_swing.ogg`: CC0
* `rp_sounds_disappear.ogg`: by smidoid, CC BY 4.0

Source code license: LGPLv2.1 or later
