-- Load support for MT game translation.
local S = minetest.get_translator("vg_terracotta")

local vg_terracotta = {}
vg_terracotta.dyes = {
	{"white",      S("White Terracotta")},
	{"grey",       S("Grey Terracotta")},
	{"black",      S("Black Terracotta")},
	{"red",        S("Red Terracotta")},
	{"yellow",     S("Yellow Terracotta")},
	{"green",      S("Green Terracotta")},
	{"cyan",       S("Cyan Terracotta")},
	{"blue",       S("Blue Terracotta")},
	{"magenta",    S("Magenta Terracotta")},
	{"orange",     S("Orange Terracotta")},
	{"violet",     S("Violet Terracotta")},
	{"brown",      S("Brown Terracotta")},
	{"pink",       S("Pink Terracotta")},
	{"dark_grey",  S("Dark Grey Terracotta")},
	{"dark_green", S("Dark Green Terracotta")},
}

for _, row in ipairs(vg_terracotta.dyes) do
	local name = row[1]
	local desc = row[2]
	local itemstring = "vg_terracotta:"..name
	-- Node Definition
	minetest.register_node(itemstring, {
		description = desc,
		tiles = {"vg_terracotta_"..name..".png"},
		groups = {cracky = 3, terracotta = 1},
		sounds = default.node_sound_stone_defaults(),
		_dyestr = "vg_terracotta:%s",
	})
	-- Craft recipe
	minetest.register_craft({
		type = "shapeless",
		output = itemstring,
		recipe = {"group:dye,color_"..name, "group:terracotta"},
	})
end

minetest.register_craft({
	type = "cooking",
	output = "vg_terracotta:white",
	recipe = "default:clay",
	cooktime = 3.0,
})

dofile(minetest.get_modpath("vg_terracotta") .. DIR_DELIM .. "subnodes.lua")
