
--- Registered armors.
--
--  @topic armor


-- support for i18n
local S = minetest.get_translator(minetest.get_current_modname())

--- Copper
--
--  Requires setting `armor_material_copper`.
--
--  @section copper

if not armor.materials.copper then return end

--- Copper Helmet
--
--  @helmet 3d_armor:helmet_copper
--  @img 3d_armor_inv_helmet_copper.png
--  @grp armor_head 1
--  @grp armor_heal 3
--  @grp armor_use 1000
--  @grp physics_speed -0.01
--  @grp physics_gravity 0.01
--  @armorgrp fleshy 10
--  @damagegrp cracky 3
--  @damagegrp snappy 2
--  @damagegrp choppy 2
--  @damagegrp crumbly 1
--  @damagegrp level 2
armor:register_armor(":3d_armor:helmet_copper", {
	description = S("Copper Helmet"),
	inventory_image = "3d_armor_inv_helmet_copper.png",
	groups = {armor_head=1, armor_heal=3, armor_use=1000,
		physics_speed=-0.01, physics_gravity=0.01},
	armor_groups = {fleshy=10},
	damage_groups = {cracky=3, snappy=2, choppy=2, crumbly=1, level=2},
})
dungeon_loot.register({name = "3d_armor:helmet_copper", chance = 0.12})

--- Copper Chestplate
--
--  @chestplate 3d_armor:chestplate_copper
--  @img 3d_armor_inv_chestplate_copper.png
--  @grp armor_torso 1
--  @grp armor_heal 3
--  @grp armor_use 1000
--  @grp physics_speed -0.04
--  @grp physics_gravity 0.04
--  @armorgrp fleshy 10
--  @damagegrp cracky 3
--  @damagegrp snappy 2
--  @damagegrp choppy 2
--  @damagegrp crumbly 1
--  @damagegrp level 2
armor:register_armor(":3d_armor:chestplate_copper", {
	description = S("Copper Chestplate"),
	inventory_image = "3d_armor_inv_chestplate_copper.png",
	groups = {armor_torso=1, armor_heal=3, armor_use=1000,
		physics_speed=-0.04, physics_gravity=0.04},
	armor_groups = {fleshy=10},
	damage_groups = {cracky=3, snappy=2, choppy=2, crumbly=1, level=2},
})
--- Copper Leggings
--
--  @leggings 3d_armor:leggings_copper
--  @img 3d_armor_inv_leggings_copper.png
--  @grp armor_legs 1
--  @grp armor_heal 3
--  @grp armor_use 1000
--  @grp physics_speed -0.03
--  @grp physics_gravity 0.03
--  @armorgrp fleshy 10
--  @damagegrp cracky 3
--  @damagegrp snappy 2
--  @damagegrp choppy 2
--  @damagegrp crumbly 1
--  @damagegrp level 2
armor:register_armor(":3d_armor:leggings_copper", {
	description = S("Copper Leggings"),
	inventory_image = "3d_armor_inv_leggings_copper.png",
	groups = {armor_legs=1, armor_heal=3, armor_use=1000,
		physics_speed=-0.03, physics_gravity=0.03},
	armor_groups = {fleshy=10},
	damage_groups = {cracky=3, snappy=2, choppy=2, crumbly=1, level=2},
})
dungeon_loot.register({name = "3d_armor:leggings_copper", chance = 0.08})

--- Copper Boots
--
--  @boots 3d_armor:boots_copper
--  @img 3d_armor_inv_boots_copper.png
--  @grp armor_feet 1
--  @grp armor_heal 3
--  @grp armor_use 1000
--  @grp physics_speed -0.01
--  @grp physics_gravity 0.01
--  @armorgrp fleshy 10
--  @damagegrp cracky 3
--  @damagegrp snappy 2
--  @damagegrp choppy 2
--  @damagegrp crumbly 1
--  @damagegrp level 2
armor:register_armor(":3d_armor:boots_copper", {
	description = S("Copper Boots"),
	inventory_image = "3d_armor_inv_boots_copper.png",
	groups = {armor_feet=1, armor_heal=3, armor_use=1000,
		physics_speed=-0.01, physics_gravity=0.01},
	armor_groups = {fleshy=10},
	damage_groups = {cracky=3, snappy=2, choppy=2, crumbly=1, level=2},
})

--- Crafting
--
--  @section craft

--- Craft recipes for helmets, chestplates, leggings, boots, & shields.
--
--  @craft armor
--  @usage
--  Key:
--  - m: material
--    - wood:    group:wood
--    - cactus:  default:cactus
--    - steel:   default:steel_ingot
--    - copper:  default:copper_ingot
--    - diamond: default:diamond
--    - gold:    default:gold_ingot
--    - mithril: moreores:mithril_ingot
--    - crystal: ethereal:crystal_ingot
--    - nether:  nether:nether_ingot
--
--  helmet:        chestplate:    leggings:
--  ┌───┬───┬───┐  ┌───┬───┬───┐  ┌───┬───┬───┐
--  │ m │ m │ m │  │ m │   │ m │  │ m │ m │ m │
--  ├───┼───┼───┤  ├───┼───┼───┤  ├───┼───┼───┤
--  │ m │   │ m │  │ m │ m │ m │  │ m │   │ m │
--  ├───┼───┼───┤  ├───┼───┼───┤  ├───┼───┼───┤
--  │   │   │   │  │ m │ m │ m │  │ m │   │ m │
--  └───┴───┴───┘  └───┴───┴───┘  └───┴───┴───┘
--
--  boots:         shield:
--  ┌───┬───┬───┐  ┌───┬───┬───┐
--  │   │   │   │  │ m │ m │ m │
--  ├───┼───┼───┤  ├───┼───┼───┤
--  │ m │   │ m │  │ m │ m │ m │
--  ├───┼───┼───┤  ├───┼───┼───┤
--  │ m │   │ m │  │   │ m │   │
--  └───┴───┴───┘  └───┴───┴───┘

local s = "copper"
local m = armor.materials.copper
minetest.register_craft({
	output = "3d_armor:helmet_"..s,
	recipe = {
		{m, m, m},
		{m, "", m},
		{"", "", ""},
	},
})
minetest.register_craft({
	output = "3d_armor:chestplate_"..s,
	recipe = {
		{m, "", m},
		{m, m, m},
		{m, m, m},
	},
})
minetest.register_craft({
	output = "3d_armor:leggings_"..s,
	recipe = {
		{m, m, m},
		{m, "", m},
		{m, "", m},
	},
})
minetest.register_craft({
	output = "3d_armor:boots_"..s,
	recipe = {
		{m, "", m},
		{m, "", m},
	},
})
