local S = core.get_translator("default")
local log = voxelgarden.get_logger("default")

default = {}
default.LIGHT_MAX = core.LIGHT_MAX -- Backwards compatibility
default.COUSHION = -10 -- Falling damage gets reduced by 10 percent.

-- Expose for backwards compatibility.
default.get_translator = S
default.get_logger = log

-- Define default max stack
local stack = core.settings:get("default_stack_max")
if not stack then
	stack = 60
end

core.nodedef_default.stack_max = stack
core.craftitemdef_default.stack_max = stack
core.nodedef_default.liquid_range = 2

-- Load files
local include = voxelgarden.get_include_helper()
local modules = {
	"gui",
	"abms",
	"functions",
	"sounds",
	"nodes",
	"subnodes",
	"furnace",
	"torch",
	"chests",
	"tools",
	"craftitems",
	"crafting",
	"leafdecay",
	"trees",
	"aliases",
	"legacy",
	"dungeon_loot",
}
include(modules, {}, S, log, include)
