local S = core.get_translator("game_commands")
local log = voxelgarden.get_logger("game_commands")

core.register_chatcommand("ver", {
	description = S("Check game version"),
	func = function(name)
		core.chat_send_player(name, string.format("%s %s", core.get_game_info().title, voxelgarden.get_ver()))
	end
})

core.register_chatcommand("respawn", { -- Better not name that command "kill me"
	description = S("Respawn"),
	func = function(name)
		local player = core.get_player_by_name(name)
		if player then
			if core.settings:get_bool("enable_damage") then
				player:set_hp(0)
				return true
			else
				for _, callback in pairs(core.registered_on_respawnplayers) do
					if callback(player) then
						return true
					end
				end

				-- There doesn't seem to be a way to get a default spawn pos
				-- from the lua API
				return false, S("No static_spawnpoint defined")
			end
		else
			-- Show error message if used when not logged in, eg: from IRC mod
			return false, S("You need to be online to respawn!")
		end
	end
})

local function match_old(privs)
	local ok = false
	for k, v in pairs(privs) do
		if k == "give" and v then
			ok = true
		elseif v then
			return false
		end
	end
	return ok
end

-- Change /pulverize and /clearinv to not require give, like it used to be before Luanti 5.15
for _, cmd in ipairs({"pulverize", "clearinv"}) do
	local def = core.registered_chatcommands[cmd]
	if def then
		if match_old(def.privs) then
			core.override_chatcommand(cmd, {
				privs = {interact=true},
			})
		else
			log:info("Privileges of command /" .. cmd .. " look modified, not overriding them.")
		end
	end
end
