-- Load support for MT game translation.
local S = minetest.get_translator("walls")

walls = {}

walls.register = function(wall_name, wall_desc, wall_texture, wall_mat, wall_sounds, wall_groups)
	-- inventory node, and pole-type wall start item
	minetest.register_node(wall_name, {
		description = wall_desc,
		drawtype = "nodebox",
		node_box = {
			type = "connected",
			fixed = {{-1/4, -1/2, -1/4, 1/4, 1/2, 1/4}},
			-- connect_bottom =
			connect_front = {{-3/16, -1/2, -1/2,  3/16, 3/8, -1/4}},
			connect_left = {{-1/2, -1/2, -3/16, -1/4, 3/8,  3/16}},
			connect_back = {{-3/16, -1/2,  1/4,  3/16, 3/8,  1/2}},
			connect_right = {{ 1/4, -1/2, -3/16,  1/2, 3/8,  3/16}},
		},
		connects_to = { "group:wall", "group:stone" },
		paramtype = "light",
		is_ground_content = false,
		tiles = { wall_texture, },
		walkable = true,
		groups = wall_groups or {cracky = 3, wall = 1, stone = 2},
		sounds = wall_sounds,
	})

	-- crafting recipe
	minetest.register_craft({
		output = wall_name .. " 24",
		recipe = {
			{ '', '', '' },
			{ wall_mat, wall_mat, wall_mat},
			{ wall_mat, wall_mat, wall_mat},
		}
	})

	minetest.register_craft({
		output = wall_mat,
		recipe = {
			{ wall_name, wall_name},
			{ wall_name, wall_name},
		}
	})

end

walls.register("walls:cobble", S("Cobblestone Wall"), "default_cobble.png",
		"default:cobble", default.node_sound_stone_defaults())

walls.register("walls:mossycobble", S("Mossy Cobblestone Wall"), "default_mossycobble.png",
		"default:mossycobble", default.node_sound_stone_defaults())

walls.register("walls:brick", S("Brick Wall"), "default_brick.png",
		"default:brick", default.node_sound_stone_defaults())

walls.register("walls:stonebrick", S("Stone Brick Wall"), "default_stone_brick.png",
		"default:stonebrick", default.node_sound_stone_defaults(), {cracky = 2, wall = 1, stone = 2})

