local biomes_st = biomedb.select(function(biome)
	return (not biome.node_stone)
		or (biome.node_stone == "default:stone")
end)

local biomes_ds = biomedb.select(function(biome)
	return biome.node_stone
		and (biome.node_stone == "default:desert_stone")
end)

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"group:falling_node"},
	sidelen = 16,
	fill_ratio = 10.0, -- complete coverage
	decoration = {
		"default:stone",
		"default:stone_crumbled",
	},
	y_min = -31000,
	y_max = 31000,
	flags = "all_ceilings",
	biomes = biomes_st:name(),
})

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"group:falling_node"},
	sidelen = 16,
	fill_ratio = 10.0, -- complete coverage
	decoration = {"default:desert_stone"},
	y_min = -31000,
	y_max = 31000,
	flags = "all_ceilings",
	biomes = biomes_ds:name(),
})
