-- 0. Disable engine translations in vg_init/init.lua (or any other vg_init file, as it loads before others):
function core.get_translator() return function(str, ...)
	local arg = {...}
	return str:gsub(
		"@%d+",
		function(match) return arg[tonumber(match:sub(2))] end
	)
end end
function core.translate(_, s) return s end

-- 1. Do `s/core\.register_node/register_node` and `s/minetest\.register_node/register_node` in the file.

-- 2. Put this at the start of the file:
local nodes = {}
local function register_node(name, def)
	nodes[name:gsub("^:", "")] = def
	return core.register_node(name, def)
end

-- 3. Put this at the very end of the file or in a separate one (make sure it loads after every other mod file):
core.register_on_mods_loaded(function()
	local code = [[-- AUTOMATICALLY GENERATED WITH CODE FROM `util/generate_subnodes.lua` --
local S = core.get_translator(core.get_current_modname())
]] -- change as necessary
	local registrations = {}
	local worldpath = core.get_worldpath()

	for node_name, node_def in pairs(nodes) do
		if subnodes.is_suitable(node_def) then
			local definitions = {}
			for kind_name, kind_def in pairs(subnodes.registered_kinds) do
				local node_subname, subnode_name = subnodes.make_name_subname(node_name, kind_name)
				local fields = {}
				local fields_string = "{}"
				if kind_def.get_readable_name then
					local description = kind_def.get_readable_name(
						node_def._tt_original_description or
							node_def.description or subnodes.make_readable(node_subname)
					)
					table.insert(fields, "\t\tdescription = S(\"" .. description .. "\"),")
				end
				if #fields ~= 0 then
					fields_string = table.concat({"{", table.concat(fields, "\n"), "\t}"}, "\n")
				end
				local line = "[\"" .. kind_name .. "\"] = " .. fields_string .. ","
				table.insert(definitions, line)
			end
			table.sort(definitions)
			table.insert(registrations,
				table.concat({"",
					"subnodes.register_subnodes(\"" .. node_name .. "\", {",
					"\t" .. table.concat(definitions, "\n\t"),
					"})"
				}, "\n"))
		end
	end

	table.sort(registrations)
	code = code .. table.concat(registrations, "\n")

	core.safe_file_write(worldpath .. "/subnodes.lua", code)
end)

-- 4. Open in a new world and copy the newly generated `subnodes.lua` file from its directory.
-- 5. Edit the file as needed (delete the AUTOMATICALLY GENERATED disclaimer at the top if you make changes).
-- 6. Connect the file to the rest of the mod.
