local S = minetest.get_translator("vg_mobs")

local RANDOM_SOUND_TIMER_MIN = 10000
local RANDOM_SOUND_TIMER_MAX = 30000
local VIEW_RANGE = 14
local ANGRY_COOLDOWN_TIME = 18

local TASK_QUEUE_ROAM_SETTINGS = {
	walk_speed = 1,
	hunt_speed = 3,
	liquid_rise_speed = 2,
	jump_strength = 5,
	jump_clear_height = 2,
	fall_height = 7,
	walk_duration_min = 10000,
	walk_duration_max = 20000,
	find_land_duration_min = 7000,
	find_land_duration_max = 10000,
	find_safe_land_duration_min = 1000,
	find_safe_land_duration_max = 1100,
	idle_duration_min = 500,
	idle_duration_max = 6000,
	find_land_length = 20,
	follow_max_distance = VIEW_RANGE,
	follow_reach_distance = 1,
	follow_give_up_time = 10.0,
	no_follow_time = 6.0,

	dogfight = true,
	dogfight_range = 2,
	dogfight_toolcaps = {damage_groups = {fleshy = 3}},
	dogfight_interval = 1.0,
}

vg_mobs.register_mob("vg_mobs_mobs:omsk", {
	description = S("Omsk"),
	drops = {
		{name = "flowers:mushroom_red", chance = 0.5, min = 0, max = 5},
	},
	default_sounds = {
		attack = "default_swoosh2",
		call = "mobs_omsk",
		damage = "mobs_omsk",
		punch_no_damage = "default_swoosh1",
		death = "mobs_omsk",
	},
	front_body_point = vector.new(0, -1.2, 0),
	dead_y_offset = 0.6,
	entity_definition = {
		initial_properties = {
			hp_max = 50,
			physical = true,
			collisionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4},
			selectionbox = {-0.4, -1, -0.4, 0.4, 0.9, 0.4, rotate=true},
			visual = "mesh",
			visual_size = vector.new(10, 10, 10),
			mesh = "vg_mobs_mobs_omsk.obj",
			textures = {"vg_mobs_mobs_omsk.png"},
			makes_footstep_sound = true,
			stepheight = 1.1,
		},
		on_activate = function(self, staticdata)
			vg_mobs.init_mob(self)
			vg_mobs.restore_state(self, staticdata)

			vg_mobs.init_fall_damage(self, true)

			vg_mobs.init_tasks(self)
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.land_roam(TASK_QUEUE_ROAM_SETTINGS))
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.player_follow_scan(VIEW_RANGE))
			vg_mobs.add_task_queue(self, vg_mobs.create_task_queue(
				vg_mobs.create_angry_cooldown_decider(VIEW_RANGE, ANGRY_COOLDOWN_TIME)))
			vg_mobs.add_task_queue(self, vg_mobs.create_task_queue(vg_mobs.create_player_angry_decider()))
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.call_sound(RANDOM_SOUND_TIMER_MIN, RANDOM_SOUND_TIMER_MAX))
		end,
		get_staticdata = vg_mobs.get_staticdata_default,
		on_step = function(self, dtime, moveresult)
			vg_mobs.handle_dying(self, dtime, moveresult, vg_mobs.get_dying_step(true, false))
			vg_mobs.scan_environment(self, dtime, -0.5)
			vg_mobs.handle_environment_damage(self, dtime, moveresult)
			vg_mobs.handle_tasks(self, dtime, moveresult)
		end,
		on_death = vg_mobs.on_death_default,
		on_punch = vg_mobs.on_punch_default,
	},
})

-- Register spawn egg
vg_mobs.register_egg("vg_mobs_mobs:omsk", "wool_red.png")

-- Define spawn rules
vg_mobs_spawn.register_spawn("vg_mobs_mobs:omsk", {
	nodes = {
		"default:stone", "default:cobble", "default:mossycobble",
		"nether:rack", "nether:rack_deep", "nether:lava_crust"
	},
	neighbors = {
		"default:stone_with_iron", "default:mossycobble",
		"default:lava_source", "nether:lava_source", "nether:lava_crust"
	},
	chance = 500,
	active_object_limit = 1,
	active_object_limit_wider = 1,
})
