local S = core.get_translator("vg_mobs_mobs")

local RANDOM_SOUND_TIMER_MIN = 10000
local RANDOM_SOUND_TIMER_MAX = 60000
local VIEW_RANGE = 8
local ANGRY_COOLDOWN_TIME = 20

local FOOD = {
	{name = "farming:bread", points = 2},
	{name = "farming:wheat", points = 1},
	{name = "farming:dough", points = 1},
	{name = "mobs_flat:rat_cooked", points = 2}, -- cannibalism!
}

local TASK_QUEUE_ROAM_SETTINGS = {
	walk_speed = 2,
	hunt_speed = 3,
	liquid_rise_speed = 2,
	jump_strength = 4.6,
	jump_clear_height = 1,
	fall_height = 4,
	max_fall_damage_add_percent_drop_on = 10,
	walk_duration_min = 3000,
	walk_duration_max = 4000,
	find_land_duration_min = 7000,
	find_land_duration_max = 10000,
	find_safe_land_duration_min = 1000,
	find_safe_land_duration_max = 1100,
	idle_duration_min = 500,
	idle_duration_max = 2000,
	find_land_length = 20,
	follow_reach_distance = 1.8,
	follow_max_distance = VIEW_RANGE,
	follow_give_up_time = 10.0,
	no_follow_time = 6.0,

	dogfight = true,
	dogfight_range = 2,
	dogfight_toolcaps = {damage_groups = {fleshy = 2}},
	dogfight_interval = 1.0,
}

-- Register mob
vg_mobs.register_mob("vg_mobs_mobs:rat", {
	description = S("Rat"),
	tags = {animal = 1, child_exists = 1, peaceful = 1},
	drops = {
		{name = "mobs_flat:rat_dead", chance = 1, min = 1, max = 1},
	},
	default_sounds = {
		death = "mobs_rat",
		damage = "mobs_rat",
		eat = "mobs_rat",
		call = "mobs_rat",
		give_birth = "mobs_rat",
		horny = "mobs_rat",
		attack = "mobs_rat",
	},
	animations = {
		idle        = {frame_range = {x = 1, y = 39}, default_frame_speed = 20},
		dead_static = {frame_range = {x = 0, y = 0}},
		walk        = {frame_range = {x = 51, y = 69}, default_frame_speed = 20},
		run         = {frame_range = {x = 81, y = 99}, default_frame_speed = 45},
		punch       = {frame_range = {x = 111, y = 119}, default_frame_speed = 20},
	},
	front_body_point = vector.new(0, -0.1, 0.6),
	dead_y_offset = 0.6,
	entity_definition = {
		initial_properties = {
			hp_max = 4,
			visual = "mesh",
			visual_size = vector.new(10, 10, 10),
			mesh = "animalia_rat.b3d",
			textures = {"animalia_rat_1.png"},
			physical = true,
			collisionbox = {-0.4, 0, -0.4, 0.4, 0.6, 0.4},
			stepheight = 1.1,
			makes_footstep_sound = false,
		},
		on_activate = function(self, staticdata)
			vg_mobs.init_mob(self)
			vg_mobs.restore_state(self, staticdata)

			vg_mobs.init_fall_damage(self, true)
			vg_mobs.init_breath(self, true, {
				breath_max = 10,
				drowning_point = vector.new(0, -0.1, 0.49)
			})
			vg_mobs.init_node_damage(self, true, {
				node_damage_points={vector.new(0, -0.3, 0)},
			})

			vg_mobs.init_tasks(self)
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.land_roam(TASK_QUEUE_ROAM_SETTINGS))
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.food_breed_follow_scan(VIEW_RANGE, FOOD))
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.player_follow_scan(VIEW_RANGE))
			vg_mobs.add_task_queue(self, vg_mobs.create_task_queue(
				vg_mobs.create_angry_cooldown_decider(VIEW_RANGE, ANGRY_COOLDOWN_TIME)))
			vg_mobs.add_task_queue(self, vg_mobs.task_queues.call_sound(RANDOM_SOUND_TIMER_MIN, RANDOM_SOUND_TIMER_MAX))
		end,
		get_staticdata = vg_mobs.get_staticdata_default,
		on_step = function(self, dtime, moveresult)
			vg_mobs.handle_dying(self, dtime, moveresult, vg_mobs.get_dying_step(true, false))
			vg_mobs.scan_environment(self, dtime, -0.3)
			vg_mobs.handle_environment_damage(self, dtime, moveresult)
			vg_mobs.handle_tasks(self, dtime, moveresult)
			vg_mobs.advance_child_growth(self, dtime)
			vg_mobs.handle_breeding(self, dtime)
		end,
		on_rightclick = function(self, clicker)
			vg_mobs.feed_tame_breed(self, clicker, FOOD, 3, 3)
			vg_mobs.call_on_capture(self, clicker)
		end,
		_on_capture = function(self, capturer)
			vg_mobs.attempt_capture(self, capturer)
		end,
		on_death = vg_mobs.on_death_default,
		on_punch = vg_mobs.on_punch_make_hostile,
	},
})

-- Replace caught mob item
core.unregister_item("mobs_flat:rat_caught")
vg_mobs.register_mob_item("vg_mobs_mobs:rat", "mobs_flat_rat.png")
core.register_alias("mobs_flat:rat_caught", "vg_mobs_mobs:rat")

-- Register spawn egg
vg_mobs.register_egg("vg_mobs_mobs:rat", "default_gravel.png")

-- Define spawn rules
vg_mobs_spawn.register_spawn("vg_mobs_mobs:rat", {
	nodes = {"default:dirt_with_grass"},
	neighbors = {"default:grass_1", "default:grass_2", "default:grass_3", "default:grass_4", "default:grass_5"},
	chance = 500,
	active_object_limit = 2,
	active_object_limit_wider = 2,
})
