function stairs.register_slab(subname, recipeitem, groups, images, description, sounds, _)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairs:slab"] = {
			description = description,
			tiles = images,
			groups = groups,
			sounds = sounds
		},
	})
	local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:slab")
	if "stairs:slab_" .. subname ~= subnode_name then
		-- ideally, this should involve LBMs too
		core.register_alias("stairs:slab_" .. subname, subnode_name)
	end
end

function stairs.register_stair(subname, recipeitem, groups, images, description, sounds, _)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairs:stair"] = {
			description = description,
			tiles = images,
			groups = groups,
			sounds = sounds
		},
	})
	local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:stair")
	if "stairs:stair_" .. subname ~= subnode_name then
		core.register_alias("stairs:stair_" .. subname, subnode_name)
	end
end

function stairs.register_stair_inner(subname, recipeitem, groups, images, description, sounds, _, full_description)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairs:inner_stair"] = {
			description = full_description or ("Inner" .. description),
			tiles = images,
			groups = groups,
			sounds = sounds
		},
	})
	local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:inner_stair")
	if "stairs:stair_inner_" .. subname ~= subnode_name then
		core.register_alias("stairs:stair_inner_" .. subname, subnode_name)
	end
end

function stairs.register_stair_outer(subname, recipeitem, groups, images, description, sounds, _, full_description)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairs:outer_stair"] = {
			description = full_description or ("Outer" .. description),
			tiles = images,
			groups = groups,
			sounds = sounds
		},
	})
	local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:outer_stair")
	if "stairs:stair_outer_" .. subname ~= subnode_name then
		core.register_alias("stairs:stair_outer_" .. subname, subnode_name)
	end
end

function stairs.register_stair_and_slab(subname, recipeitem, groups, images, desc_stair, desc_slab, sounds, _,
		desc_stair_inner, desc_stair_outer)
	stairs.register_stair(subname, recipeitem, groups, images, desc_stair, sounds, _)
	stairs.register_stair_inner(subname, recipeitem, groups, images, desc_stair, sounds, _, desc_stair_inner)
	stairs.register_stair_outer(subname, recipeitem, groups, images, desc_stair, sounds, _, desc_stair_outer)
	stairs.register_slab(subname, recipeitem, groups, images, desc_slab, sounds, _)
end
