-- Helper functions for internal use only (not part of the official API)

local internal = {}

-- List of entity variables to store in staticdata
-- (so they are persisted when unloading)
local persisted_entity_vars = {}

-- Getter function for persisted_entity_vars
function internal.get_persisted_entity_vars()
	return persisted_entity_vars
end

-- Declare an entity variable name to be persisted on shutdown
function internal.add_persisted_entity_var(name)
	for _, pvar in pairs(persisted_entity_vars) do
		if pvar == name then
			return
		end
	end
	table.insert(persisted_entity_vars, name)
end

-- Same as above, but for a list of variables
function internal.add_persisted_entity_vars(names)
	for _, name in pairs(names) do
		internal.add_persisted_entity_var(name)
	end
end

return internal
