local legacy_mobs = {}
local S = core.get_translator("vg_mobs_legacy")

local log = voxelgarden.get_logger("vg_mobs_legacy")

-- Register alias for legacy Voxelgarden mobs_flat so it still works after a world upgrade.
-- These are mobs with the 'mobs_flat:' prefix.
-- Also registers item alias for the mob items
local function register_mob_alias(old_name, new_name)
	legacy_mobs[old_name] = new_name

	-- It's a hack! We register a dummy entity with
	-- the old prefix but we instantly replace it
	-- with the modern version.
	core.register_entity(":"..old_name, {
		initial_properties = {
			is_visible = false,
			pointable = false,
			physical = false,
		},
		on_activate = function(self, staticdata)
			local pos = self.object:get_pos()
			self.object:remove()
			local mobent = core.add_entity(pos, new_name)
			if mobent then
				-- Initialize custom state
				local mobluaent = mobent:get_luaentity()
				if mobluaent and not mobluaent._custom_state then
					mobluaent._custom_state = {}
				end

				-- Restore mob status
				if staticdata then
					local data = core.deserialize(staticdata, true)
					if data then
						-- Restore child status
						if data.child then
							vg_mobs.turn_into_child(mobent)
							log:info("Restored child status of legacy mob at "..
								core.pos_to_string(pos, 1))
						end
						-- Restore tamed status
						if data.tamed then
							mobluaent._tamed = true
							log:info("Restored tamed status of legacy mob at "..
								core.pos_to_string(pos, 1))
						end
						-- Restore health
						if data.health and type(data.health) == "number"
								and data.health > 0 then
							local real_health
							do
								-- Health of mobs is half compared to Mobs Redo
								-- due to armor=200 in old definition
								real_health = math.max(1, math.ceil(data.health * 0.5))
							end

							-- Limit to hp_max
							local props = mobent:get_properties()
							real_health = math.min(real_health, props.hp_max)

							mobent:set_hp(real_health)
							log:info("Restored health of legacy mob at "..core.pos_to_string(pos, 1).." to: "..real_health)
						end
					end
				end

				log:action("Replaced legacy mob '"..old_name.."' at "..core.pos_to_string(pos, 1)..
					" with '"..new_name.."'")
			else
				log:error("Could not replace legacy mob '"..old_name.."' at "..
					core.pos_to_string(pos, 1).." with '"..new_name.."'!")
			end
		end,
	})

	-- Item alias
	core.register_alias(old_name, new_name)
end

-- Mob and spawn egg aliases
register_mob_alias("mobs_flat:rat", "vg_mobs_mobs:rat")
core.register_alias_force("mobs_flat:rat", "vg_mobs_mobs:rat_egg") -- vg_mobs_mobs:rat is its own item
register_mob_alias("mobs_flat:oerkki", "vg_mobs_mobs:oerkki")
core.register_alias("mobs_flat:oerkki", "vg_mobs_mobs:oerkki_egg")
register_mob_alias("mobs_flat:omsk", "vg_mobs_mobs:omsk")
core.register_alias("mobs_flat:omsk", "vg_mobs_mobs:omsk_egg")
register_mob_alias("mobs_flat:dustdevil", "vg_mobs_mobs:oerkki")
core.register_alias("mobs_flat:dustdevil", "vg_mobs_mobs:oerkki_egg")
register_mob_alias("mobs_flat:dungeon_master", "vg_mobs_mobs:dungeon_master")
core.register_alias("mobs_flat:dungeon_master", "vg_mobs_mobs:dungeon_master_egg")
register_mob_alias("mobs_flat:1hour", "vg_mobs_mobs:omsk")
core.register_alias("mobs_flat:1hour", "vg_mobs_mobs:omsk_egg")

-- /spawnentity override
core.register_on_chatcommand(function(name, command, params)
	if command == "spawnentity" then
		local entityname = string.match(params, "[a-zA-Z0-9_:]+")
		if legacy_mobs[entityname] then
			core.chat_send_player(name,
				S("Entity name “@1” is outdated. Use “@2” instead.", entityname, legacy_mobs[entityname]))
			return true
		end
	end
end)
