local player_def = {
	animation_speed = 30,
	textures = {"character.png", "blank.png", "blank.png"},
	animations = {
		stand = {x=0, y=79},
		lay = {x=162, y=166, eye_height = 0.3, override_local = true,
			collisionbox = {-0.6, 0.0, -0.6, 0.6, 0.3, 0.6}},
		walk = {x=168, y=187},
		mine = {x=189, y=198},
		walk_mine = {x=200, y=219},
		sit = {x=81, y=160, eye_height = 0.8, override_local = true,
			collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.0, 0.3}},
		-- compatibility w/ the emote mod
		wave = {x = 192, y = 196, override_local = true},
		point = {x = 196, y = 196, override_local = true},
		freeze = {x = 205, y = 205, override_local = true},
	},
	collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.7, 0.3},
	stepheight = 1.1,
	eye_height = 1.625,
}

local sneak_def = table.copy(player_def)
sneak_def.animation_speed = 10
sneak_def.visual_size = {x = 1, y = 0.9}
sneak_def.collisionbox = {-0.3, 0.0, -0.3, 0.3, 1.6, 0.3}
sneak_def.eye_height = 1.47

player_api.register_model("3d_armor_character.b3d", player_def)
player_api.register_model("3d_armor_character_sneak.b3d", sneak_def)

-- Update appearance when the player joins
core.register_on_joinplayer(function(player)
	player_api.set_model(player, "3d_armor_character.b3d")
	player:set_physics_override({
		sneak_glitch = true,
		sneak = true,
		new_move = true
	})
end)

controls.register_on_press(function(player, key)
	if key == "sneak" then
		player_api.set_model(player, "3d_armor_character_sneak.b3d")
	end
end)

controls.register_on_release(function(player, key)
	if key == "sneak" then
		player_api.set_model(player, "3d_armor_character.b3d")
	end
end)
