local S = ...
local S_stairs = core.get_modpath("stairs") and core.get_translator("stairs") or function(str, ...)
	local args = {...}
	return str:gsub("@%d+", function(match) return args[tonumber(match:sub(2))]	end)
end

stairsplus = {}

function stairsplus.register_stair(_, _, recipeitem, groups, images, description, drop, sounds, sunlight)
	if not recipeitem then return end
	if subnodes.registered_kinds["stairs:stair"] then
		subnodes.register_subnodes(recipeitem, {
			["stairs:stair"] = {
				description = description,
				tiles = images,
				groups = groups,
				drop = drop,
				sounds = sounds,
				sunlight_propagates = sunlight,
			},
		})
	end
	subnodes.register_subnodes(recipeitem, {
		["stairsplus:halfstair"] = {
			description = description,
			tiles = images,
			groups = groups,
			drop = drop,
			sounds = sounds,
			sunlight_propagates = sunlight,
		},
		["stairsplus:right_halfstair"] = {
			description = description,
			tiles = images,
			groups = groups,
			drop = drop,
			sounds = sounds,
			sunlight_propagates = sunlight,
		}
	})
end

function stairsplus.register_corner(modname, subname, recipeitem, groups, images, _, drop, sounds, sunlight)
	if not recipeitem then return end
	if subnodes.registered_kinds["stairs:inner_stair"] then
		subnodes.register_subnodes(recipeitem, {
			["stairs:inner_stair"] = {
				--description = description,
				tiles = images,
				groups = groups,
				sounds = sounds,
				drop = drop,
				sunlight_propagates = sunlight,
			},
		})
		local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:inner_stair")
		if "stairs:stair_inner_" .. subname ~= subnode_name then
			voxelgarden.safe_alias("stairs:stair_inner_" .. subname, subnode_name)
		end
	end
	if subnodes.registered_kinds["stairs:outer_stair"] then
		subnodes.register_subnodes(recipeitem, {
			["stairs:outer_stair"] = {
				--description = description,
				tiles = images,
				groups = groups,
				sounds = sounds,
				drop = drop,
				sunlight_propagates = sunlight,
			},
		})
		local _, subnode_name = subnodes.make_name_subname(recipeitem, "stairs:outer_stair")
		if "stairs:stair_outer_" .. subname ~= subnode_name then
			voxelgarden.safe_alias("stairs:stair_outer_" .. subname, subnode_name)
		end
	end
end

function stairsplus.register_slab(_, _, recipeitem, groups, images, description, drop, sounds, sunlight)
	if not recipeitem then return end
	if subnodes.registered_kinds["stairs:slab"] then
		subnodes.register_subnodes(recipeitem, {
			["stairs:slab"] = {
				description = description,
				tiles = images,
				groups = groups,
				drop = drop,
				sounds = sounds,
				sunlight_propagates = sunlight,
			},
		})
	end
end

function stairsplus.register_wall(_, _, _, _, _, _, _, _, _)
	-- replaced with slabs
	return
end

function stairsplus.register_panel(_, _, recipeitem, groups, images, description, drop, sounds, sunlight)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairsplus:panel"] = {
			description = description,
			tiles = images,
			groups = groups,
			drop = drop,
			sounds = sounds,
			sunlight_propagates = sunlight,
		},
	})
end

function stairsplus.register_micro(modname, subname, recipeitem, groups, images, description, drop, sounds, sunlight)
	if not recipeitem then return end
	subnodes.register_subnodes(recipeitem, {
		["stairsplus:micro"] = {
			description = description,
			tiles = images,
			groups = groups,
			drop = drop,
			sounds = sounds,
			sunlight_propagates = sunlight,
		},
	})
end

function stairsplus.register_stair_and_slab_and_panel_and_micro(modname, subname, recipeitem, groups, images, desc_stair, desc_corner, desc_slab, desc_wall, desc_panel, desc_micro, drop, sounds, sunlight)
	stairsplus.register_stair(modname, subname, recipeitem, groups, images, desc_stair, drop, sounds, sunlight)
	stairsplus.register_corner(modname, subname, recipeitem, groups, images, desc_corner, drop, sounds, sunlight)
	stairsplus.register_slab(modname, subname, recipeitem, groups, images, desc_slab, drop, sounds, sunlight)
	stairsplus.register_wall(modname, subname, recipeitem, groups, images, desc_slab, drop, sounds, sunlight)
	stairsplus.register_panel(modname, subname, recipeitem, groups, images, desc_panel, drop, sounds, sunlight)
	stairsplus.register_micro(modname, subname, recipeitem, groups, images, desc_micro, drop, sounds, sunlight)
end

function stairsplus:register_all(modname, subname, recipeitem, fields)
	local desc = fields.description
	local desc_stair = S_stairs("@1 Stair", desc)
	local desc_slab = S_stairs("@1 Slab", desc)
	local desc_panel = S("@1 Panel", desc)
	local desc_micro = S("@1 Microblock", desc)

	-- use recipeitem as drop if no drop provided
	local drop = (fields.drop or recipeitem)

	self.register_stair_and_slab_and_panel_and_micro(
		modname,
		subname,
		recipeitem,
		fields.groups,
		fields.tiles,
		desc_stair,
		"", -- desc_corner
		desc_slab,
		"", -- desc_wall
		desc_panel,
		desc_micro,
		drop,
		fields.sounds,
		true
	)
end
