-- Load support for MT game translation.
local S = minetest.get_translator("keys")

--
-- Craftitems
--

minetest.register_craftitem("keys:skeleton_key", {
	description = S("Skeleton Key"),
	inventory_image = "keys_key_skeleton.png",
	on_use = function(itemstack, user, pointed_thing)
		if pointed_thing.type ~= "node" then
			return itemstack
		end

		local pos = pointed_thing.under
		local node = minetest.get_node(pos)

		if not node then
			return itemstack
		end

		local node_reg = minetest.registered_nodes[node.name]
		local on_skeleton_key_use = node_reg and node_reg.on_skeleton_key_use
		if not on_skeleton_key_use then
			return itemstack
		end

		-- make a new key secret in case the node callback needs it
		local random = math.random
		local newsecret = string.format(
			"%04x%04x%04x%04x",
			random(2^16) - 1, random(2^16) - 1,
			random(2^16) - 1, random(2^16) - 1)

		local secret, _, _ = on_skeleton_key_use(pos, user, newsecret)

		if secret then
			local inv = minetest.get_inventory({type="player", name=user:get_player_name()})

			-- update original itemstack
			itemstack:take_item()

			-- finish and return the new key
			local new_stack = ItemStack("keys:key")
			local meta = new_stack:get_meta()
			meta:set_string("secret", secret)
			meta:set_string("description", S("Key to @1's @2", user:get_player_name(),
				minetest.registered_nodes[node.name].description))

			if itemstack:get_count() == 0 then
				itemstack = new_stack
			else
				if inv:add_item("main", new_stack):get_count() > 0 then
					minetest.add_item(user:get_pos(), new_stack)
				end -- else: added to inventory successfully
			end

			return itemstack
		end
	end
})

minetest.register_craftitem("keys:key", {
	description = S("Key"),
	inventory_image = "keys_key.png",
	groups = {key = 1, not_in_creative_inventory = 1},
	on_place = function(itemstack, placer, pointed_thing)
		local rc = voxelgarden.call_on_rightclick(itemstack, placer, pointed_thing)
		if rc then return rc end

		if pointed_thing.type ~= "node" then
			return itemstack
		end

		local pos = pointed_thing.under
		local node = minetest.get_node(pos)

		if not node or node.name == "ignore" then
			return itemstack
		end

		local ndef = minetest.registered_nodes[node.name]
		if not ndef then
			return itemstack
		end

		local on_key_use = ndef.on_key_use
		if on_key_use then
			on_key_use(pos, placer)
		end

		return nil
	end
})

if minetest.global_exists("dungeon_loot") then
	dungeon_loot.register({
		{name = "keys:skeleton_key", chance = 0.1},
		{name = "keys:key", chance = 0.1},
	})
end
