



--
-- Node Registration
--

-- Marble
minetest.register_node("ephesus:marble", {
    description = "Marble",
    tiles = {"marble.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 1},
    sounds = default.node_sound_stone_defaults(),
})

minetest.register_node("ephesus:polished_marble", {
    description = "Ephesus Polished Marble",
    tiles = {"polished_marble.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 1},
    sounds = default.node_sound_stone_defaults(),
})


--Tiles
minetest.register_node("ephesus:tiles", {
    description = "Tiles",
    tiles = {"tuile.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 2},
    sounds = default.node_sound_stone_defaults(),
})

-- Blue mosaic
minetest.register_node("ephesus:blue_mosaic", {
    description = "Blue mosaic",
    tiles = {"blue_mosaic.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 3},
    sounds = default.node_sound_stone_defaults(),
})

--Red mosaic
minetest.register_node("ephesus:red_mosaic", {
    description = "Red Mosaic",
    tiles = {"red_mosaic.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 4},
    sounds = default.node_sound_stone_defaults(),
})

--Ivor
minetest.register_node("ephesus:ivor", {
    description = "Ivor",
    tiles = {"ivoire.png"},
    groups = {cracky = 3, stone = 1, ephesus_blocks = 5},
    sounds = default.node_sound_stone_defaults(),
    drawtype = "glasslike",
    paramtype = "light",
    sunlight_propagates = true,
    use_texture_alpha = true,
    alpha = 180 
})

--Leaves
minetest.register_node("ephesus:cypres1", {
    description = "Cypress Leaves 1",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"cypres11.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})


minetest.register_node("ephesus:cypres2", {
    description = "Cypress Leaves 2",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"cypres22.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})

minetest.register_node("ephesus:cypres3", {
    description = "Cypress Leaves 3",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"cypres33.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})

minetest.register_node("ephesus:apricot_leaves", {
    description = "Apricot Tree Leaves",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"apricot_leaves.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})

minetest.register_node("ephesus:olive_leaves", {
    description = "Olive Tree Leaves",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"olive_leaves.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})

minetest.register_node("ephesus:fig_leaves", {
    description = "Fig Tree Leaves",
    drawtype = "allfaces_optional",
    waving = 1,
    tiles = {"fig_leaves.png"},
    sunlight_propagates = true,
    is_ground_content = true,
    groups = {snappy = 2, leafdecay = 3, flammable = 2},
})


--Woods

minetest.register_node("ephesus:cypress_trunk", {
  description = "Cypress Trunk",
  drop = "ephesus:cypress_wood",
  tiles = {"cypress_trunk_top.png", "cypress_trunk_top.png",
		"cypress_trunk.png"},
  paramtype2 = "facedir",
  is_ground_content = false,
  groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
  sounds = default.node_sound_wood_defaults(),

  on_place = minetest.rotate_node
})

minetest.register_node("ephesus:apricot_trunk", {
  description = "Apricot Tree Trunk",
  drop = "ephesus:cypress_wood",
  tiles = {"apricot_trunk.png", "apricot_trunk.png",
		"apricot_trunk.png"},
  paramtype2 = "facedir",
  is_ground_content = false,
  groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
  sounds = default.node_sound_wood_defaults(),

  on_place = minetest.rotate_node
})

minetest.register_node("ephesus:olive_trunk", {
  description = "Olive Tree Trunk",
  drop = "ephesus:cypress_wood",
  tiles = {"olive_trunk.png", "olive_trunk.png",
		"olive_trunk.png"},
  paramtype2 = "facedir",
  is_ground_content = false,
  groups = {tree = 1, choppy = 2, oddly_breakable_by_hand = 1, flammable = 2},
  sounds = default.node_sound_wood_defaults(),

  on_place = minetest.rotate_node
})

minetest.register_node("ephesus:cypress_wood", {
  description = "Cypress Wood",
  drawtype = "normal",
  tiles = {"cypress_wood.png"},
  sunlight_propagates = true,
  groups = {wood = 1, choppy = 2, flammable = 2},
  sounds = default.node_sound_wood_defaults(),
})


--
-- Slab Registration
--

-- Marble Slab
stairs.register_slab("ephesus:marble_slab", "ephesus:marble",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"marble.png"},
    "Marble Slab",
    default.node_sound_stone_defaults()
)

stairs.register_slab("ephesus:polished_marble_slab", "ephesus:polished_marble",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"polished_marble.png"},
    "Ephesus Polished Marble Slab",
    default.node_sound_stone_defaults()
) 

--Tiles slab
stairs.register_slab("ephesus:tiles_slab", "ephesus:tiles",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"tuile.png"},
    "Tiles Slab",
    default.node_sound_stone_defaults()
)

--Blue Mosaic slab
stairs.register_slab("ephesus:blue_mosaic_slab", "ephesus:blue_mosaic",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"blue_mosaic.png"},
    "Blue Mosaic Slab",
    default.node_sound_stone_defaults()
)

--Red Mosaic Slab
stairs.register_slab("ephesus:red_mosaic_slab", "ephesus:red_mosaic",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"red_mosaic.png"},
    "Red Mosaic Slab",
    default.node_sound_stone_defaults()
)

--Ivor Slab 
stairs.register_slab("ephesus:ivor_slab", "ephesus:ivor",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"ivoire.png"},
    "Ivor Slab",
    default.node_sound_stone_defaults()
)


--
--Stair Registration
--

-- Marble Stair
stairs.register_stair("ephesus:marble_stair", "ephesus:marble",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"marble.png"},
    "Marble Stair",
    default.node_sound_stone_defaults()
)

stairs.register_stair("ephesus:polished_marble_stair", "ephesus:polished_marble",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"polished_marble.png"},
    "Ephesus Polished Marble Stair",
    default.node_sound_stone_defaults()
)

-- Tiles Stair
stairs.register_stair("ephesus:tiles_stair", "ephesus:tiles",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"tuile.png"},
    "Tiles Stair",
    default.node_sound_stone_defaults()
)

--Blue Mosaic Stair
stairs.register_stair("ephesus:blue_mosaic_stair", "ephesus:blue_mosaic",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"blue_mosaic.png"},
    "Blue Mosaic Stair",
    default.node_sound_stone_defaults()
)

--Blue Mosaic Stair
stairs.register_stair("ephesus:red_mosaic_stair", "ephesus:red_mosaic",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"red_mosaic.png"},
    "Red Mosaic Stair",
    default.node_sound_stone_defaults()
)

--Ivor Stair
stairs.register_stair("ephesus:ivor_stair", "ephesus:ivor",
    {cracky = 3, oddly_breakable_by_hand = 1},
    {"ivoire.png"},
    "Ivor Stair",
    default.node_sound_stone_defaults()
)

--
-- Registration of other node types
--


--Column
minetest.register_node("ephesus:marble_column", {
    description = "Marble Column",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "large_column.obj",
    groups = {cracky = 2, ephesus_blocks = 6},
})

--Column Top
minetest.register_node("ephesus:hat_column", {
    description = "Marble Column Top",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "hat_column.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
})

--Medium Column
minetest.register_node("ephesus:hat_medium", {
    description = "Medium Column",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "medium_column.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
-- Boîte de sélection (selection box)
selection_box = {
    type = "fixed",
    fixed = {
        {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}, -- Pavé d'une hauteur d'un bloc
    },
},

-- Boîte de collision (collision box)
collision_box = {
    type = "fixed",
    fixed = {
        {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}, -- Pavé d'une hauteur d'un bloc et de largeur de 0,5 bloc
    },
},

})

--Meium-Column Top
minetest.register_node("ephesus:medium_column_top", {
    description = "Medium Column Top",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "medium_hat_column.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
    -- Boîte de sélection (selection box)
selection_box = {
    type = "fixed",
    fixed = {
        {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}, -- Pavé d'une hauteur d'un bloc
    },
},

-- Boîte de collision (collision box)
collision_box = {
    type = "fixed",
    fixed = {
        {-0.25, -0.5, -0.25, 0.25, 0.5, 0.25}, -- Pavé d'une hauteur d'un bloc et de largeur de 0,5 bloc
    },
},
})

--Upper Corner
minetest.register_node("ephesus:hat_angle", {
    description = "Upper Corner",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "haut_angle.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
})

--Top
minetest.register_node("ephesus:hat", {
    description = "Top",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "haut.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
})

--Pedestal
minetest.register_node("ephesus:pedestal", {
    description = "Pedestal",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "socle.obj",
    groups = {cracky = 2, ephesus_blocks = 6},
})

--Slope Bottom
minetest.register_node("ephesus:slope_bottom", {
    description = "Marble Slope Bottom",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "pente.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
    -- Boîte de sélection (selection box)
selection_box = {
    type = "fixed",
    fixed = {
        {-0.5, -0.5, -0.5, 0.5, 0, 0.5}, -- Demi-bloc avec une hauteur de 0,5 bloc
    },
},

-- Boîte de collision (collision box)
collision_box = {
    type = "fixed",
    fixed = {
        {-0.5, -0.5, -0.5, 0.5, 0, 0.5}, -- Demi-bloc avec une hauteur de 0,5 bloc
    },
},

})

--Slope Top
minetest.register_node("ephesus:slope_top", {
    description = "Marble Slope Top",
    tiles = {"marble.png"},
    drawtype = "mesh",
    mesh = "pente_haut.obj",
    paramtype2 = "facedir",
    groups = {cracky = 2, ephesus_blocks = 6},
-- Boîte de sélection (selection box)
selection_box = {
    type = "fixed",
    fixed = {
        {-0.5, 0, -0.5, 0.5, 0.5, 0.5}, -- Demi-bloc supérieur avec une hauteur de 0,5 bloc
    },
},

-- Boîte de collision (collision box)
collision_box = {
    type = "fixed",
    fixed = {
        {-0.5, 0, -0.5, 0.5, 0.5, 0.5}, -- Demi-bloc supérieur avec une hauteur de 0,5 bloc
        {-0.5, -0.5, -0.5, 0.5, 0, 0.5}, -- Partie inférieure pour la collision
    },
},
})

-- xpanes/init.lua

-- Load support for MT game translation.
local S = minetest.get_translator("xpanes")


local function is_pane(pos)
	return minetest.get_item_group(minetest.get_node(pos).name, "pane") > 0
end

local function connects_dir(pos, name, dir)
	local aside = vector.add(pos, minetest.facedir_to_dir(dir))
	if is_pane(aside) then
		return true
	end

	local connects_to = minetest.registered_nodes[name].connects_to
	if not connects_to then
		return false
	end
	local list = minetest.find_nodes_in_area(aside, aside, connects_to)

	if #list > 0 then
		return true
	end

	return false
end

local function swap(pos, node, name, param2)
	if node.name == name and node.param2 == param2 then
		return
	end

	minetest.swap_node(pos, {name = name, param2 = param2})
end

local function update_pane(pos)
	if not is_pane(pos) then
		return
	end
	local node = minetest.get_node(pos)
	local name = node.name
	if name:sub(-5) == "_flat" then
		name = name:sub(1, -6)
	end

	local any = node.param2
	local c = {}
	local count = 0
	for dir = 0, 3 do
		c[dir] = connects_dir(pos, name, dir)
		if c[dir] then
			any = dir
			count = count + 1
		end
	end

	if count == 0 then
		swap(pos, node, name .. "_flat", any)
	elseif count == 1 then
		swap(pos, node, name .. "_flat", (any + 1) % 4)
	elseif count == 2 then
		if (c[0] and c[2]) or (c[1] and c[3]) then
			swap(pos, node, name .. "_flat", (any + 1) % 4)
		else
			swap(pos, node, name, 0)
		end
	else
		swap(pos, node, name, 0)
	end
end

minetest.register_on_placenode(function(pos, node)
	if minetest.get_item_group(node, "pane") then
		update_pane(pos)
	end
	for i = 0, 3 do
		local dir = minetest.facedir_to_dir(i)
		update_pane(vector.add(pos, dir))
	end
end)

minetest.register_on_dignode(function(pos)
	for i = 0, 3 do
		local dir = minetest.facedir_to_dir(i)
		update_pane(vector.add(pos, dir))
	end
end)

xpanes = {}
function xpanes.register_pane(name, def)
	for i = 1, 15 do
		minetest.register_alias("xpanes:" .. name .. "_" .. i, "xpanes:" .. name .. "_flat")
	end

	local flatgroups = table.copy(def.groups)
	flatgroups.pane = 1
	minetest.register_node(":xpanes:" .. name .. "_flat", {
		description = def.description,
		drawtype = "nodebox",
		paramtype = "light",
		is_ground_content = false,
		sunlight_propagates = true,
		inventory_image = def.inventory_image,
		wield_image = def.wield_image,
		paramtype2 = "facedir",
		tiles = {
			def.textures[3],
			def.textures[3],
			def.textures[3],
			def.textures[3],
			def.textures[1],
			def.textures[1]
		},
		groups = flatgroups,
		drop = "xpanes:" .. name .. "_flat",
		sounds = def.sounds,
		use_texture_alpha = def.use_texture_alpha and "blend" or "clip",
		node_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -1/32, 1/2, 1/2, 1/32}},
		},
		selection_box = {
			type = "fixed",
			fixed = {{-1/2, -1/2, -1/32, 1/2, 1/2, 1/32}},
		},
		connect_sides = { "left", "right" },
	})

	local groups = table.copy(def.groups)
	groups.pane = 1
	groups.not_in_creative_inventory = 1
	minetest.register_node(":xpanes:" .. name, {
		drawtype = "nodebox",
		paramtype = "light",
		is_ground_content = false,
		sunlight_propagates = true,
		description = def.description,
		tiles = {
			def.textures[3],
			def.textures[3],
			def.textures[1]
		},
		groups = groups,
		drop = "xpanes:" .. name .. "_flat",
		sounds = def.sounds,
		use_texture_alpha = def.use_texture_alpha and "blend" or "clip",
		node_box = {
			type = "connected",
			fixed = {{-1/32, -1/2, -1/32, 1/32, 1/2, 1/32}},
			connect_front = {{-1/32, -1/2, -1/2, 1/32, 1/2, -1/32}},
			connect_left = {{-1/2, -1/2, -1/32, -1/32, 1/2, 1/32}},
			connect_back = {{-1/32, -1/2, 1/32, 1/32, 1/2, 1/2}},
			connect_right = {{1/32, -1/2, -1/32, 1/2, 1/2, 1/32}},
		},
		connects_to = {"group:pane", "group:stone", "group:glass", "group:wood", "group:tree"},
	})

	minetest.register_craft({
		output = "xpanes:" .. name .. "_flat 16",
		recipe = def.recipe
	})
end

xpanes.register_pane("pane", {
	description = S("Braces Pane"),
	textures = {"braces.png", "", "braces.png"},
	inventory_image = "default_bracesglass.png",
	wield_image = "braces.png",
	sounds = default.node_sound_glass_defaults(),
	groups = {snappy=2, cracky=3, oddly_breakable_by_hand=3},
	recipe = {
		{"default:glass", "default:glass", "default:glass"},
		{"default:glass", "default:glass", "default:glass"}
	}
})