--[[
	**************************************
	***            Corn                ***
	**************************************
]]--

-- Load support for intllib.
local S = cucina_vegana.get_translator

local dname = S("Corn")
local pname = "corn"
local step = 7

-- corn
farming.register_plant("cucina_vegana:" .. pname, {
	description = dname .. " " .. S("Seed"),
    harvest_description = dname,
	inventory_image = "cucina_vegana_" .. pname .. "_seed.png",
	steps = step,
	minlight = cucina_vegana.plant_settings.corn_light,
	fertility = {"grassland"},
	groups = {flammable = 4, attached_node = 1},
})

minetest.override_item("cucina_vegana:" .. pname .. "_5", {visual_scale = 1.3})
minetest.override_item("cucina_vegana:" .. pname .. "_6", {visual_scale = 1.6})
minetest.override_item("cucina_vegana:" .. pname .. "_7", {visual_scale = 1.9})

-- Register for Mapgen
minetest.register_node("cucina_vegana:wild_" .. pname, {
	description = S("Wild") .. " " .. dname,
	paramtype = "light",
	walkable = false,
	drop = {
			items = {
					{items = {"cucina_vegana:seed_" .. pname .. " 3"}},
					{items = {"cucina_vegana:" .. pname .. " 4"}},
				}
			},
	drawtype = "plantlike",
	paramtype2 = "facedir",
	tiles = {"cucina_vegana_" .. pname .. "_" .. step .. ".png"},
	sunlight_propagates = true,
	groups = {snappy = 3, dig_immediate=1, flammable=2, plant=1, attached_node = 1,
                growing = 1, not_in_creative_inventory = 1},
	sounds = default.node_sound_leaves_defaults(),
	selection_box = {
			type = "fixed",
			fixed = {
				{-0.5, -0.5, -0.5, 0.5, -0.35, 0.5}, -- side f
			},
	},
	visual_scale = 1.9,
})

if(cucina_vegana.plant_settings.bonemeal) then
    table.insert(cucina_vegana.plant_settings.bonemeal_list,
								{"cucina_vegana:" .. pname .. "_", step, "cucina_vegana:seed_" .. pname})

end -- if(cucina_vegana.plant_settings.bonemeal

-- Register @ farming_nextgen
if cucina_vegana.farming_ng then
    cucina_vegana.register_farming_ng(pname, step)

end -- if(cucina_vegana.farming_ng

-- Register @ Signs_bot
if(cucina_vegana.signs_bot) then
    cucina_vegana.register_signs_bot(pname, 1, step)

end

minetest.register_decoration({
	deco_type = "simple",
	place_on = {"default:dry_dirt_with_dry_grass", "default:dirt", "default:dirt_with_grass", "default:dirt_dry"},
	sidelen = 16,
	noise_params = {
		offset = 0,
		scale = cucina_vegana.plant_settings.corn_scale,
		spread = {x = 20, y = 20, z = 20},
		seed = 6349,
		octaves = 4,
		persist = 0.6
	},
	y_min = -10,
	y_max = 150,
	decoration = "cucina_vegana:wild_corn",
})

