local modpath = core.get_modpath("mcl_small_3d_plants")

----------------------------------------------------------------------------------------------
------------------------------------- Farming Plants -----------------------------------------
----------------------------------------------------------------------------------------------

--
-- 3D Carrots
--

for i = 1, 7 do
	local sel_height, tile

	if i < 3 then
		sel_height = -0.4375
		tile = "mcl_small_3d_plants_carrot_1.png"
	elseif i < 5 then
		sel_height = -0.375
		tile = "mcl_small_3d_plants_carrot_2.png"
	else
		sel_height = -0.3125
		tile = "mcl_small_3d_plants_carrot_3.png"
	end

	core.override_item("mcl_farming:carrot_" .. i, {
		drawtype = "nodebox",
		tiles = {tile},
		node_box = {
			type = "fixed",
			fixed = {
				{-0.3125, -0.5, 0.1875, -0.1875, sel_height, 0.3125},
				{0.1875, -0.5, 0.1875, 0.3125, sel_height, 0.3125},
				{0.1875, -0.5, -0.3125, 0.3125, sel_height, -0.1875},
				{-0.3125, -0.5, -0.3125, -0.1875, sel_height, -0.1875},
			},
		},
	})
end

core.override_item("mcl_farming:carrot", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_carrot_4.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0.125, -0.125, -0.375, 0.375},
			{-0.3125, -0.375, 0.1875, -0.1875, -0.1875, 0.3125},
			{0.125, -0.5, 0.125, 0.375, -0.375, 0.375},
			{0.1875, -0.375, 0.1875, 0.3125, -0.1875, 0.3125},
			{0.125, -0.5, -0.375, 0.375, -0.375, -0.125},
			{0.1875, -0.375, -0.3125, 0.3125, -0.1875, -0.1875},
			{-0.375, -0.5, -0.375, -0.125, -0.375, -0.125},
			{-0.3125, -0.375, -0.3125, -0.1875, -0.1875, -0.1875},
		},
	},
})

--
-- 3D Potatoes
--

for k = 1, 7 do
	if k < 2 then
		core.override_item("mcl_farming:potato_" .. k, {
			drawtype = "nodebox",
			tiles = {"mcl_small_3d_plants_potatoes.png"},
			node_box = {
				type = "fixed",
				fixed = {
					{-0.25, -0.5, 0.125, -0.1875, -0.4375, 0.25},
					{0.125, -0.5, 0.1875, 0.25, -0.4375, 0.25},
					{0.1875, -0.5, -0.25, 0.25, -0.4375, -0.125},
					{-0.25, -0.5, -0.25, -0.125, -0.4375, -0.1875},
				},
			},
		})
	elseif k < 4 then
		core.override_item("mcl_farming:potato_" .. k, {
			description = "Premature Potato Plant (Stage 3)",
			drawtype = "nodebox",
			tiles = {"mcl_small_3d_plants_potatoes.png"},
			node_box = {
				type = "fixed",
				fixed = {
					{-0.25, -0.5, 0.0625, -0.125, -0.4375, 0.25},
					{0.0625, -0.5, 0.125, 0.25, -0.4375, 0.25},
					{0.125, -0.5, -0.25, 0.25, -0.4375, -0.0625},
					{-0.25, -0.5, -0.25, -0.0625, -0.4375, -0.125},
				},
			},
		})
	elseif k < 6 then
		core.override_item("mcl_farming:potato_" .. k, {
			drawtype = "nodebox",
			tiles = {"mcl_small_3d_plants_potatoes.png"},
			node_box = {
				type = "fixed",
				fixed = {
					{-0.3125, -0.5, 0.0625, -0.125, -0.4375, 0.3125},
					{0.0625, -0.5, 0.125, 0.3125, -0.4375, 0.3125},
					{0.125, -0.5, -0.3125, 0.3125, -0.4375, -0.0625},
					{-0.3125, -0.5, -0.3125, -0.0625, -0.4375, -0.125},
				},
			},
		})
	else
		core.override_item("mcl_farming:potato_" .. k, {
			drawtype = "nodebox",
			tiles = {"mcl_small_3d_plants_potatoes.png"},
			node_box = {
				type = "fixed",
				fixed = {
					{-0.3125, -0.5, 0, -0.0625, -0.4375, 0.3125},
					{0, -0.5, 0.0625, 0.3125, -0.4375, 0.3125},
					{0.0625, -0.5, -0.3125, 0.3125, -0.4375, 0},
					{-0.3125, -0.5, -0.3125, 0, -0.4375, -0.0625},
				},
			},
		})
	end
end

-- Mature plant

core.override_item("mcl_farming:potato", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_potatoes.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0, -0.0625, -0.4375, 0.375},
			{-0.3125, -0.4375, 0.0625, -0.125, -0.375, 0.3125},
			{-0.375, -0.5, -0.375, 0, -0.4375, -0.0625},
			{0, -0.5, 0.0625, 0.375, -0.4375, 0.375},
			{0.0625, -0.5, -0.375, 0.375, -0.4375, 0},
			{-0.3125, -0.4375, -0.3125, -0.0625, -0.375, -0.125},
			{0.125, -0.4375, -0.3125, 0.3125, -0.375, -0.0625},
			{0.0625, -0.4375, 0.125, 0.3125, -0.375, 0.3125},
		},
	},
})

--
-- 3D Beetroot
--

core.override_item("mcl_farming:beetroot_0", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_beetroot_1.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.5, 0.1875, -0.1875, -0.4375, 0.25},
			{0.1875, -0.5, 0.1875, 0.25, -0.4375, 0.25},
			{0.1875, -0.5, -0.25, 0.25, -0.4375, -0.1875},
			{-0.25, -0.5, -0.25, -0.1875, -0.4375, -0.1875},
		},
	},
})

core.override_item("mcl_farming:beetroot_1", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_beetroot_1.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.5, 0.1875, -0.1875, -0.375, 0.25},
			{0.1875, -0.5, 0.1875, 0.25, -0.375, 0.25},
			{0.1875, -0.5, -0.25, 0.25, -0.375, -0.1875},
			{-0.25, -0.5, -0.25, -0.1875, -0.375, -0.1875},
		},
	},
})

core.override_item("mcl_farming:beetroot_2", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_beetroot_2.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.3125, -0.5, 0.125, -0.125, -0.4375, 0.3125},
			{-0.25, -0.5, 0.1875, -0.1875, -0.3125, 0.25},
			{0.125, -0.5, 0.125, 0.3125, -0.4375, 0.3125},
			{0.1875, -0.5, 0.1875, 0.25, -0.3125, 0.25},
			{0.125, -0.5, -0.3125, 0.3125, -0.4375, -0.125},
			{0.1875, -0.5, -0.25, 0.25, -0.3125, -0.1875},
			{-0.3125, -0.5, -0.3125, -0.125, -0.4375, -0.125},
			{-0.25, -0.5, -0.25, -0.1875, -0.3125, -0.1875},
		},
	},
})

core.override_item("mcl_farming:beetroot", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_beetroot_3.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0.0625, -0.0625, -0.375, 0.375},
			{-0.3125, -0.375, 0.125, -0.125, -0.3125, 0.3125},
			{-0.25, -0.3125, 0.1875, -0.1875, -0.125, 0.25},
			{0.0625, -0.5, 0.0625, 0.375, -0.375, 0.375},
			{0.125, -0.375, 0.125, 0.3125, -0.3125, 0.3125},
			{0.1875, -0.3125, 0.1875, 0.25, -0.125, 0.25},
			{0.0625, -0.5, -0.375, 0.375, -0.375, -0.0625},
			{0.125, -0.375, -0.3125, 0.3125, -0.3125, -0.125},
			{0.1875, -0.3125, -0.25, 0.25, -0.125, -0.1875},
			{-0.375, -0.5, -0.375, -0.0625, -0.375, -0.0625},
			{-0.3125, -0.375, -0.3125, -0.125, -0.3125, -0.125},
			{-0.25, -0.3125, -0.25, -0.1875, -0.125, -0.1875},
		},
	},
})

--
-- 3D Wheat
--

for b = 1, 7 do
	local tile
	if b < 2 then
		tile = "mcl_small_3d_plants_wheat_stage_1.png"

		w1y2 = -0.4375
		w2y2 = -0.4375
		w3y2 = -0.4375
		w4y2 = -0.4375
		w5y2 = -0.4375
		w6y2 = -0.4375
		w7y2 = -0.4375
		w8y2 = -0.4375
		w9y2 = -0.4375
		w10y2 = -0.4375
		w11y2 = -0.4375
		w12y2 = -0.4375
		w13y2 = -0.4375
		w14y2 = -0.4375
		w15y2 = -0.4375
		w16y2 = -0.4375
		w17y2 = -0.4375
		w18y2 = -0.4375
		w19y2 = -0.4375
		w20y2 = -0.4375
		w21y2 = -0.4375
		w22y2 = -0.4375
		w23y2 = -0.4375
		w24y2 = -0.4375
		w25y2 = -0.4375
	elseif b == 2 then
		tile = "mcl_small_3d_plants_wheat_stage_2.png"

		w1y2 = -0.375
		w2y2 = -0.4375
		w3y2 = -0.375
		w4y2 = -0.4375
		w5y2 = -0.375
		w6y2 = -0.4375
		w7y2 = -0.375
		w8y2 = -0.4375
		w9y2 = -0.375
		w10y2 = -0.4375
		w11y2 = -0.375
		w12y2 = -0.4375
		w13y2 = -0.375
		w14y2 = -0.4375
		w15y2 = -0.375
		w16y2 = -0.4375
		w17y2 = -0.375
		w18y2 = -0.4375
		w19y2 = -0.375
		w20y2 = -0.4375
		w21y2 = -0.375
		w22y2 = -0.4375
		w23y2 = -0.375
		w24y2 = -0.4375
		w25y2 = -0.375
	elseif b == 3 then
		tile = "mcl_small_3d_plants_wheat_stage_3.png"

		w1y2 = -0.25
		w2y2 = -0.3125
		w3y2 = -0.25
		w4y2 = -0.3125
		w5y2 = -0.25
		w6y2 = -0.3125
		w7y2 = -0.25
		w8y2 = -0.3125
		w9y2 = -0.25
		w10y2 = -0.3125
		w11y2 = -0.25
		w12y2 = -0.3125
		w13y2 = -0.25
		w14y2 = -0.3125
		w15y2 = -0.25
		w16y2 = -0.3125
		w17y2 = -0.25
		w18y2 = -0.3125
		w19y2 = -0.25
		w20y2 = -0.3125
		w21y2 = -0.25
		w22y2 = -0.3125
		w23y2 = -0.25
		w24y2 = -0.3125
		w25y2 = -0.25
	elseif b == 4 then
		tile = "mcl_small_3d_plants_wheat_stage_4.png"

		w1y2 = -0.125
		w2y2 = -0.1875
		w3y2 = -0.125
		w4y2 = -0.1875
		w5y2 = -0.125
		w6y2 = -0.1875
		w7y2 = -0.125
		w8y2 = -0.1875
		w9y2 = -0.125
		w10y2 = -0.1875
		w11y2 = -0.125
		w12y2 = -0.1875
		w13y2 = -0.125
		w14y2 = -0.1875
		w15y2 = -0.125
		w16y2 = -0.1875
		w17y2 = -0.125
		w18y2 = -0.1875
		w19y2 = -0.125
		w20y2 = -0.1875
		w21y2 = -0.125
		w22y2 = -0.1875
		w23y2 = -0.125
		w24y2 = -0.1875
		w25y2 = -0.125
	elseif b == 5 then
		tile = "mcl_small_3d_plants_wheat_stage_5.png"

		w1y2 = 0
		w2y2 = -0.0625
		w3y2 = 0
		w4y2 = -0.0625
		w5y2 = 0
		w6y2 = -0.0625
		w7y2 = 0
		w8y2 = -0.0625
		w9y2 = 0
		w10y2 = -0.0625
		w11y2 = 0
		w12y2 = -0.0625
		w13y2 = 0
		w14y2 = -0.0625
		w15y2 = 0
		w16y2 = -0.0625
		w17y2 = 0
		w18y2 = -0.0625
		w19y2 = 0
		w20y2 = -0.0625
		w21y2 = 0
		w22y2 = -0.0625
		w23y2 = 0
		w24y2 = -0.0625
		w25y2 = 0
	elseif b == 6 or b == 7 then
		tile = "mcl_small_3d_plants_wheat_stage_6.png"
		if b == 7 then tile = "mcl_small_3d_plants_wheat_stage_7.png" end
		w1y2 = 0.125
		w2y2 = 0.0625
		w3y2 = 0.125
		w4y2 = 0.0625
		w5y2 = 0.125
		w6y2 = 0.0625
		w7y2 = 0.125
		w8y2 = 0.0625
		w9y2 = 0.125
		w10y2 = 0.0625
		w11y2 = 0.125
		w12y2 = 0.0625
		w13y2 = 0.125
		w14y2 = 0.0625
		w15y2 = 0.125
		w16y2 = 0.0625
		w17y2 = 0.125
		w18y2 = 0.0625
		w19y2 = 0.125
		w20y2 = 0.0625
		w21y2 = 0.125
		w22y2 = 0.0625
		w23y2 = 0.125
		w24y2 = 0.0625
		w25y2 = 0.125
	end

	core.override_item("mcl_farming:wheat_" .. b, {
		drawtype = "nodebox",
		tiles = {tile},
		node_box = {
			type = "fixed",
			fixed = {
				{-0.375, -0.5, 0.3125, -0.3125, w1y2, 0.375},
				{-0.1875, -0.5, 0.3125, -0.125, w2y2, 0.375},
				{0, -0.5, 0.3125, 0.0625, w3y2, 0.375},
				{0.1875, -0.5, 0.3125, 0.25, w4y2, 0.375},
				{0.375, -0.5, 0.3125, 0.4375, w5y2, 0.375},
				{-0.4375, -0.5, 0.125, -0.375, w6y2, 0.1875},
				{-0.25, -0.5, 0.125, -0.1875, w7y2, 0.1875},
				{-0.0625, -0.5, 0.125, 0, w8y2, 0.1875},
				{0.125, -0.5, 0.125, 0.1875, w9y2, 0.1875},
				{0.3125, -0.5, 0.125, 0.375, w10y2, 0.1875},
				{-0.375, -0.5, -0.0625, -0.3125, w11y2, 0},
				{-0.1875, -0.5, -0.0625, -0.125, w12y2, 0},
				{0, -0.5, -0.0625, 0.0625, w13y2, 0},
				{0.1875, -0.5, -0.0625, 0.25, w14y2, 0},
				{0.375, -0.5, -0.0625, 0.4375, w15y2, 0},
				{-0.4375, -0.5, -0.25, -0.375, w16y2, -0.1875},
				{-0.25, -0.5, -0.25, -0.1875, w17y2, -0.1875},
				{-0.0625, -0.5, -0.25, 0, w18y2, -0.1875},
				{0.125, -0.5, -0.25, 0.1875, w19y2, -0.1875},
				{0.3125, -0.5, -0.25, 0.375, w20y2, -0.1875},
				{-0.375, -0.5, -0.4375, -0.3125, w21y2, -0.375},
				{-0.1875, -0.5, -0.4375, -0.125, w22y2, -0.375},
				{0, -0.5, -0.4375, 0.0625, w23y2, -0.375},
				{0.1875, -0.5, -0.4375, 0.25, w24y2, -0.375},
				{0.375, -0.5, -0.4375, 0.4375, w25y2, -0.375},
			},
		},
	})
end

core.override_item("mcl_farming:wheat", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_wheat_stage_7.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0.3125, -0.3125, 0.25, 0.375},
			{-0.4375, 0.25, 0.3125, -0.3125, 0.5, 0.4375},
			{-0.1875, -0.5, 0.3125, -0.125, 0.1875, 0.375},
			{-0.25, 0.1875, 0.25, -0.125, 0.4375, 0.375},
			{0, -0.5, 0.3125, 0.0625, 0.25, 0.375},
			{-0.0625, 0.25, 0.3125, 0.0625, 0.5, 0.4375},
			{0.1875, -0.5, 0.3125, 0.25, 0.1875, 0.375},
			{0.125, 0.1875, 0.25, 0.25, 0.4375, 0.375},
			{0.375, -0.5, 0.3125, 0.4375, 0.25, 0.375},
			{0.3125, 0.25, 0.3125, 0.4375, 0.5, 0.4375},
			{-0.4375, -0.5, 0.125, -0.375, 0.1875, 0.1875},
			{-0.4375, 0.1875, 0.125, -0.3125, 0.4375, 0.25},
			{-0.25, -0.5, 0.125, -0.1875, 0.25, 0.1875},
			{-0.25, 0.25, 0.0625, -0.125, 0.5, 0.1875},
			{-0.0625, -0.5, 0.125, 0, 0.1875, 0.1875},
			{-0.0625, 0.1875, 0.125, 0.0625, 0.4375, 0.25},
			{0.125, -0.5, 0.125, 0.1875, 0.25, 0.1875},
			{0.125, 0.25, 0.0625, 0.25, 0.5, 0.1875},
			{0.3125, -0.5, 0.125, 0.375, 0.1875, 0.1875},
			{0.3125, 0.1875, 0.125, 0.4375, 0.4375, 0.25},
			{-0.375, -0.5, -0.0625, -0.3125, 0.25, 0},
			{-0.4375, 0.25, -0.0625, -0.3125, 0.5, 0.0625},
			{-0.1875, -0.5, -0.0625, -0.125, 0.1875, 0},
			{-0.25, 0.1875, -0.125, -0.125, 0.4375, 0},
			{0, -0.5, -0.0625, 0.0625, 0.25, 0},
			{-0.0625, 0.25, -0.0625, 0.0625, 0.5, 0.0625},
			{0.1875, -0.5, -0.0625, 0.25, 0.1875, 0},
			{0.125, 0.1875, -0.125, 0.25, 0.4375, 0},
			{0.375, -0.5, -0.0625, 0.4375, 0.25, 0},
			{0.3125, 0.25, -0.0625, 0.4375, 0.5, 0.0625},
			{-0.4375, -0.5, -0.25, -0.375, 0.1875, -0.1875},
			{-0.4375, 0.1875, -0.25, -0.3125, 0.4375, -0.125},
			{-0.25, -0.5, -0.25, -0.1875, 0.25, -0.1875},
			{-0.25, 0.25, -0.3125, -0.125, 0.5, -0.1875},
			{-0.0625, -0.5, -0.25, 0, 0.1875, -0.1875},
			{-0.0625, 0.1875, -0.25, 0.0625, 0.4375, -0.125},
			{0.125, -0.5, -0.25, 0.1875, 0.25, -0.1875},
			{0.125, 0.25, -0.3125, 0.25, 0.5, -0.1875},
			{0.3125, -0.5, -0.25, 0.375, 0.1875, -0.1875},
			{0.3125, 0.1875, -0.25, 0.4375, 0.4375, -0.125},
			{-0.375, -0.5, -0.4375, -0.3125, 0.25, -0.375},
			{-0.4375, 0.25, -0.4375, -0.3125, 0.5, -0.3125},
			{-0.1875, -0.5, -0.4375, -0.125, 0.25, -0.375},
			{-0.25, 0.1875, -0.5, -0.125, 0.4375, -0.375},
			{0, -0.5, -0.4375, 0.0625, 0.25, -0.375},
			{-0.0625, 0.25, -0.4375, 0.0625, 0.5, -0.3125},
			{0.1875, -0.5, -0.4375, 0.25, 0.25, -0.375},
			{0.125, 0.1875, -0.5, 0.25, 0.4375, -0.375},
			{0.375, -0.5, -0.4375, 0.4375, 0.25, -0.375},
			{0.3125, 0.25, -0.4375, 0.4375, 0.5, -0.3125},
		},
	},
})

----------------------------------------------------------------------------------------------
------------------------------------- Papyrus/Sugar cane -------------------------------------
----------------------------------------------------------------------------------------------

--
-- 3D Papyrus
--

core.override_item("mcl_core:reeds", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_papyrus.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0.25, -0.25, 0.5, 0.375},
			{0.25, -0.5, 0.25, 0.375, 0.5, 0.375},
			{0.25, -0.5, -0.375, 0.375, 0.5, -0.25},
			{-0.375, -0.5, -0.375, -0.25, 0.5, -0.25},
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
			{0.0625, -0.0625, 0, 0.1875, 0.0625, 0},
			{-0.1875, 0.1875, 0, -0.0625, 0.3125, 0},
			{-0.3125, 0.125, -0.5, -0.3125, 0.25, -0.375},
			{-0.3125, -0.1875, -0.25, -0.3125, -0.0625, -0.125},
			{0.3125, 0.0625, -0.25, 0.3125, 0.1875, -0.125},
			{0.3125, -0.25, -0.5, 0.3125, -0.125, -0.375},
			{0.125, -0.125, 0.3125, 0.3125, 0, 0.3125},
			{0.25, 0.1875, 0.3125, 0.5, 0.3125, 0.3125},
			{-0.25, 0.125, 0.3125, -0.125, 0.25, 0.3125},
			{-0.5, -0.25, 0.3125, -0.375, -0.125, 0.3125},
		},
	},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.375, -0.5, 0.25, -0.25, 0.5, 0.375},
			{0.25, -0.5, 0.25, 0.375, 0.5, 0.375},
			{0.25, -0.5, -0.375, 0.375, 0.5, -0.25},
			{-0.375, -0.5, -0.375, -0.25, 0.5, -0.25},
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
			{0.0625, -0.0625, 0, 0.1875, 0.0625, 0},
			{-0.1875, 0.1875, 0, -0.0625, 0.3125, 0},
			{-0.3125, 0.125, -0.5, -0.3125, 0.25, -0.375},
			{-0.3125, -0.1875, -0.25, -0.3125, -0.0625, -0.125},
			{0.3125, 0.0625, -0.25, 0.3125, 0.1875, -0.125},
			{0.3125, -0.25, -0.5, 0.3125, -0.125, -0.375},
			{0.125, -0.125, 0.3125, 0.3125, 0, 0.3125},
			{0.25, 0.1875, 0.3125, 0.5, 0.3125, 0.3125},
			{-0.25, 0.125, 0.3125, -0.125, 0.25, 0.3125},
			{-0.5, -0.25, 0.3125, -0.375, -0.125, 0.3125},
		},
	},
})

----------------------------------------------------------------------------------------------
------------------------------------- Mushrooms ----------------------------------------------
----------------------------------------------------------------------------------------------
--
-- 3D Mushrooms
--

core.override_item("mcl_mushrooms:mushroom_brown", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_mushroom_brown.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.375, 0.0625},
			{-0.1875, -0.375, -0.1875, 0.1875, -0.25, 0.1875},
			{-0.125, -0.25, -0.125, 0.125, -0.1875, 0.125},
		},
	},
})

core.override_item("mcl_mushrooms:mushroom_red", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_mushroom_red.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.375, 0.0625},
			{-0.1875, -0.375, -0.1875, 0.1875, -0.25, 0.1875},
			{-0.125, -0.25, -0.125, 0.125, -0.1875, 0.125},
		},
	},
})

----------------------------------------------------------------------------------------------
------------------------------------- Flowers ------------------------------------------------
----------------------------------------------------------------------------------------------

--
-- 3D Flowers
--

core.override_item("mcl_flowers:tulip_red", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_tulip_red.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
			{-0.0625, -0.1875, 0.0625, 0.0625, -0.0625, 0.125},
			{-0.0625, -0.1875, -0.125, 0.0625, -0.0625, -0.0625},
			{0.0625, -0.1875, -0.0625, 0.125, -0.0625, 0.0625},
			{-0.125, -0.1875, -0.0625, -0.0625, -0.0625, 0.0625},
			{-0.1875, -0.4375, 0, -0.0625, -0.375, 0},
			{-0.25, -0.375, 0, -0.125, -0.3125, 0},
			{0.0625, -0.4375, 0, 0.1875, -0.375, 0},
			{0.125, -0.375, 0, 0.25, -0.3125, 0},
			{0, -0.4375, -0.1875, 0, -0.375, -0.0625},
			{0, -0.375, -0.25, 0, -0.3125, -0.125},
			{0, -0.4375, 0.0625, 0, -0.375, 0.1875},
			{0, -0.375, 0.125, 0, -0.3125, 0.25},
			{-0.125, -0.0625, 0.0625, -0.0625, 0, 0.125},
			{-0.125, -0.0625, -0.125, -0.0625, 0, -0.0625},
			{0.0625, -0.0625, -0.125, 0.125, 3.72529e-09, -0.0625},
			{0.0625, -0.0625, 0.0625, 0.125, 7.45058e-09, 0.125},
			{0.125, -0.0625, -0.0625, 0.1875, 0.0625, 0.0625},
			{-0.1875, -0.0625, -0.0625, -0.125, 0.0625, 0.0625},
			{-0.0625, -0.0625, 0.125, 0.0625, 0.0625, 0.1875},
			{-0.0625, -0.0625, -0.1875, 0.0625, 0.0625, -0.125},
		},
	},
})

core.override_item("mcl_flowers:tulip_orange", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_tulip.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
			{-0.0625, -0.1875, 0.0625, 0.0625, -0.0625, 0.125},
			{-0.0625, -0.1875, -0.125, 0.0625, -0.0625, -0.0625},
			{0.0625, -0.1875, -0.0625, 0.125, -0.0625, 0.0625},
			{-0.125, -0.1875, -0.0625, -0.0625, -0.0625, 0.0625},
			{-0.1875, -0.4375, 0, -0.0625, -0.375, 0},
			{-0.25, -0.375, 0, -0.125, -0.3125, 0},
			{0.0625, -0.4375, 0, 0.1875, -0.375, 0},
			{0.125, -0.375, 0, 0.25, -0.3125, 0},
			{0, -0.4375, -0.1875, 0, -0.375, -0.0625},
			{0, -0.375, -0.25, 0, -0.3125, -0.125},
			{0, -0.4375, 0.0625, 0, -0.375, 0.1875},
			{0, -0.375, 0.125, 0, -0.3125, 0.25},
			{-0.125, -0.0625, 0.0625, -0.0625, 0, 0.125},
			{-0.125, -0.0625, -0.125, -0.0625, 0, -0.0625},
			{0.0625, -0.0625, -0.125, 0.125, 3.72529e-09, -0.0625},
			{0.0625, -0.0625, 0.0625, 0.125, 7.45058e-09, 0.125},
			{0.125, -0.0625, -0.0625, 0.1875, 0.0625, 0.0625},
			{-0.1875, -0.0625, -0.0625, -0.125, 0.0625, 0.0625},
			{-0.0625, -0.0625, 0.125, 0.0625, 0.0625, 0.1875},
			{-0.0625, -0.0625, -0.1875, 0.0625, 0.0625, -0.125},
		},
	},
})

core.override_item("mcl_flowers:tulip_pink", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_tulip_pink.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
			{-0.0625, -0.1875, 0.0625, 0.0625, -0.0625, 0.125},
			{-0.0625, -0.1875, -0.125, 0.0625, -0.0625, -0.0625},
			{0.0625, -0.1875, -0.0625, 0.125, -0.0625, 0.0625},
			{-0.125, -0.1875, -0.0625, -0.0625, -0.0625, 0.0625},
			{-0.1875, -0.4375, 0, -0.0625, -0.375, 0},
			{-0.25, -0.375, 0, -0.125, -0.3125, 0},
			{0.0625, -0.4375, 0, 0.1875, -0.375, 0},
			{0.125, -0.375, 0, 0.25, -0.3125, 0},
			{0, -0.4375, -0.1875, 0, -0.375, -0.0625},
			{0, -0.375, -0.25, 0, -0.3125, -0.125},
			{0, -0.4375, 0.0625, 0, -0.375, 0.1875},
			{0, -0.375, 0.125, 0, -0.3125, 0.25},
			{-0.125, -0.0625, 0.0625, -0.0625, 0, 0.125},
			{-0.125, -0.0625, -0.125, -0.0625, 0, -0.0625},
			{0.0625, -0.0625, -0.125, 0.125, 3.72529e-09, -0.0625},
			{0.0625, -0.0625, 0.0625, 0.125, 7.45058e-09, 0.125},
			{0.125, -0.0625, -0.0625, 0.1875, 0.0625, 0.0625},
			{-0.1875, -0.0625, -0.0625, -0.125, 0.0625, 0.0625},
			{-0.0625, -0.0625, 0.125, 0.0625, 0.0625, 0.1875},
			{-0.0625, -0.0625, -0.1875, 0.0625, 0.0625, -0.125},
		},
	},
})

core.override_item("mcl_flowers:tulip_white", {
	drawtype = "nodebox",
	tiles = {"mcl_small_3d_plants_tulip_white.png"},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
			{-0.0625, -0.1875, 0.0625, 0.0625, -0.0625, 0.125},
			{-0.0625, -0.1875, -0.125, 0.0625, -0.0625, -0.0625},
			{0.0625, -0.1875, -0.0625, 0.125, -0.0625, 0.0625},
			{-0.125, -0.1875, -0.0625, -0.0625, -0.0625, 0.0625},
			{-0.1875, -0.4375, 0, -0.0625, -0.375, 0},
			{-0.25, -0.375, 0, -0.125, -0.3125, 0},
			{0.0625, -0.4375, 0, 0.1875, -0.375, 0},
			{0.125, -0.375, 0, 0.25, -0.3125, 0},
			{0, -0.4375, -0.1875, 0, -0.375, -0.0625},
			{0, -0.375, -0.25, 0, -0.3125, -0.125},
			{0, -0.4375, 0.0625, 0, -0.375, 0.1875},
			{0, -0.375, 0.125, 0, -0.3125, 0.25},
			{-0.125, -0.0625, 0.0625, -0.0625, 0, 0.125},
			{-0.125, -0.0625, -0.125, -0.0625, 0, -0.0625},
			{0.0625, -0.0625, -0.125, 0.125, 3.72529e-09, -0.0625},
			{0.0625, -0.0625, 0.0625, 0.125, 7.45058e-09, 0.125},
			{0.125, -0.0625, -0.0625, 0.1875, 0.0625, 0.0625},
			{-0.1875, -0.0625, -0.0625, -0.125, 0.0625, 0.0625},
			{-0.0625, -0.0625, 0.125, 0.0625, 0.0625, 0.1875},
			{-0.0625, -0.0625, -0.1875, 0.0625, 0.0625, -0.125},
		},
	},
})

core.override_item("mcl_flowers:allium", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_allium_top.png",
		"mcl_small_3d_plants_allium_top.png",
		"mcl_small_3d_plants_allium.png",
		"mcl_small_3d_plants_allium.png",
		"mcl_small_3d_plants_allium.png",
		"mcl_small_3d_plants_allium.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.125, 0.0625},
			{-0.125, 0.125, -0.125, 0.125, 0.1875, 0.125},
			{-0.1875, 0.1875, -0.1875, 0.1875, 0.3125, 0.1875},
			{-0.125, 0.25, -0.25, 0.125, 0.3125, 0.25},
			{-0.25, 0.25, -0.125, 0.25, 0.3125, 0.125},
			{-0.1875, 0.3125, -0.125, 0.1875, 0.375, 0.125},
			{-0.125, 0.3125, -0.1875, 0.125, 0.375, 0.1875},
			{-0.125, 0.375, -0.125, 0.125, 0.4375, 0.125},
			{-0.0625, 0.4375, -0.0625, 0.0625, 0.5, 0.0625},
			{0, -0.5, 0.0625, 0, -0.3125, 0.125},
			{0, -0.4375, 0.125, 0, -0.25, 0.1875},
			{0, -0.3125, 0.1875, 0, -0.125, 0.25},
			{0, -0.5, -0.125, 0, -0.3125, -0.0625},
			{0, -0.4375, -0.1875, 0, -0.25, -0.125},
			{0, -0.3125, -0.25, 0, -0.125, -0.1875},
			{0.0625, -0.5, 0, 0.125, -0.3125, 1.49012e-08},
			{0.125, -0.4375, 0, 0.1875, -0.25, 1.49012e-08},
			{0.1875, -0.3125, 0, 0.25, -0.125, 1.49012e-08},
			{-0.125, -0.5, 0, -0.0625, -0.3125, 1.49012e-08},
			{-0.1875, -0.4375, 0, -0.125, -0.25, 1.49012e-08},
			{-0.25, -0.3125, 0, -0.1875, -0.125, 1.49012e-08},
		},
	},
})

core.override_item("mcl_flowers:azure_bluet", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_azure_bluet_top.png",
		"mcl_small_3d_plants_azure_bluet_top.png",
		"mcl_small_3d_plants_azure_bluet.png",
		"mcl_small_3d_plants_azure_bluet.png",
		"mcl_small_3d_plants_azure_bluet.png",
		"mcl_small_3d_plants_azure_bluet.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.3125, -0.5, 0.25, -0.25, -0.3125, 0.3125},
			{-0.375, -0.3125, 0.25, -0.1875, -0.3125, 0.3125},
			{-0.3125, -0.3125, 0.1875, -0.25, -0.3125, 0.375},
			{-0.25, -0.5, 0, -0.1875, -0.25, 0.0625},
			{-0.3125, -0.25, 0, -0.125, -0.25, 0.0625},
			{-0.25, -0.25, -0.0625, -0.1875, -0.25, 0.125},
			{-0.3125, -0.5, -0.25, -0.25, -0.3125, -0.1875},
			{-0.375, -0.3125, -0.25, -0.1875, -0.3125, -0.1875},
			{-0.3125, -0.3125, -0.3125, -0.25, -0.3125, -0.125},
			{-0.0625, -0.5, -0.3125, 6.33299e-08, -0.25, -0.25},
			{-0.125, -0.25, -0.3125, 0.0624999, -0.25, -0.25},
			{-0.0625, -0.25, -0.375, -5.02914e-08, -0.25, -0.1875},
			{0.0625, -0.5, 0.0625, 0.125, -0.3125, 0.125},
			{0, -0.3125, 0.0625, 0.1875, -0.3125, 0.125},
			{0.0625, -0.3125, 0, 0.125, -0.3125, 0.1875},
			{-0.0625, -0.5, -0.0625, 5.7742e-08, -0.1875, 1.22935e-07},
			{-0.125, -0.1875, -0.0625, 0.0624999, -0.1875, 3.72529e-08},
			{-0.0625, -0.1875, -0.125, -3.72529e-08, -0.1875, 0.0625},
			{-0.125, -0.5, 0.1875, -0.0624999, -0.1875, 0.25},
			{-0.1875, -0.1875, 0.1875, -1.00583e-07, -0.1875, 0.25},
			{-0.125, -0.1875, 0.125, -0.0625, -0.1875, 0.3125},
			{0.125, -0.5, -0.1875, 0.1875, -0.3125, -0.125},
			{0.0625, -0.3125, -0.1875, 0.25, -0.3125, -0.125},
			{0.125, -0.3125, -0.25, 0.1875, -0.3125, -0.0625},
			{0.125, -0.5, 0.25, 0.1875, -0.1875, 0.3125},
			{0.125, -0.1875, 0.1875, 0.1875, -0.1875, 0.375},
			{0.0625, -0.1875, 0.25, 0.25, -0.1875, 0.3125},
			{0.25, -0.5, 0.125, 0.3125, -0.25, 0.1875},
			{0.1875, -0.25, 0.125, 0.375, -0.25, 0.1875},
			{0.25, -0.25, 0.0625, 0.3125, -0.25, 0.25},
			{0.3125, -0.5, -0.375, 0.375, -0.25, -0.3125},
			{0.25, -0.25, -0.375, 0.4375, -0.25, -0.3125},
			{0.3125, -0.25, -0.4375, 0.375, -0.25, -0.25},
			{0.3125, -0.5, -0.0625, 0.375, -0.375, 1.02445e-07},
			{0.25, -0.375, -0.0625, 0.4375, -0.375, -3.72529e-08},
			{0.3125, -0.375, -0.125, 0.375, -0.375, 0.0625},
		},
	},
})

core.override_item("mcl_flowers:oxeye_daisy", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_oxeye_daisy_top.png",
		"mcl_small_3d_plants_oxeye_daisy_top.png",
		"mcl_small_3d_plants_oxeye_daisy.png",
		"mcl_small_3d_plants_oxeye_daisy.png",
		"mcl_small_3d_plants_oxeye_daisy.png",
		"mcl_small_3d_plants_oxeye_daisy.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, 0.0625, 0, 0.375, 0.125},
			{-0.125, 0.375, 0.0625, 0.0625, 0.375, 0.125},
			{-0.0625, 0.375, 0, 0, 0.375, 0.1875},
			{-0.1875, -0.5, 0.1875, -0.125, 0.25, 0.25},
			{-0.25, 0.25, 0.1875, -0.0625, 0.25, 0.25},
			{-0.1875, 0.25, 0.125, -0.125, 0.25, 0.3125},
			{-0.1875, -0.5, -0.0625, -0.125, 0.25, -5.58794e-08},
			{-0.25, 0.25, -0.0625, -0.0625, 0.25, 3.72529e-09},
			{-0.1875, 0.25, -0.125, -0.125, 0.25, 0.0625},
			{0.0625, -0.5, -0.0625, 0.125, 0.25, -5.58794e-08},
			{0, 0.25, -0.0625, 0.1875, 0.25, 3.72529e-09},
			{0.0625, 0.25, -0.125, 0.125, 0.25, 0.0625},
			{0.0625, -0.5, 0.1875, 0.125, 0.25, 0.25},
			{0, 0.25, 0.1875, 0.1875, 0.25, 0.25},
			{0.0625, 0.25, 0.125, 0.125, 0.25, 0.3125},
			{-0.0625, -0.5, 0.3125, 2.98023e-08, 0.125, 0.375},
			{-0.125, 0.125, 0.3125, 0.0625, 0.125, 0.375},
			{-0.0625, 0.125, 0.25, -2.98023e-08, 0.125, 0.4375},
			{-0.0625, -0.5, -0.1875, 2.98023e-08, 0.125, -0.125},
			{-0.125, 0.125, -0.1875, 0.0625, 0.125, -0.125},
			{-0.0625, 0.125, -0.25, -2.98023e-08, 0.125, -0.0625},
			{-0.3125, -0.5, 0.0625, -0.25, 0.125, 0.125},
			{-0.375, 0.125, 0.0625, -0.1875, 0.125, 0.125},
			{-0.3125, 0.125, 0, -0.25, 0.125, 0.1875},
			{0.1875, -0.5, 0.0625, 0.25, 0.125, 0.125},
			{0.125, 0.125, 0.0625, 0.3125, 0.125, 0.125},
			{0.1875, 0.125, 0, 0.25, 0.125, 0.1875},
			{-0.3125, -0.5, 0.3125, -0.25, 0, 0.375},
			{-0.375, 0, 0.3125, -0.1875, 0, 0.375},
			{-0.3125, 0, 0.25, -0.25, 0, 0.4375},
			{0.1875, -0.5, 0.3125, 0.25, 0, 0.375},
			{0.125, 0, 0.3125, 0.3125, 0, 0.375},
			{0.1875, 0, 0.25, 0.25, 0, 0.4375},
			{0.1875, -0.5, -0.1875, 0.25, 0, -0.125},
			{0.125, 0, -0.1875, 0.3125, 0, -0.125},
			{0.1875, 0, -0.25, 0.25, 0, -0.0625},
			{-0.3125, -0.5, -0.1875, -0.25, 0, -0.125},
			{-0.375, 0, -0.1875, -0.1875, 0, -0.125},
			{-0.3125, 0, -0.25, -0.25, 0, -0.0625},
			{-0.1875, -0.5, -0.3125, -0.125, -0.125, -0.25},
			{-0.25, -0.125, -0.3125, -0.0625001, -0.125, -0.25},
			{-0.1875, -0.125, -0.375, -0.125, -0.125, -0.1875},
			{0.0625, -0.5, -0.3125, 0.125, -0.125, -0.25},
			{0, -0.125, -0.3125, 0.1875, -0.125, -0.25},
			{0.0625, -0.125, -0.375, 0.125, -0.125, -0.1875},
			{0.3125, -0.5, -0.3125, 0.375, -0.125, -0.25},
			{0.25, -0.125, -0.3125, 0.4375, -0.125, -0.25},
			{0.3125, -0.125, -0.375, 0.375, -0.125, -0.1875},
			{0.3125, -0.5, -0.0625, 0.375, -0.125, 6.70552e-08},
			{0.25, -0.125, -0.0625, 0.4375, -0.125, 2.23517e-08},
			{0.3125, -0.125, -0.125, 0.375, -0.125, 0.0625},
			{0.3125, -0.5, 0.1875, 0.375, -0.125, 0.25},
			{0.25, -0.125, 0.1875, 0.4375, -0.125, 0.25},
			{0.3125, -0.125, 0.125, 0.375, -0.125, 0.3125},
			{-0.375, -0.5, -0.375, -0.3125, -0.125, -0.3125},
			{-0.4375, -0.125, -0.375, -0.25, -0.125, -0.3125},
			{-0.375, -0.125, -0.4375, -0.3125, -0.125, -0.25},
		},
	},
})

core.override_item("mcl_flowers:dandelion", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_dandelion_yellow_top.png",
		"mcl_small_3d_plants_dandelion_yellow_top.png",
		"mcl_small_3d_plants_dandelion_yellow.png",
		"mcl_small_3d_plants_dandelion_yellow.png",
		"mcl_small_3d_plants_dandelion_yellow.png",
		"mcl_small_3d_plants_dandelion_yellow.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{0, -0.5, -0.0625, 0.0625, 0.3125, 3.72529e-09},
			{-0.125, 0.3125, -0.1875, 0.1875, 0.375, 0.125},
			{-0.0625, 0.375, -0.125, 0.125, 0.4375, 0.0625},
			{0.0625, -0.5, 0, 0.0625, -0.3125, 0.0625},
			{0.0625, -0.4375, 0.0625, 0.0625, -0.25, 0.125},
			{0.0625, -0.3125, 0.125, 0.0625, -0.125, 0.1875},
			{0.0625, -0.4375, -0.125, 0.0625, -0.25, -0.0625},
			{0.0625, -0.375, -0.1875, 0.0625, -0.1875, -0.125},
			{0.0625, -0.25, -0.25, 0.0625, -0.0624999, -0.1875},
			{-0.0625, -0.5, -0.0625, 7.45058e-09, -0.3125, -0.0625},
			{-0.125, -0.4375, -0.0625, -0.0625, -0.25, -0.0625},
			{-0.1875, -0.3125, -0.0625, -0.125, -0.125, -0.0625},
			{0.0625, -0.4375, -0.0625, 0.125, -0.25, -0.0625},
			{0.125, -0.375, -0.0625, 0.1875, -0.1875, -0.0625},
			{0.1875, -0.25, -0.0625, 0.25, -0.0624999, -0.0625},
		},
	},
})

core.override_item("mcl_flowers:blue_orchid", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_blue_orchid_top.png",
		"mcl_small_3d_plants_blue_orchid_top.png",
		"mcl_small_3d_plants_blue_orchid.png",
		"mcl_small_3d_plants_blue_orchid.png",
		"mcl_small_3d_plants_blue_orchid.png",
		"mcl_small_3d_plants_blue_orchid.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, 0, 0, -0.3125, 0.0625},
			{-0.0625, -0.375, -0.0625, 0, -0.1875, 0},
			{-0.0625, -0.25, 0, 0, -0.0625, 0.0625},
			{-0.0625, -0.125, -0.0625, 0, -0.0625, 0},
			{-0.0625, -0.125, 0.0625, 0, -0.0625, 0.125},
			{0, -0.125, 0, 0.0625, -0.0625, 0.0625},
			{-0.125, -0.125, 0, -0.0625, -0.0625, 0.0625},
			{-0.1875, -0.0625, 0, -0.125, 0.0625, 0.0625},
			{0.0625, -0.0625, 0, 0.125, 0.0625, 0.0625},
			{-0.0625, -0.0625, 0.125, -2.98023e-08, 0.0625, 0.1875},
			{-0.0625, -0.0625, -0.125, -2.98023e-08, 0.0625, -0.0625},
			{-0.0625, 0.0625, -0.1875, -2.98023e-08, 0.125, -0.125},
			{-0.0625, 0.0625, 0.1875, -2.98023e-08, 0.125, 0.25},
			{0.125, 0.0625, 0, 0.1875, 0.125, 0.0625},
			{-0.25, 0.0625, 0, -0.1875, 0.125, 0.0625},
			{-0.25, 0.125, 0, -0.1875, 0.1875, 0.0625},
			{-0.0625, 0.125, 0.1875, 4.47035e-08, 0.1875, 0.25},
			{-0.0625, 0.125, -0.1875, 4.47035e-08, 0.1875, -0.125},
			{0.125, 0.125, 0, 0.1875, 0.1875, 0.0625},
			{0.125, 0.125, -0.0625, 0.1875, 0.1875, 1.11759e-08},
			{0.125, 0.125, 0.0625, 0.1875, 0.1875, 0.125},
			{0.1875, 0.125, 0, 0.25, 0.1875, 0.0625},
			{0.0625, 0.125, 0, 0.125, 0.1875, 0.0625},
			{-0.0625, 0.125, -0.125, 2.98023e-08, 0.1875, -0.0625},
			{-0.0625, 0.125, -0.25, 2.98023e-08, 0.1875, -0.1875},
			{0, 0.125, -0.1875, 0.0625, 0.1875, -0.125},
			{-0.125, 0.125, -0.1875, -0.0625, 0.1875, -0.125},
			{-0.25, 0.125, -0.0625, -0.1875, 0.1875, -2.23517e-08},
			{-0.25, 0.125, 0.0625, -0.1875, 0.1875, 0.125},
			{-0.3125, 0.125, 0, -0.25, 0.1875, 0.0625},
			{-0.1875, 0.125, 0, -0.125, 0.1875, 0.0625},
			{-0.0625, 0.125, 0.125, -3.35276e-08, 0.1875, 0.1875},
			{-0.0625, 0.125, 0.25, -3.35276e-08, 0.1875, 0.3125},
			{0, 0.125, 0.1875, 0.0625, 0.1875, 0.25},
			{-0.125, 0.125, 0.1875, -0.0625, 0.1875, 0.25},
			{-0.0625, 0.1875, 0.1875, -2.6077e-08, 0.25, 0.25},
			{-0.0625, 0.1875, -0.1875, -2.6077e-08, 0.25, -0.125},
			{-0.25, 0.1875, 0, -0.1875, 0.25, 0.0624999},
			{0.125, 0.1875, 0, 0.1875, 0.25, 0.0624999},
			{0.0625, 0.0625, 0, 0.125, 0.125, 0.0624999},
			{-0.0625, 0.0625, 0.125, -2.98023e-08, 0.125, 0.1875},
			{-0.1875, 0.0625, 0, -0.125, 0.125, 0.0624999},
			{-0.0625, 0.0625, -0.125, -4.09782e-08, 0.125, -0.0625001},
		},
	},
})

core.override_item("mcl_flowers:poppy", {
	drawtype = "nodebox",
	tiles = {
		"mcl_small_3d_plants_poppy_top.png",
		"mcl_small_3d_plants_poppy_top.png",
		"mcl_small_3d_plants_poppy_side.png",
		"mcl_small_3d_plants_poppy_side.png",
		"mcl_small_3d_plants_poppy_side.png",
		"mcl_small_3d_plants_poppy_side.png",
	},
	node_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.5, 0.1875, -0.1875, 0.375, 0.25},
			{-0.4375, 0.375, 0.125, -0.25, 0.375, 0.3125},
			{-0.1875, 0.375, 0.125, -1.63913e-07, 0.375, 0.3125},
			{-0.1875, -0.5, -0.25, -0.125, 0.25, -0.1875},
			{-0.25, 0.25, -0.1875, -0.0625002, 0.25, -1.49012e-08},
			{-0.25, 0.25, -0.4375, -0.0625003, 0.25, -0.25},
			{0.1875, -0.5, -0.0625, 0.25, 0.0625, -1.11759e-08},
			{0.125, 0.0625, -0.25, 0.3125, 0.0625, -0.0625},
			{0.125, 0.0625, 0, 0.3125, 0.0625, 0.1875},
		},
	},
})

----------------------------------------------------------------------------------------------
------------------------------------- Nether Wart --------------------------------------------
----------------------------------------------------------------------------------------------

if core.get_modpath("mcl_nether") then
	core.override_item("mcl_nether:nether_wart_0", {
		tiles = {
			"mcl_small_3d_plants_nether_wart_stage_0_top.png",
			"mcl_small_3d_plants_nether_wart_stage_0_top.png",
			"mcl_small_3d_plants_nether_wart_stage_0.png",
			"mcl_small_3d_plants_nether_wart_stage_0.png",
			"mcl_small_3d_plants_nether_wart_stage_0.png",
			"mcl_small_3d_plants_nether_wart_stage_0.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.375, -0.5, -0.375, -0.3125, -0.3125, -0.3125},
				{0.3125, -0.5, -0.375, 0.375, -0.3125, -0.3125},
				{0.3125, -0.5, 0.3125, 0.375, -0.3125, 0.375},
				{-0.375, -0.5, 0.3125, -0.3125, -0.3125, 0.375},
				{-0.1875, -0.5, 0.125, -0.125, -0.25, 0.1875},
				{0.125, -0.5, 0.125, 0.1875, -0.25, 0.1875},
				{0.125, -0.5, -0.1875, 0.1875, -0.25, -0.125},
				{-0.1875, -0.5, -0.1875, -0.125, -0.25, -0.125},
			},
		},
	})

	core.override_item("mcl_nether:nether_wart_1", {
		tiles = {
			"mcl_small_3d_plants_nether_wart_stage_1_top.png",
			"mcl_small_3d_plants_nether_wart_stage_1_top.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.375, -0.5, -0.375, -0.3125, -0.3125, -0.3125},
				{-0.375, -0.5, 0.3125, -0.3125, -0.3125, 0.375},
				{0.3125, -0.5, 0.3125, 0.375, -0.3125, 0.375},
				{0.3125, -0.5, -0.375, 0.375, -0.3125, -0.3125},
				{0.125, -0.5, -0.1875, 0.1875, -0.25, -0.125},
				{0.125, -0.5, 0.125, 0.1875, -0.25, 0.1875},
				{-0.1875, -0.5, 0.125, -0.125, -0.25, 0.1875},
				{-0.1875, -0.5, -0.1875, -0.125, -0.25, -0.125},
				{-0.4375, -0.375, -0.4375, -0.375, -0.1875, -0.375},
				{0.375, -0.375, -0.4375, 0.4375, -0.1875, -0.375},
				{0.375, -0.375, 0.375, 0.4375, -0.1875, 0.4375},
				{-0.4375, -0.375, 0.375, -0.375, -0.1875, 0.4375},
				{-0.25, -0.3125, 0.1875, -0.1875, -0.125, 0.25},
				{0.1875, -0.3125, 0.1875, 0.25, -0.125, 0.25},
				{0.1875, -0.3125, -0.25, 0.25, -0.125, -0.1875},
				{-0.25, -0.3125, -0.25, -0.1875, -0.125, -0.1875},
				{-0.3125, -0.125, -0.1875, -0.25, -0.0625, -0.125},
				{-0.3125, -0.125, 0.125, -0.25, -0.0625, 0.1875},
				{0.25, -0.125, 0.125, 0.3125, -0.0625, 0.1875},
				{0.25, -0.125, -0.1875, 0.3125, -0.0625, -0.125},
				{0.4375, -0.1875, -0.375, 0.5, -0.125, -0.3125},
				{-0.5, -0.1875, -0.375, -0.4375, -0.125, -0.3125},
				{-0.5, -0.1875, 0.3125, -0.4375, -0.125, 0.375},
				{0.4375, -0.1875, 0.3125, 0.5, -0.125, 0.375},
			},
		},
	})

	core.override_item("mcl_nether:nether_wart_2", {
		tiles = {
			"mcl_small_3d_plants_nether_wart_stage_1_top.png",
			"mcl_small_3d_plants_nether_wart_stage_1_top.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
			"mcl_small_3d_plants_nether_wart_stage_1.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.375, -0.5, -0.375, -0.3125, -0.3125, -0.3125},
				{-0.375, -0.5, 0.3125, -0.3125, -0.3125, 0.375},
				{0.3125, -0.5, 0.3125, 0.375, -0.3125, 0.375},
				{0.3125, -0.5, -0.375, 0.375, -0.3125, -0.3125},
				{0.125, -0.5, -0.1875, 0.1875, -0.25, -0.125},
				{0.125, -0.5, 0.125, 0.1875, -0.25, 0.1875},
				{-0.1875, -0.5, 0.125, -0.125, -0.25, 0.1875},
				{-0.1875, -0.5, -0.1875, -0.125, -0.25, -0.125},
				{-0.4375, -0.375, -0.4375, -0.375, -0.1875, -0.375},
				{0.375, -0.375, -0.4375, 0.4375, -0.1875, -0.375},
				{0.375, -0.375, 0.375, 0.4375, -0.1875, 0.4375},
				{-0.4375, -0.375, 0.375, -0.375, -0.1875, 0.4375},
				{-0.25, -0.3125, 0.1875, -0.1875, -0.125, 0.25},
				{0.1875, -0.3125, 0.1875, 0.25, -0.125, 0.25},
				{0.1875, -0.3125, -0.25, 0.25, -0.125, -0.1875},
				{-0.25, -0.3125, -0.25, -0.1875, -0.125, -0.1875},
				{-0.3125, -0.125, -0.1875, -0.25, -0.0625, -0.125},
				{-0.3125, -0.125, 0.125, -0.25, -0.0625, 0.1875},
				{0.25, -0.125, 0.125, 0.3125, -0.0625, 0.1875},
				{0.25, -0.125, -0.1875, 0.3125, -0.0625, -0.125},
				{0.4375, -0.1875, -0.375, 0.5, -0.125, -0.3125},
				{-0.5, -0.1875, -0.375, -0.4375, -0.125, -0.3125},
				{-0.5, -0.1875, 0.3125, -0.4375, -0.125, 0.375},
				{0.4375, -0.1875, 0.3125, 0.5, -0.125, 0.375},
			},
		},
	})

	core.override_item("mcl_nether:nether_wart", {
		tiles = {
			"mcl_small_3d_plants_nether_wart_stage_2_top.png",
			"mcl_small_3d_plants_nether_wart_stage_2_top.png",
			"mcl_small_3d_plants_nether_wart_stage_2.png",
			"mcl_small_3d_plants_nether_wart_stage_2.png",
			"mcl_small_3d_plants_nether_wart_stage_2.png",
			"mcl_small_3d_plants_nether_wart_stage_2.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.375, -0.5, -0.375, -0.3125, -0.3125, -0.3125},
				{0.3125, -0.5, -0.375, 0.375, -0.3125, -0.3125},
				{0.3125, -0.5, 0.3125, 0.375, -0.3125, 0.375},
				{-0.375, -0.5, 0.3125, -0.3125, -0.3125, 0.375},
				{-0.1875, -0.5, 0.125, -0.125, -0.25, 0.1875},
				{0.125, -0.5, 0.125, 0.1875, -0.25, 0.1875},
				{0.125, -0.5, -0.1875, 0.1875, -0.25, -0.125},
				{-0.1875, -0.5, -0.1875, -0.125, -0.25, -0.125},
				{-0.4375, -0.375, -0.4375, -0.375, -0.1875, -0.375},
				{0.375, -0.375, -0.4375, 0.4375, -0.1875, -0.375},
				{0.375, -0.375, 0.375, 0.4375, -0.1875, 0.4375},
				{-0.4375, -0.375, 0.375, -0.375, -0.1875, 0.4375},
				{-0.25, -0.3125, 0.1875, -0.1875, -0.0625, 0.25},
				{-0.25, -0.3125, -0.25, -0.1875, -0.0625, -0.1875},
				{0.1875, -0.3125, -0.25, 0.25, -0.0625, -0.1875},
				{0.1875, -0.3125, 0.1875, 0.25, -0.0625, 0.25},
				{0.125, -0.0625, 0.125, 0.1875, 0.125, 0.1875},
				{-0.1875, -0.0625, 0.125, -0.125, 0.125, 0.1875},
				{-0.1875, -0.0625, -0.1875, -0.125, 0.125, -0.125},
				{0.125, -0.0625, -0.1875, 0.1875, 0.125, -0.125},
				{0.4375, -0.1875, -0.375, 0.5, -0.0625, -0.3125},
				{-0.5, -0.1875, -0.375, -0.4375, -0.0625, -0.3125},
				{-0.5, -0.1875, 0.3125, -0.4375, -0.0625, 0.375},
				{0.4375, -0.1875, 0.3125, 0.5, -0.0625, 0.375},
				{0.375, -0.0625, 0.1875, 0.5, 0.0625, 0.3125},
				{0.375, -0.0625, -0.3125, 0.5, 0.0625, -0.1875},
				{-0.5, -0.0625, -0.3125, -0.375, 0.0625, -0.1875},
				{-0.5, -0.0625, 0.1875, -0.375, 0.0625, 0.3125},
				{-0.3125, 0.125, 0, -0.1875, 0.25, 0.125},
				{0, 0.125, 0.1875, 0.125, 0.25, 0.3125},
				{0.1875, 0.125, -0.125, 0.3125, 0.25, 1.3411e-07},
				{-0.125, 0.125, -0.125, -1.3411e-07, 0.25, 2.01166e-07},
				{-0.0625, 0.0625, -0.0625, -1.3411e-07, 0.125, -1.11759e-08},
				{0.25, 0.0625, -0.0625, 0.3125, 0.125, 3.35276e-08},
				{-0.3125, 0.0625, 0, -0.25, 0.125, 0.0625},
				{0, 0.0625, 0.25, 0.0624999, 0.125, 0.3125},
				{0.375, -0.125, 0.25, 0.4375, -0.0625, 0.3125},
				{0.375, -0.125, -0.3125, 0.4375, -0.0625, -0.25},
				{-0.4375, -0.125, -0.3125, -0.375, -0.0625, -0.25},
				{-0.4375, -0.125, 0.25, -0.375, -0.0625, 0.3125},
			},
		},
	})
end

----------------------------------------------------------------------------------------------
------------------------------------- Fungus/Nether Mushroom ---------------------------------
----------------------------------------------------------------------------------------------
if core.get_modpath("mcl_mushroom") then
	core.override_item("mcl_mushroom:crimson_fungus", {
		tiles = {
			"mcl_small_3d_plants_crimson_fungus_top.png",
			"mcl_small_3d_plants_crimson_fungus_bottom.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
				{-0.25, -0.1875, -0.25, 0.25, -0.125, 0.25},
				{-0.3125, -0.125, -0.3125, 0.3125, 0, 0.3125},
				{-0.1875, 0, -0.1875, 0.1875, 0.1875, 0.1875},
				{-0.125, 0.1875, -0.125, 0.125, 0.25, 0.125},
			},
		},
	})

	core.override_item("mcl_mushroom:warped_fungus", {
		tiles = {
			"mcl_small_3d_plants_warped_fungus_top.png",
			"mcl_small_3d_plants_warped_fungus_bottom.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
				{-0.375, -0.1875, -0.375, 0.375, 0.0625, 0.375},
			},
		},
	})
elseif core.get_modpath("mcl_crimson") then
	core.override_item("mcl_crimson:crimson_fungus", {
		tiles = {
			"mcl_small_3d_plants_crimson_fungus_top.png",
			"mcl_small_3d_plants_crimson_fungus_bottom.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
			"mcl_small_3d_plants_crimson_fungus.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
				{-0.25, -0.1875, -0.25, 0.25, -0.125, 0.25},
				{-0.3125, -0.125, -0.3125, 0.3125, 0, 0.3125},
				{-0.1875, 0, -0.1875, 0.1875, 0.1875, 0.1875},
				{-0.125, 0.1875, -0.125, 0.125, 0.25, 0.125},
			},
		},
	})

	core.override_item("mcl_crimson:warped_fungus", {
		tiles = {
			"mcl_small_3d_plants_warped_fungus_top.png",
			"mcl_small_3d_plants_warped_fungus_bottom.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
			"mcl_small_3d_plants_warped_fungus.png",
		},
		drawtype = "nodebox",
		node_box = {
			type = "fixed",
			fixed = {
				{-0.0625, -0.5, -0.0625, 0.0625, -0.1875, 0.0625},
				{-0.375, -0.1875, -0.375, 0.375, 0.0625, 0.375},
			},
		},
	})
end

dofile(modpath .. "/flowerpots.lua")
