# Codihacks

[![ContentDB](https://content.luanti.org/packages/Codiac/mcla_codihacks/shields/title/)](https://content.luanti.org/packages/Codiac/mcla_codihacks/)

This is a collection of oddball changes and features for Mineclonia. Most are not
suitable for upstream inclusion.

Here is a list of things included.

1. Concrete textures are darker versions of powdered concrete. This image shows
   the powder on top of the blocks. ![Shiny!](./concrete_colours.jpg)
1. Anvils never break
1. Tool Master enchantment for bulk tool action
1. Lava Walker enchantment for easier Nether navigation
1. Graveyard for villages. (No job site)
1. Apiarist (Bee farmer job)
1. Bee Farm for villages.
1. Copper, player only, pressure plate
1. Books are fuel
1. Get leather back from saddles
1. Get blocks back from gold and iron stairs
1. Get ingots back from horse armor
1. Stack horse armor
1. Stack potions
1. Compost cooked and raw fish
1. Emerald ore generates in slightly more layers
1. Get pink dye from cherry blossom petals
1. Automatically name and waypoint villages
1. Automatically name villagers
1. An OP building for an entire village
1. Lapis ore generation updated to more closely match modern MC. It now also
   generates between -63 to -94 (equivalent to -1 and -32 in MC), and a second
   pass is done between layers -126 and 2 (equivalent to -64 and 64 in MC).
   *Probably needs some work on rarity*.
1. Recipe to make budding amethyst blocks
1. Recipe to make wool from 4 string
1. Stack compass
1. Stack clock
1. Golems attack creepers
1. Recipe to convert quartz block back to quartz
1. Dye can be used to recolor concrete blocks
1. Dye can be used to recolor beds
1. Milk buckets can be stacked
1. Quartz blocks can be split
1. Teleport pads can be added to villages, styled, and added to starter chests
1. XP can be gathered from furnaces by shift+right clicking them
1. Adds the Redstone lantern, a pulsing source of redstone power
1. Allows using any enchanted bows and crossbows to craft dispensers.
1. Allows burning enchanted fishing rods.
1. Adds a bag that can capture mobs and release them somewhere else.
1. Adds stairs and slabs for stripped wood and stripped bark.

## Settings note

The `wset` chat command from World Settings is used to change per-world
settings. Changing a setting in one world will not affect any other worlds.

You can copy the `world_settings.conf` file between worlds, but you will need to
restart the destination world for it to have an affect. If you copy the config
between creating a new world and starting it, then the config will apply for the
entirety of the world's existance.

### List of World Settings

|Setting|Description|Default|
|---|---|---|
|apiarist|Add Apiarist as a villager profession|true|
|bag_of_capture|Add a bag that can capture mobs|false|
|bee_farm|Add a bee farm that can spawn as part of village creation|true|
|clear_leaves|Clear leaves and vines directly above saplings when it grows|false|
|craft_buds|Allow crafting budding amethyst blocks|true|
|dyeable_beds|Dye can be used to recolor beds|true|
|furnace_xp_yoink|Allows taking XP from furnaces by using them while sneaking|false|
|dyeable_concrete|Dye can be used to recolor concrete blocks|true|
|golems_eat_creepers|Should iron golems attack creepers?|true|
|graveyard|Enable the graveyard in villages|true|
|milk_bucket_stack|Size milk buckets can stack to|1|
|more_lapis|Make Lapis ore generation closer to MC 1.17/1.18+|true|
|name_villagers|Enable automatically naming villagers who spawn as part of village creation|true|
|name_villages|Enable automatically naming and creating waypoints for villages|true|
|redstone_lantern|Enable the Redstone lantern, which acts as a redstone clock|true|
|stripped_stairs|Adds stairs and slabs for stripped and stripped bark woods|false|
|split_quartz|Enables splitting quartz blocks back in to 4 quartz|true|
|tpads_for_villages|Add a teleport pad to the bell tower in villages. Only adds them to new villages|false|
|tpads_restyle|Use the nether portal texture for teleport pads|false|
|tpads_starter|Adds some teleport pads to the starter chest|false|
|village_discovery_distance |Distance away from village waypoint for it to be detected|60|
|village_in_a_box|Enable the village in a box building|false|
|village_waypoint_distance|Distance away from village waypoint for it to be shown in hud|180|

## Dependencies

You will need all of these to use this mod.

* [Mineclonia](https://content.luanti.org/packages/ryvnf/mineclonia/) Install the game first :)
* [World Settings](https://content.luanti.org/packages/Codiac/world_settings/) Install from ContentDB.

### Optional

Some features of this mod require these other mods.

* [Named Waypoints](https://content.luanti.org/packages/FaceDeer/named_waypoints/) Install from ContentDB. Used for naming villages and for player's homes.
* [Name Generator](https://content.luanti.org/packages/FaceDeer/name_generator/) Install from ContentDB. Used for naming villagers and villages.
* [Teleport Pads](https://content.luanti.org/packages/entuland/tpad/) Install from ContentDB. Used for adding teleport pads to villages, starter chests, and player homes.
* [Flow](https://content.luanti.org/packages/luk3yx/flow/) Install from ContentDB. Used for Redstone Lantern UI.
* [Prestibags](https://content.luanti.org/packages/Codiac/prestibags) Install from ContentDB. Used for Bag of Capture.
* [mcl_fireflies](https://codeberg.org/cora/mcl_fireflies) Install from git. Used for Bag of Capture.

## Jobs

### Apiarist

A Farmer who uses beehives as their job site.

This requires Mineclonia 0.118.0 or newer.

#### Trades

##### Novice

* 1 emerald for 3 glass bottles
* 10 of any flower for 1 emerald

##### Apprentice

* 2 honey bottles for 1 emerald
* 1 campfire  for 1 emerald
* 1 emerald for 3 honeycomb

##### Journeyman

* 1 emerald for 2 honey bottles
* 1 beehive for 5 emeralds

##### Expert

* 5 emeralds for 1 honeycomb block

##### Master

* 2 emeralds for 1 honey block
* 6 emeralds for 1 beehive

## Enchantments

### Tool Master

This enchantment can be applied to any tool. This allows the tool to do it's
action over an area instead of a single block. It has 3 levels of enchantment.

You can now till a whole field or shear a flock of sheep with one swing, or mine
large areas with a few swings!

By default this enchantment is not active, so the normal click to activate
triggers the normal behavior. To get the enchanted effect you need to sneak and
click. This was done to prevent accidentally destroying things.

**WARNING:** When activating this enchantment the tool will be subject to normal
wear. If you dig 6 nodes then the tool will suffer 6 nodes worth of wear. You
can vey quickly destroy tools using this enchantment!

The area affected is:

1. For level 1 a 3x3x3 area.
1. For level 2 a 5x5x5 area.
1. For level 3 a 7x7x7 area.

For a hoe the area is:

1. 5x2x3
1. 7x2x6
1. 9x2x9

The area is calculated in front of the player, with the node struck as the
central Y coordinate. To make a tunnel using a level 1 enchantment, you would
hit the head high node in front of you. This will create a cube that goes one
node left and right of the player, one node above the players head down to
ground level, and 3 nodes deep in front of the player.

If you struck at foot height you would get a descending tunnel.

Drops triggered by tool master are deposited directly in the player's inventory
where possible, and experience is applied directly to the player. Drops that
can't be placed in the player's inventory are drop at the players position.

The enchantment has restrictions on what it can affect based on the tool it is
applied to.

1. Pickaxes only affect blocks with the `pickaxey` group.
1. Axes only affect blocks with the `tree` group.
1. Shovels only affect blocks with the `shovely` group.
1. Hoes only affect blocks with the `hoey` and `plant` groups.
    1. When using a tool master hoe to harvest areas the crops will be
       automatically replanted if you have the "seed" of the plants in your
       inventory.
1. Shears only affect `mobs_mc:sheep` and blocks with the `shearsy` and
   `shearsy_wool` groups.

This image shows the before and after of tilling with a tool master 3 hoe; shift + right click to a single node..

![Tilling](tool_master_till.gif)

This image shows the before and after of harvesting with a tool master 3 hoe; shift + left click to a single node.

![Harvesting](tool_master_harvest.gif)

### Lava Walker

This is a 2 level enchantment to convert lava to cobblestone when you walk on it.

Be **_very careful_** of lag :D

Level 1 covers a 3x3 area, level 2 a 5x5 area, in front of the player.

**NOTE:** This enchantment has a good chance of breaking lava farms and the
like. It may be wise to place it on a seconds set of boots that you only wear
when you want to use it.

## Buildings

These will be added to villages if they are enabled.

1. "Village in a box" This is a building with a bell, every core job site, and
   enough beds for villagers to fill them. This will not be available unless you
   enable it using the `/wset mcla_codihacks.village_in_a_box true` chat
   command.

1. Graveyard that contains a few buried chests and a zombie spawner. Original
   schema from <https://codeberg.org/cora/mcl_extra_structures>. This is enabled
   by default but can be disabled by running
   `/wset mcla_codihacks.graveyard false`.

1. Bee farm, with one or two bee hives that act as job sites and a selection of
   flowers.s
   
  In MCLA 0.118.0+ there are 3 variations of this building. One for plains
  plains & savannah, one for snowy & taiga, and one for desert. For older
  Mineclonia versions the plains version is used for all village styles.

  **Plains & savanna**
  ![Screenshot of plains bee farm](./screenshots/plains_bee_farm.jpg)

  **Snowy & Taiga**
  ![Screenshot of plains bee farm](./screenshots/snowy_bee_farm.jpg)

  **Desert**
  ![Screenshot of plains bee farm](./screenshots/desert_bee_farm.jpg)

## Naming Villages and Villagers

1. Automatically name and waypoint villages. This uses the `mingos towns` list
   from Named Waypoints. This is enabled by default but can be disabled by
   running `/wset mcla_codihacks.name_villages false`.

1. Automatically name villagers who spawn as part of village creation. This uses
   the male and female dwarf, elf, gnome, halfling and human lists from Name
   Generator. This is enabled by default but can be disabled by running `/wset
   mcla_codihacks.name_villagers false`.

1. Distance away from village waypoint for it to be discovered. This defaults to
   60 and can be changed by running
   `/wset mcla_codihacks.village_discovery_distance 90` where '90' is the
   distance you want to record discovery of the waypoint from.
  
1. Distance away from village waypoint for it to be shown in hud. This defaults to
   180 and can be changed per world by running
   `/wset mcla_codihacks.village_waypoint_distance 190` where '190' is the
   distance you want to see the label from.

## Chat Commands

### biome_test_building

This chat command will place a building once for each biome, creating a ground turnip for the biome and replace all the blocks for the biome.

This makes it easy to see how the building will look in each biome.

```text
/biome_test_building <building>
```

Where "building" is the name of the building as registered in ```mcl_villages.register_building```.

e.g.

`/biome_test_building house_small` produces this:

![Screenshot of running /biome_test_building house_small](./biome_test_building.jpg)

### place_all_things

This chat command places all village schematics in a grid in front of the
player.

This useful if you want to compare or work on all schematics at once.

The schematics will be placed on the player's current Y level regardless of
anything else in the area. e.g. you can do this in a large air area and not have
other blocks interfering with them.

## TODO

- Need a texture for apiarist.
