local internal_api = ...

local S = internal_api.translate_single

local E1 = {"mcl_core:emerald", 1, 1}

local novice_trades = {{E1, {"mcl_potions:glass_bottle", 3, 3}}}

for name, def in pairs(core.registered_nodes) do
	if core.get_item_group(name, "flower") > 0 and core.get_item_group(name, "double_plant") ==
		0 and name ~= "mcl_flowers:wither_rose" and name ~= "mcl_mangrove:propagule" and name ~=
		"mcl_lush_caves:azalea" and core.get_item_group(name, "wildflower") <= 1 then
		table.insert(novice_trades, {{name, 10, 10}, E1})
	end
end

local trades = {
	novice_trades,
	{
		{{"mcl_honey:honey_bottle", 2, 2}, E1},
		{{"mcl_campfires:campfire_lit", 1, 1}, E1},
		{E1, {"mcl_honey:honeycomb", 3, 3}},
	},
	{
		{{"mcl_core:emerald", 5, 5}, {"mcl_honey:honey_bottle", 2, 2}},
		{{"mcl_beehives:beehive", 1, 1}, {"mcl_core:emerald", 5, 5}},
	},

	{{{"mcl_core:emerald", 5, 5}, {"mcl_honey:honeycomb_block", 1, 1}}},

	{
		{{"mcl_core:emerald", 2, 2}, {"mcl_honey:honey_block", 1, 1}},
		{{"mcl_core:emerald", 6, 6}, {"mcl_beehives:beehive", 1, 1}},
	},
}

local profession = {
	description = S("Apiarist"),
	name = "apiarist",
	poi = "mcla_codihacks:apiarist",
	group = "group:beehive",
	texture = "mobs_mc_villager_profession_toolsmith.png",
	extra_pick_up = {},
}

local poi = {
	is_valid = function(nodepos)
		local node = core.get_node(nodepos)
		return (node.name == "ignore" or core.get_item_group(node.name, "beehive") > 0)
	end,
	village_center = true,
}

local gifts = {
	stacks_min = 1,
	stacks_max = 1,
	items = {
		{itemstring = "mcl_honey:honey_block"},
		{itemstring = "mcl_honey:honeycomb_block"},
		{itemstring = "mcl_honey:honey_bottle"},
		{itemstring = "mcl_beehives:beehive"},
	},
}

mobs_mc.register_villager(profession, poi, trades, gifts)
