local internal_api = ...

local mod_name = internal_api.mod_name

local function apply_dye(pos, color, base, postfix)
	local new_def = core.registered_nodes[base .. color .. (postfix or "")]
	if new_def then
		local node = core.get_node_or_nil(pos)
		if node then
			local p2 = node.param2
			core.swap_node(pos, {name = new_def.name, param2 = p2})
		end
	end
end

-- Yoinked from mcl_beds
local function get_bed_next_node(pos, node)
	local node = node or core.get_node_or_nil(pos)
	if not node then return end

	local dir = core.facedir_to_dir(node.param2)

	local pos2, bottom
	if string.sub(node.name, -4) == "_top" then
		pos2 = vector.subtract(pos, dir)
	else
		pos2 = vector.add(pos, dir)
		bottom = true
	end

	local node2 = core.get_node(pos2)
	return pos2, node2, bottom, dir
end
-- End Yoink

local function dye_bed(pos, color, oldnode)
	local node = core.get_node_or_nil(pos)
	if not node then return end

	local pos2, node2, bottom = get_bed_next_node(pos, oldnode)

	if bottom then
		apply_dye(pos, color, "mcl_beds:bed_", "_bottom")
		if node2 and string.sub(node2.name, -4) == "_top" then
			apply_dye(pos2, color, "mcl_beds:bed_", "_top")
		end
	else
		apply_dye(pos, color, "mcl_beds:bed_", "_top")
		if node2 and string.sub(node2.name, -7) == "_bottom" then
			apply_dye(pos2, color, "mcl_beds:bed_", "_bottom")
		end
	end
end

for color, _ in pairs(mcl_dyes.colors) do
	local image = color .. "_concrete_powder.png"
	local image_table = {name = image, align_style = "world"}
	local def = core.registered_nodes["mcl_colorblocks:concrete_" .. color]

	if def then
		def.tiles = {image_table}
		if world_settings.get(mod_name, "dyeable_concrete") then
			core.override_item(def.name, {
				_on_dye_place = function(pos, dye_color)
					apply_dye(pos, dye_color, "mcl_colorblocks:concrete_")
				end,
			})
		end

		if world_settings.get(mod_name, "dyeable_beds") then
			local bed_def = core.registered_nodes["mcl_beds:bed_" .. color .. "_top"]
			if bed_def then
				core.override_item(bed_def.name, {
					_on_dye_place = function(pos, dye_color) dye_bed(pos, dye_color) end,
				})
				core.override_item("mcl_beds:bed_" .. color .. "_bottom", {
					_on_dye_place = function(pos, dye_color) dye_bed(pos, dye_color) end,
				})
			end
		end

		local stair = "mcl_stairs:stair_concrete_" .. color
		local slab = "mcl_stairs:slab_concrete_" .. color
		if core.registered_nodes[stair] then
			core.registered_nodes[stair].tiles = {image_table}
			core.registered_nodes[stair .. "_outer"].tiles = {image_table}
			core.registered_nodes[stair .. "_inner"].tiles = {image_table}

			core.registered_nodes[slab].tiles = {image_table}
			core.registered_nodes[slab .. "_double"].tiles = {image_table}
			core.registered_nodes[slab .. "_top"].tiles = {image_table}

			if world_settings.get(mod_name, "dyeable_concrete") then
				core.override_item(stair, {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:stair_concrete_")
					end,
				})
				core.override_item(stair .. "_outer", {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:stair_concrete_", "_outer")
					end,
				})
				core.override_item(stair .. "_inner", {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:stair_concrete_", "_inner")
					end,
				})
				core.override_item(slab, {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:slab_concrete_")
					end,
				})
				core.override_item(slab .. "_double", {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:slab_concrete_", "_double")
					end,
				})
				core.override_item(slab .. "_top", {
					_on_dye_place = function(pos, dye_color)
						apply_dye(pos, dye_color, "mcl_stairs:slab_concrete_", "_top")
					end,
				})
			end
		end
	end
end
