local internal_api = ...
local S = internal_api.translate_single
local gui = flow.widgets

local _mcl_redstone = {
	connects_to = function(node) return true end,
	get_power = function(node, que) return 15, true end,
}

local _mcl_redstone_off = {
	connects_to = function(node) return true end,
	get_power = function(node) return 0 end,
}

local function pulser(pos, elapsed)
	local node = core.get_node(pos)

	local new_node = {param2 = node.param2}
	local timer = core.get_node_timer(pos)

	if string.match(node.name, "redstone_lantern_off") then
		new_node.name = string.gsub(node.name, "redstone_lantern_off", "redstone_lantern")
		timer:set(mcl_redstone.tick_speed, elapsed)
	else
		new_node.name = string.gsub(node.name, "redstone_lantern", "redstone_lantern_off")
		local meta = core.get_meta(pos)
		local rate = meta:get_int("tick_rate") or 3
		timer:stop()
		timer:start(mcl_redstone.tick_speed * rate)
	end

	mcl_redstone.swap_node(pos, new_node)
end

local function set_tick_rate(pos, node, player, rate, on)

	local meta = core.get_meta(pos)
	meta:set_int("tick_rate", rate)

	local new_node = {name = node.name, param2 = node.param2}

	if on and string.match(node.name, "redstone_lantern_off") then
		new_node.name = string.gsub(node.name, "redstone_lantern_off", "redstone_lantern")
	elseif not on and not string.match(node.name, "redstone_lantern_off") then
		new_node.name = string.gsub(node.name, "redstone_lantern", "redstone_lantern_off")
	end

	mcl_redstone.swap_node(pos, new_node)
	local timer = core.get_node_timer(pos)
	timer:stop()
	if on then timer:start(mcl_redstone.tick_speed * rate) end
end

local function choose_tickrate(pos, node, clicker)
	local node = core.get_node(pos)

	local meta = core.get_meta(pos)
	local rate = meta:get_int("tick_rate") or 3
	local timer = core.get_node_timer(pos)

	return flow.make_gui(function(player, ctx)
		return gui.VBox({
			gui.Label({label = S("Select tick rate")}),
			gui.HBox({
				gui.Checkbox({name = "on", label = S("On"), selected = timer:is_started()}),
				gui.Dropdown {
					label = S("Rate"),
					name = "rate",
					items = {3, 4, 5, 6, 7, 8, 9, 10, 11, 12},
					selected_idx = rate - 2,
					index_event = true,
				},
				gui.button_exit({
					label = S("Save"),
					name = "save",
					on_event = function(player, ctx)
						set_tick_rate(pos, node, player, ctx.form.rate + 2, ctx.form.on)
					end,
				}),
			}),
		})
	end)
end

local function tickrate_gui(pos, node, clicker)
	if core.is_protected(pos, clicker and clicker:get_player_name() or "") then return end

	local my_gui = choose_tickrate(pos, node, clicker)
	my_gui:show(clicker)
end

mcl_lanterns.register_lantern("redstone_lantern", {
	description = S("Redstone Lantern"),
	longdesc = S(
		"Redstone Lanterns provide light and redstone power in a timed pulse. They can be switched on and off, and the timing can be changed by right clicking them"),
	texture = "redstone_lantern.png",
	light_level = 7,
	groups = {redstone_not_conductive = 1},
})

mcl_lanterns.register_lantern("redstone_lantern_off", {
	description = S("Redstone Lantern"),
	longdesc = S(
		"Redstone Lanterns provide light and redstone power in a timed pulse. They can be switched on and off, and the timing can be changed by right clicking them"),
	texture = "redstone_lantern_off.png",
	light_level = 0,
	groups = {not_in_creative_inventory = 1, redstone_not_conductive = 1},
})

core.override_item("mcl_lanterns:redstone_lantern_floor", {
	_mcl_redstone = _mcl_redstone,
	on_timer = pulser,
	on_rightclick = tickrate_gui,
})

core.override_item("mcl_lanterns:redstone_lantern_ceiling", {
	_mcl_redstone = _mcl_redstone,
	on_timer = pulser,
	on_rightclick = tickrate_gui,
})

core.override_item("mcl_lanterns:redstone_lantern_off_floor", {
	on_rightclick = tickrate_gui,
	on_timer = pulser,
	_mcl_redstone = _mcl_redstone_off,
})

core.override_item("mcl_lanterns:redstone_lantern_off_ceiling", {
	on_rightclick = tickrate_gui,
	on_timer = pulser,
	_mcl_redstone = _mcl_redstone_off,
})

core.register_craft({
	output = "mcl_lanterns:redstone_lantern_floor 1",
	recipe = {
		{"mcl_redstone:redstone", "mcl_repeaters:repeater_off_1", "mcl_redstone:redstone"},
		{
			"mcl_repeaters:repeater_off_1",
			"mcl_lanterns:lantern_floor",
			"mcl_repeaters:repeater_off_1",
		},
		{"mcl_redstone:redstone", "mcl_redstone:redstone", "mcl_redstone:redstone"},
	},
})
