local internal_api = {}

internal_api.mod_name = core.get_current_modname()
internal_api.mod_path = core.get_modpath(internal_api.mod_name)
internal_api.translate_single, internal_api.translate_plural = core.get_translator(
	                                                               internal_api.mod_name)

internal_api.has_tpad = core.get_modpath("tpad")
internal_api.has_name_generator = core.get_modpath("name_generator")
internal_api.has_named_waypoints = core.get_modpath("named_waypoints")
internal_api.has_flow = core.get_modpath("flow")
internal_api.has_prestibags = core.get_modpath("prestibags")
internal_api.has_fireflies = core.get_modpath("mcl_fireflies")

local S = internal_api.translate_single

assert(loadfile(internal_api.mod_path .. "/world_settings.lua"))(internal_api)
assert(loadfile(internal_api.mod_path .. "/hacks.lua"))(internal_api)
assert(loadfile(internal_api.mod_path .. "/anvils.lua"))(internal_api)
assert(loadfile(internal_api.mod_path .. "/buildings.lua"))(internal_api)
assert(loadfile(internal_api.mod_path .. "/enchantments.lua"))(internal_api)
assert(loadfile(internal_api.mod_path .. "/colors.lua"))(internal_api)

-- Requires MCLA 0.118.0
if world_settings.get(internal_api.mod_name, "apiarist") and mobs_mc.register_villager ~=
	nil then assert(loadfile(internal_api.mod_path .. "/professions.lua"))(internal_api) end

if world_settings.get(internal_api.mod_name, "redstone_lantern") then
	if internal_api.has_flow then
		assert(loadfile(internal_api.mod_path .. "/redstone_lantern.lua"))(internal_api)
	else
		core.log("error",
		         S("You have enabled redstone lanterns but you do not have flow installed."))
	end
end

for _, file in pairs(core.get_dir_list(internal_api.mod_path .. "/local_rules", false)) do
	if file:sub(-4) == ".lua" then
		assert(loadfile(internal_api.mod_path .. "/local_rules/" .. file))(internal_api)
	end
end
