# World Settings

This mod adds an API for managing per-world settings for Luanti games and mods.

Settings can be managed in code using the API, and in game by players with the
`server` privilege using the `wset` chat command or UI.

Settings are saved to the `world_settings.conf` file in the world's directory.

Settings are updated in the config file immediately on being registered or
altered.

Setting names consist of two parts, a domain and a name. The domain should be
unique for your game or mod. This allows settings in different mods to use the
same name.

Domain and name cannot contain a dot '.' or whitespace, if they do they will be
rejected.

Once a setting has been set on the world, which will happen automatically when
they are registered, any changes to the default in the code, or in the global
settings, will not affect existing world settings.

You can copy a world setting file to a new world after it is created but before
it is run to have a standard set of world settings applied to a new world.
Alternatively you can create a set of [Default World
Settings](#default-world-settings) for your server.

You will need to restart a world if you want to change the settings by updating
the config files directly.

![Screenshot of in game menu](ss.jpg)

## Default World Settings

You can override the default world settings by saving your preferred world
settings to `$path_to_luanti_data/mod_data/world_settings/world_settings.conf`.
Once you have done this then all new worlds will use the settings set in this
file instead of the game or mod defined defaults.

You may need to create the `world_settings` directory yourself, but the
`mod_data` directory should already exist.

These settings can be set or updated in game by using the `/wset sync <domain>`
chat command or by clicking the `Sync` button in the UI.

## Chat command

Players with the `server` privilege can interact with the world settings via the
`wset` chat command.

* `wset` with no arguments displays all current settings and their values.
* `/wset help` with no argument displays all current settings with their
  help text.
* `/wset help <domain>` with an argument displays settings for the specified
  domain with their help text.
* `/wset name` displays the value of the named setting.
* `/wset name value` changes the value of the named setting to the provided
value.
* `/wset ui` show a form for changing settings. Requires the `flow` mod.
* `/wset sync <domain>` copy the saved values from the given domain to the
  default world config.

### Examples

#### Query a setting in game

```shell
/wset my_mod.can_fu
```

#### Change a setting in game

```shell
/wset my_mod.can_fu false
```
#### Display The in Game UI

```shell
/wset ui
```

## Using in A Game or Mod

To find out how to use World Settings in a game or mod read the [API](API.md)
documentation.

## Dependencies

There are no mandatory mods.

### Optional

These mods can expand the experience this mod offers.

* [flow](https://content.luanti.org/packages/luk3yx/flow/) Install from
  ContentDB. Used for the in game UI.

## Legal

### Source Code License

See [LICENSE.md](LICENSE.md) for more details.

The source code in this mod is licensed under the terms of the GNU General
Public License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

### Media License

The images and image sources in this mod are licensed under the terms of the
Creative Commons Attribution-ShareAlike 4.0 (CC BY-SA 4.0).
