# API

This file documents the public API for World Settings.

## Registering Settings

There is a function for each data type to register settings.

If the setting exists in the config for this world then the value is not
changed when calling the register functions.

"help" is the help text for the setting.

You usually do this in a global scope.

### world_settings.register_bool(domain, name, default, help)

### world_settings.register_number(domain, name, default, help)

### world_settings.register_string(domain, name, default, help)

## Un-Registering settings

If a setting is no longer required it can be removed.

### world_settings.unregister(domain, name)

## Getting settings

### world_settings.has(domain, name)

Determine if a setting has been registered.

### world_settings.get(domain, name)

Gets the value for the setting.

Note that as world settings can be changed while the world is running they
should be gotten in the local scope before being used and not cached in a global
variable as is standard practice for global settings.

## Updating settings

### world_settings.set(domain, name, value)

## Utility functions

### world_settings.get_names()

Gets the full names for all settings.

### world_settings.split_full_name

Splits a full name in to domain and name.

## Examples

### Register a number

Usually done in global scope.

```lua
world_settings.register_number(
	"my_mod",
	"max_volume",
	11,
	S("The maximum volume something can be played at")
)
```

### Get the number

Usually done in local scope.

```lua
local max_vol = world_settings.get("my_mod", "max_volume")
```

### Register a boolean based on a global setting

```lua
world_settings.register_bool(
	"my_mod",
	"can_fu",
	core.settings:get_bool("my_mod_can_fu", true),
	S("Is this mod allowed to fu?")
)
```
