local S = core.get_translator(core.get_current_modname())

local materials = {
	"leather",
	"iron",
	"gold",
	"diamond"
}

-- For some wierd reason, if variable bag is declared outside of loop,
-- All bags end up with the same 'groups' parameter
-- Some pointer issues???
for size, material in pairs(materials) do
	local bag = {}
	bag.on_place = cm_bags.on_bag_place
	bag.on_secondary_use = cm_bags.on_bag_place
	-- for _, color in ipairs(colors) do
	bag.description = S(material:sub(1,1):upper() .. material:sub(2) .. " bag")
	bag.inventory_image = "bag_" .. material .. ".png"
	bag.groups = { bag_size = size, offhand_item = 1 }
	core.register_tool("cm_bags:" .. material, bag)
	-- end
	core.register_craft({
		type = "shapeless",
		output = "cm_bags:" .. material,
		recipe = { "cm_bags:" .. material, "group:dye" },
	})
	core.register_craft({
		type = "shapeless",
		output = "cm_bags:" .. material,
		recipe = { "cm_bags:" .. material, "group:cm_bag_pin" },
	})
end

-- register bag crafts
core.register_craft({
	output = "cm_bags:leather",
	recipe = {
		{ "mcl_mobitems:leather", "mcl_mobitems:string", "mcl_mobitems:leather" },
		{ "mcl_mobitems:string", "mcl_chests:chest", "mcl_mobitems:string" },
		{ "mcl_mobitems:leather", "group:wool", "mcl_mobitems:leather" },
	},
})

core.register_craft({
	output = "cm_bags:iron",
	recipe = {
		{ "mcl_core:iron_ingot", "mcl_mobitems:string", "mcl_core:iron_ingot" },
		{ "mcl_mobitems:string", "cm_bags:leather", "mcl_mobitems:string" },
		{ "mcl_core:iron_ingot", "mcl_hoppers:hopper", "mcl_core:iron_ingot" },
	},
})

core.register_craft({
	output = "cm_bags:gold",
	recipe = {
		{ "mcl_core:gold_ingot", "mcl_mobitems:string", "mcl_core:gold_ingot" },
		{ "mcl_mobitems:string", "cm_bags:iron", "mcl_mobitems:string" },
		{ "mcl_core:gold_ingot", "cm_bags:plain_pin", "mcl_core:gold_ingot" },
	},
})

core.register_craft({
	output = "cm_bags:diamond",
	recipe = {
		{ "mcl_core:diamond", "mcl_mobitems:string", "mcl_core:diamond" },
		{ "mcl_mobitems:string", "cm_bags:gold", "mcl_mobitems:string" },
		{ "mcl_core:diamond", "mcl_core:diamond", "mcl_core:diamond" },
	},
})

