local BG = mcl_formspec.get_itemslot_bg
local F = core.formspec_escape
local C = core.colorize
local INV_SUFIX = "_bag_tmp"

local function getBagSize(stack)
	local bag_size = stack:get_definition().groups.bag_size
	if not bag_size then
		return 0, 0
	end

	local add_width = 0
	if stack:get_meta():get_string(cm_bags.pin_width) == cm_bags.pin_width then
		add_width = 1
	end
	
	local add_height = 0
	if stack:get_meta():get_string(cm_bags.pin_height) == cm_bags.pin_height then
		add_height = 1
	end
-- core.chat_send_all(stack:get_definition().groups.bag_size + addition)
	return 5 + bag_size + add_width, bag_size + add_height
end

local function create_detached_inventory(player_name, bag_stack)
	local inv_name = player_name .. INV_SUFIX
	--Chaeck if something is broken. To prevent item voiding
	local inv = core.get_inventory({ type = "detached", name = inv_name })
	if inv ~= nil then
		core.chat_send_all("Bag is already open!")
		return nil
	end

	core.create_detached_inventory(inv_name, {
		--Forbids puting bags into bags
		allow_put = function(inv, listname, index, stack, player)
			if core.get_item_group(stack:get_name(), "bag_size") > 0 then
				return 0
			else
				return stack:get_stack_max()
			end
		end,
	}, player_name)
	inv = core.get_inventory({ type = "detached", name = inv_name })
	local bag_width, bag_height = getBagSize(bag_stack)
	inv:set_size("main", bag_width * bag_height)

	local meta = bag_stack:get_meta()
	--core.chat_send_all(dump(meta:to_table()))
	local content = meta:get_string("bag_content")
	local list = content and core.deserialize(content) or {}

	for i, stack in ipairs(list) do
		inv:set_stack("main", i, stack)
		--[[if stack ~= nil then
			core.chat_send_all(dump(stack:to_string()))
		end]]
	end

	return inv_name
end

local function openBag(
	player,
	player_name,
	bag_stack,
	context --[[opened equipped or inhand]]
)
	--core.chat_send_all("Enter")
	local inv_name = create_detached_inventory(player_name, bag_stack)
	if inv_name == nil then
		return
	end

	local bag_width, bag_height = getBagSize(bag_stack)
	local form_width = math.max(9, bag_width)
	local bag_offset = 0
	local inv_offset = 0
	if form_width > bag_width then
		bag_offset = (form_width - bag_width) / 2
	elseif bag_width > form_width then
		inv_offset = (bag_width - form_width) / 2
	end

	local form = table.concat({
		--"formspec_version[4]",
		"size[" .. form_width .."," .. (bag_height + 6) .. "]",
		"label[0.1,0.1;" ..
			F(C(mcl_formspec.label_color, core.registered_tools[bag_stack:get_name()].description)) .. "]",
		BG(bag_offset, 1, bag_width, bag_height),
		"list[detached:" .. inv_name .. ";main;" ..
			bag_offset ..",1;" .. bag_width .."," .. bag_height .. ";]",
		BG(inv_offset, bag_height + 1.5, form_width, 3),
		"list[current_player;main;" ..
			inv_offset .. "," .. (bag_height + 1.5) .. ";" .. form_width ..",3;" .. form_width .. "]",
		BG(inv_offset, bag_height + 5, form_width, 1),
		"list[current_player;main;" ..
			inv_offset .. "," .. (bag_height + 5) .. ";" .. form_width ..",1;]",
		"listring[current_player;main]",
		"listring[detached:" .. inv_name .. ";main]",
		"listring[current_player;main]",
	})
	core.show_formspec(player_name, "bag:" .. context, form)
end

local function close_wielded_bag(player)
	local bag_stack = player:get_wielded_item()
	local inv_name = player:get_player_name() .. INV_SUFIX
	local inv = core.get_inventory({ type = "detached", name = inv_name })

	local stacks = {}
	for i = 0, inv:get_size("main"), 1 do
		stacks[i] = inv:get_stack("main", i):to_string()
	end

	bag_stack:get_meta():set_string("bag_content", core.serialize(stacks))
	player:set_wielded_item(bag_stack)
	core.remove_detached_inventory(inv_name)
end

core.register_on_player_receive_fields(function(player, formname, fields)
	--[[ Support for special "bag" slot at player gear.
    if formname == "bag:equipped" and fields.quit then
		--core.chat_send_all("Exit")
		local player_inv = player:get_inventory()
		local bag_stack = player_inv:get_stack("bag", 1)

	    local inv_name = player:get_player_name() .. "_bag_tmp"
        local inv = core.get_inventory({ type = "detached", name = inv_name })
		local stacks = {}
		for i = 0, inv:get_size("main"), 1 do
			stacks[i] = inv:get_stack("main", i):to_string()
		end

		bag_stack:get_meta():set_string("bag_content", core.serialize(stacks))
		player_inv:set_stack("backpack", 1, backapack_stack)
		--core.chat_send_all(dump(meta:to_table()))
		core.remove_detached_inventory(inv_name)
	else]]
	if formname == "bag:inhand" and fields.quit then
		close_wielded_bag(player)
	end
end)

-- Forbid moving bag while it is open. To prevent item deletion on bag closure.
core.register_allow_player_inventory_action(function(player, action, inventory, inventory_info)
	if
		action == "move"
		and inventory_info.from_list == "main"
		and inventory_info.from_index == player:get_wield_index()
	then
		local bag_inv = core.get_inventory({ type = "detached", name = player:get_player_name() .. INV_SUFIX })
		if bag_inv ~= nil then
			return 0
		end
	end

	if action == "take" and inventory_info.listname == "main" and inventory_info.index == player:get_wield_index() then
		local bag_inv = core.get_inventory({ type = "detached", name = player:get_player_name() .. INV_SUFIX })
		if bag_inv ~= nil then
			return 0
		end
	end
end)

--[[
--A chat command for now. Wonna change to hot-key later.
core.register_chatcommand("bag", {
    func = function(player_name)
		local player = core.get_player_by_name(player_name)
		local player_inv = player:get_inventory()
		local backapack_stack = player_inv:get_stack("backpack", 1)
		if backapack_stack:is_empty() then
			return false, "No backpack equiped!"
		end

		openBackpack(player, player_name, backapack_stack, "equipped")
		return true, ""
    end,
})

core.register_allow_player_inventory_action(function(player, action, inventory, inventory_info)
	if action == "move" and inventory_info.to_list == "backpack" then
		local itemstack = inventory:get_stack(inventory_info.from_list, inventory_info.from_index)
		if not (core.get_item_group(itemstack:get_name(), "backpack_size") > 0)  then
			return 0
		else
			return itemstack:get_stack_max()
		end
	end
end)
]]

local function try_get_destination(node_def, node_pos, user, source_inv, source_list)
	local dst_list = "main"
	local dst_inv, stack_id
	if node_def._mcl_hoppers_on_try_push then
		dst_inv, dst_list, stack_id =
			node_def._mcl_hoppers_on_try_push(node_pos, user:get_pos(), source_inv, source_list)
	else
		local dst_meta = core.get_meta(node_pos)
		dst_inv = dst_meta:get_inventory()
		stack_id = mcl_util.select_stack(source_inv, source_list, dst_inv, dst_list, nil, 1)
	end
	return dst_inv, dst_list, stack_id
end

function cm_bags.on_bag_place(itemstack, user, pointed_thing)
	if pointed_thing.type == "node" then
		local node_pos = pointed_thing.under
		local node = core.get_node(node_pos)
		local def = core.registered_nodes[node.name]

		if user and user:get_player_control().sneak then
			local inv_name = create_detached_inventory(user:get_player_name(), itemstack)
			if inv_name == nil then
				return
			end
			local inv = core.get_inventory({ type = "detached", name = inv_name })
			local dst_inv, dst_list, stack_id
			dst_inv, dst_list, stack_id = try_get_destination(def, node_pos, user, inv, "main")
			while stack_id do
				--core.chat_send_all(stack_id)
				mcl_util.move_item(inv, "main", stack_id, dst_inv, dst_list)
				dst_inv, dst_list, stack_id = try_get_destination(def, node_pos, user, inv, "main")
			end
			close_wielded_bag(user)
		elseif def and def.on_rightclick then
			-- Call node's on_rightclick method if defined
			def.on_rightclick(node_pos, node, user)
		else
			openBag(user, user:get_player_name(), itemstack, "inhand")
		end
	elseif pointed_thing.type == "object" then
		local object = pointed_thing.ref
		local entity_def = object:get_luaentity()

		if entity_def and entity_def.on_rightclick then
			-- Call object's on_rightclick method if defined
			entity_def.on_rightclick(entity_def, user)
		else
			openBag(user, user:get_player_name(), itemstack, "inhand")
		end
	else
		openBag(user, user:get_player_name(), itemstack, "inhand")
	end
end

local function update_bag_image(bag)
	local meta = bag:get_meta()
	local dye_color = meta:get_string("bag_color")
	local color = core.colorspec_to_colorstring(cm_bags.color_string_to_table(dye_color))
	local img = bag:get_definition().inventory_image ..
		"^(colorMap.png^[colorize:" .. color .. ":255)"
	meta:set_string("inventory_image", img)
	cm_bags.pin_map(bag)
end

local function bag_craft_with_color(itemstack, player, old_craft_grid, craft_inv)
	if core.get_item_group(itemstack:get_name(), "bag_size") > 0 then
		local found_bag = nil
		local dye_color = nil
		for _, item in pairs(old_craft_grid) do
			local name = item:get_name()
			if core.get_item_group(name, "bag_size") > 0 then
				found_bag = item
				--core.chat_send_all(item:get_meta():get_string("bag_content"))
			elseif core.get_item_group(name, "dye") > 0 or core.get_item_group(name, "wool") > 0  then
				dye_color = cm_bags.get_dye_color(name)
				--error(name .. "|")
			end
		end

		if found_bag then
			--transfer content/pins of old backpack on craft
			local content = found_bag:get_meta():get_string("bag_content")
			itemstack:get_meta():set_string("bag_content", content)
			for _, pin_type in pairs(cm_bags.pin_types) do
				local content = found_bag:get_meta():get_string(pin_type)
				itemstack:get_meta():set_string(pin_type, content)
			end
			if not dye_color then
				dye_color = found_bag:get_meta():get_string("bag_color")
			end
		end

		if not dye_color then
			error("No dye color!")
		end

		itemstack:get_meta():set_string("bag_color", dye_color)
		update_bag_image(itemstack)
		return itemstack
	end
end

core.register_craft_predict(bag_craft_with_color)
core.register_on_craft(bag_craft_with_color)
