local S = core.get_translator(core.get_current_modname())

cm_bags.pin_height = "height"
cm_bags.pin_width = "width"
cm_bags.pin_wither = "wither"

cm_bags.pin_types = {
	cm_bags.pin_height,
	cm_bags.pin_width,
	cm_bags.pin_wither,
}

function cm_bags.pin_map(bag)
	local meta = bag:get_meta()
	local img = meta:get_string("inventory_image")
	if img == nil or img == "" then
		img = bag:get_definition().inventory_image
	end
	if meta:get_string(cm_bags.pin_height) ~= nil and meta:get_string(cm_bags.pin_height) ~= "" then
		img = img .. "^height_map.png"
	end
	if meta:get_string(cm_bags.pin_width) ~= nil and meta:get_string(cm_bags.pin_width) ~= "" then
		img = img .. "^width_map.png"
	end
	meta:set_string("inventory_image", img)
end

function on_pin_place(itemstack, user, pinted_thing)
	local bag = user:get_inventory():get_stack("offhand", 1)
	if not bag:is_empty() and core.get_item_group(bag:get_name(), "bag_size") > 0
	then
		local bag_meta = bag:get_meta()
		local pin_def = itemstack:get_definition()
		local pin_type = pin_def.pin_type
		if bag_meta:get_string(pin_type) ~= nil and bag_meta:get_string(pin_type) ~= "" then
			core.chat_send_player(user:get_player_name(), "Pin " .. pin_type .. " was already applied.")
			return
		end
		core.chat_send_player(user:get_player_name(), "Applied.")
		bag_meta:set_string(pin_def.pin_type, pin_def.pin_type)
		cm_bags.pin_map(bag)
		user:get_inventory():set_stack("offhand", 1, bag)
		itemstack:take_item()
		return itemstack
	end
end

core.register_craftitem("cm_bags:plain_pin", {
	description = S("Plain pin"),
	inventory_image = "plain_pin.png",
	stack_max = 64,
})

core.register_craft({
	output = "cm_bags:plain_pin",
	recipe = {
		{ "mcl_core:gold_nugget", "", "mcl_core:gold_nugget" },
		{ "mcl_core:gold_nugget", "mcl_core:gold_ingot", "mcl_core:gold_nugget" },
		{ "mcl_core:gold_nugget", "", "mcl_core:gold_nugget" },
	},
})

core.register_tool("cm_bags:height_pin", {
	on_place = on_pin_place,
	on_secondary_use = on_pin_place,
	groups = { cm_bag_pin = 1 },
	_tt_help = S("Use it, with bag in offhand to apply"),
	description = S("Height pin"),
	inventory_image = "height_pin.png",
	pin_type = cm_bags.pin_height,
})
core.register_craft({
	output = "cm_bags:height_pin",
	recipe = {
		{ "mcl_core:lapis", "mcl_core:lapis", "mcl_core:lapis" },
		{ "", "cm_bags:plain_pin", "" },
		{ "mcl_core:lapis", "mcl_core:lapis", "mcl_core:lapis" },
	}
})

core.register_tool("cm_bags:width_pin", {
	on_place = on_pin_place,
	on_secondary_use = on_pin_place,
	groups = { cm_bag_pin = 1 },
	_tt_help = S("Use it, with bag in offhand to apply"),
	description = S("Width pin"),
	inventory_image = "width_pin.png",
	pin_type = cm_bags.pin_width,
})
core.register_craft({
	output = "cm_bags:width_pin",
	recipe = {
		{ "mesecons:redstone", "", "mesecons:redstone" },
		{ "mesecons:redstone", "cm_bags:plain_pin", "mesecons:redstone" },
		{ "mesecons:redstone", "", "mesecons:redstone" },
	}
})

-- pin.description = S("Height pin")
-- pin.inventory_image = "height_pin.png"
-- pin.pin_type = cm_bags.pin_height
-- core.register_tool("cm_bags:height_pin", pin)
-- core.register_craft({
-- output = "cm_bags:height_pin",
-- recipe = {
-- { "mcl_core:lapis", "mcl_core:lapis", "mcl_core:lapis" },
-- { "", "cm_bags:plain_pin", "" },
-- { "mcl_core:lapis", "mcl_core:lapis", "mcl_core:lapis" },
-- }
-- })
