local speed_secs = 5 * 60
local timer_check = 5 --C| Seconds per check

--C| Does (name) have fast?
local function has_fast(name)
	return minetest.get_player_privs(name).fast
end

local function get_timer(user)

	if not user then return end

	local meta = user:get_meta() --C| Meta is equal to user meta.

	if not meta then return "" end --C| If there is no meta, return nothing and end.

	return meta:get_string("dishes:fast_timer") or ""
	--[[C| get_string function from meta group is called, with an argument
	set as "dishes:fast_timer".]]
end

local function set_timer(user, timer)
--C| Declares function set_timer, taking "user" and "timer" as arguments

	local meta = user:get_meta() ; if not meta then return end
	--C| Meta = user meta, if there is none, end.

	meta:set_string("dishes:fast_timer", timer) --C| String turned into the timer variable.
end

local function set_fast(user, set) --C| Takes in user and if the fast is set to true.

	local name = user and user:get_player_name() ; if not name then return end
	--C| name = user = player name, if no name, end.
	local privs = minetest.get_player_privs(name)

	privs.fast = set
	minetest.set_player_privs(name, privs)
	--C| If set = true, give fast priv

	if set ~= true then
		set_timer(user, "-99")
	end
end

local function dishes_set_fast(user)

	local name = user and user:get_player_name() ; if not name then return end

	local timer = tonumber(get_timer(user)) or 0

	if timer <= 0 and timer ~= -99 then --C| If timer less or equal to 0, and not -99, remove flight.

		set_fast(user, nil)

		return
	end

	local privs = minetest.get_player_privs(name) --C| Check for privs

	--C| Have we already applied 'fast' privilege?
	if not privs.fast then --C| No fast = give fast
		set_fast(user, true)
	end

	timer = timer - timer_check --C| Timer goes down by timer_check time

	--C| Time's up!
	if timer <= 10 then

		minetest.chat_send_player(name,
				minetest.get_color_escape_sequence("#ff5500")
				.. ("Super Mariner Powers™ are about to expire!"))

		minetest.sound_play("default_dig_dig_immediate",
				{to_player = name, gain = 1.0}, true)
	end

	--C| Update timer
	set_timer(user, timer)

	--C| Restart checking
	minetest.after(timer_check, function()
		dishes_set_fast(user)
	end)
end

--C| In joining, or leaving
minetest.register_on_joinplayer(function(player)

	minetest.after(2.0, function(player)

		--C| Get player and timer
		local name = player and player:get_player_name() ; if not name then return end
		local timer = get_timer(player)

		--C| If timer is up, and player already has fast, default
		if timer == "" and has_fast(name) then

			set_timer(player, "-99")

			return
		end

		timer = tonumber(timer) or 0

		-- if timer is set to default then return
		if timer == -99 then
			return
		end

		--C| If player still has fast, start countdown check
		if has_fast(name) then

			minetest.after(timer_check, function()
				dishes_set_fast(player)
			end)
		end

	end, player)
end)

minetest.register_craftitem("dishes:mariner_spinach", {
	description = "Mariner Spinach",
	inventory_image = "dishes_mariner_spinach.png",
	on_use = function(itemstack, user, pointed_thing)

		if user.is_fake_player then
			return
		end

		-- get privs
		local name = user:get_player_name()
		local privs = minetest.get_player_privs(name)
		local timer = get_timer(user)

		if privs.fast then

			local msg = timer

			if timer == "" or timer == "-99" then
				msg = ("unlimited")
			end

			minetest.chat_send_player(name,
				minetest.get_color_escape_sequence("#ffff00")
				.. S("Powers already granted, @1 seconds left!", msg))

			return
		end

		-- set flight timer
		set_timer(user, speed_secs)

		-- show time remaining
		minetest.chat_send_player(name,
				minetest.get_color_escape_sequence("#1eff00")
				.. ("Mariner Spinach Powers™ granted!"))

		-- start check
		dishes_set_fast(user)
	end
})

minetest.register_craft({
	output = "dishes:mariner_spinach",
	recipe = {
		{"default:mese_crystal", "amethyst:amethyst_ingot", "default:mese_crystal"},
		{"", "dishes:cooked_spinach", ""},
		{"default:mese_crystal", "dishes:can", "default:mese_crystal"}
	}
})

