local on_digiline_receive = function (pos, _, channel, msg)
    local prefix = minetest.get_meta(pos):get_string("prefix")
    local outchn = channel
    if prefix ~= nil and string.len(prefix) > 0 then -- check if prefix is defined and matches the front part of channel
        local flag = false
        local startpos,endpos = outchn:find(prefix, 1, true) -- get starting and ending position
        while startpos == 1 and endpos ~= nil and string.len(outchn) > 0 do -- loop while the prefix matches
            flag = true -- only send if prefix found
            outchn = string.sub(outchn, endpos+1) -- remove prefix
            startpos,endpos = outchn:find(prefix, 1, true) -- maybe recurse if needed
        end
        if flag and string.len(outchn) > 0 then
            digilines.receptor_send(pos, digilines.rules.default, outchn, msg) -- send it out without the prefix
        end
    end
end


-- register router
minetest.register_node("digirouter:router", {
    description = "Digiline router",
    drawtype = "nodebox",
    tiles = {
        "router_top.png"
    },
    walkable = true,
    groups = {dig_immediate=2},
    sunlight_propagates = true,
    paramtype = "light",
    is_ground_content = false,
    selection_box = {
        type = "fixed",
        fixed = { -8/16, -6/16, -8/16, 8/16, -3/16, 8/16 },
    },
    node_box = {
        type = "fixed",
        fixed = {
            { -8/16, -6/16, -8/16, 8/16, -3/16, 8/16 }
        }
    },
    digilines =
    {
        receptor = {},
        effector = {
            action = on_digiline_receive
        },
    },
    after_place_node = function(pos, placer)
        local meta = minetest.get_meta(pos)
        meta:set_string("formspec", "field[prefix;Prefix;${prefix}]")
    end,
    on_receive_fields = function(pos, formname, fields, player)
        local meta = minetest.get_meta(pos)
        meta:set_string("prefix", fields.prefix)

    end
})
