<!--
SPDX-FileCopyrightText: 2024 DS

SPDX-License-Identifier: CC-BY-4.0
-->


# Lavaplop

Make your lava plop!


## Supported games

The following subgames are explicitly supported:

* devtest
* Minetest Game (MTG)
* Minetest Classic
* Hades Revisited (and also Hades I guess)
* mineclone like games (VoxeLibre, Mineclonia)

More can be added easily, see `game_support.lua`. PRs welcome!

Mods can also use the API (see below) to make their own nodes plop.


## API

To register your node as a plopper (ploppers are nodes that plop), add the
following to your node definition:

```
groups = {..., lavaplop_plopper = 1}, -- (unused yet, but good to have anyways)
_lavaplop = {
	plopper = {
		-- the plop sound.
		-- if `nil`, the provided sound will be used
		sound = SimpleSoundSpec,
	},
}
```


## Settings

There are several settings, please consult the mainmenu.

If you're a layman, please note that if you crank up the settings too much, and
the game seems to still be responsive, the server thread might already be
overloaded, ruining your playing experience in other ways. Check your `max_lag`
value in `/status`.
If you're not a layman, uncomment the line `print_perf()` line.


## Implementation details

The mod does not use abms or node timers.
Instead, it randomly picks nodes around the players on each globalstep, and
checks if the node is relevant.
The main reason why I made this mod is because I wanted to try out how good this
works.

The result are, roughly, on average, with default settings if not mentioned
otherwise, for a single player in singleplayer (60Hz (17 ms) server steps):

```
`check_radius` | number of checks (s^-1) | time used per step (ms)
---------------|-------------------------|------------------------
10             | 64                      | 0.05
20 (default)   | 780                     | 0.09
30             | 2900                    | 0.15
```


## Sounds sources

The sounds were generated using [sfxr](https://www.drpetter.se/project_sfxr.html).
The parameters for the sounds can be found in `sounds_src/`.
They were exported on a machine where `sizeof(int)=4`, `sizeof(float)=4`,
and `sizeof(bool)=1`.


## Licensing

The project uses [REUSE](https://reuse.software/).
