-- SPDX-FileCopyrightText: 2024 DS
--
-- SPDX-License-Identifier: Apache-2.0

-- if you add something, don't forget to update the optional_depends
local known_lava_nodes = {
	-- devtest
	"basenodes:lava_source",
	"basenodes:lava_flowing",
	-- minetest_game, and similar (i.e. minetest_classic)
	"default:lava_source",
	"default:lava_flowing",
	-- hades (revisited)
	"hades_core:lava_source",
	"hades_core:lava_flowing",
	-- mineclone like (i.e. voxelibre and mineclonia)
	"mcl_core:lava_flowing",
	"mcl_core:lava_source",
	"mcl_nether:nether_lava_source",
	"mcl_nether:nether_lava_flowing",
}

for _, nodename in ipairs(known_lava_nodes) do
	local def = core.registered_nodes[nodename]
	if def then
		local groups = table.copy(def.groups)
		groups.lavaplop_plopper = 1
		core.override_item(nodename, {_lavaplop = {plopper = {}}, groups = groups})
	end
end
