-- =============================================
-- Часть 1: Регистрация 17 новых блоков с нумерованными текстурами
-- =============================================
--[[local block_name = "simple_brick:brick_" .. 0
local texture_name = "mod" .. 0 .. ".png"
local description = "brick " .. 0

minetest.register_node(block_name, {
        description = description,
        drawtype = "normal",
        paramtype = "fullbox",
                

        tiles = {texture_name}, -- Используем текстуру modX.png

        groups = {
            crumbly = 3, -- Твердость как у камня
            oddly_breakable_by_hand = 3, -- Можно сломать рукой, но очень медленно
        },

        walkable = true,
        diggable = true,
        buildable_by = {"player"},

        -- Звуки, как у камня
        sounds = {
            footstep = {name = "default_stone_footstep", gain = 0.5},
            dig = {name = "default_stone_dig", gain = 0.8},
            dug = {name = "default_stone_dig", gain = 0.8},
            place = {name = "default_stone_place", gain = 0.8},
        },
    })
minetest.register_craft({
        output = "simple_brick:brick_" .. 0 .. " 1",
        recipe = {{"default:cobble", "default:cobble", "default:cobble"},
                  {"default:cobble", "default:cobble", "default:cobble"},
                  {"default:cobble", "default:cobble", "default:cobble"}
        }
        })--]]
-- Цикл от 1 до 17 для создания новых блоков
for i = 1, 17 do
      local block_name = "simple_brick:brick" .. i .. "_1"
      local texture_name = "mod" .. i .. "_1.png"
      local description = "brick " .. i .. ".1"
  
      minetest.register_node(block_name, {
          description = description,
          drawtype = "normal",
          paramtype = "fullbox",
          
          codeone = i,
          codetwo = 1,
                  
  
          tiles = {texture_name}, -- Используем текстуру modX.png
  
          groups = {
              crumbly = 3, -- Твердость как у камня
              oddly_breakable_by_hand = 3, -- Можно сломать рукой, но очень медленно
          },
  
          walkable = true,
          diggable = true,
          buildable_by = {"player"},
  
          -- Звуки, как у камня
          sounds = {
              footstep = {name = "default_stone_footstep", gain = 0.5},
              dig = {name = "default_stone_dig", gain = 0.8},
              dug = {name = "default_stone_dig", gain = 0.8},
              place = {name = "default_stone_place", gain = 0.8},
          },
      })
      if i == 1 then
        minetest.register_craft({
            output = block_name .. " 1", -- "simple_brick:brick1_1 1"
            recipe = {
                {"default:cobble", "default:cobble", "default:cobble"},
                {"default:cobble", "default:cobble", "default:cobble"},
                {"default:cobble", "default:cobble", "default:cobble"}
            }
        })
      else
        local previous_brick_name = "simple_brick:brick" .. (i - 1) .. "_1"
        minetest.register_craft({
            output = block_name .. " 1", -- "simple_brick:brickX_1 1"
            recipe = {
                {previous_brick_name} -- Например, "simple_brick:brick2_1" делается из "simple_brick:brick1_1"
            }
        })
      end
end

for i = 1, 17 do
    for l = 2, 7 do
      local block_name = "simple_brick:brick" .. i .. "_" .. l
      local texture_name = "mod" .. i .. "_" .. l ..".png"
      local description = "brick " .. i .. "." .. l
  
      minetest.register_node(block_name, {
          description = description,
          drawtype = "normal",
          paramtype = "fullbox",
          
          codeone = i,
          codetwo = l,
                  
  
          tiles = {texture_name}, -- Используем текстуру modX.png
  
          groups = {
              crumbly = 3, -- Твердость как у камня
              oddly_breakable_by_hand = 3, -- Можно сломать рукой, но очень медленно
          },
  
          walkable = true,
          diggable = true,
          buildable_by = {"player"},
  
          -- Звуки, как у камня
          sounds = {
              footstep = {name = "default_stone_footstep", gain = 0.5},
              dig = {name = "default_stone_dig", gain = 0.8},
              dug = {name = "default_stone_dig", gain = 0.8},
              place = {name = "default_stone_place", gain = 0.8},
          },
      })
    end
end

minetest.register_tool("simple_brick:grinder", {
    description = "Angle grinder",
    inventory_image = "grinder.png",
    wield_image = "grinder.png",

    tool_capabilities = {
        full_punch_interval = 1.0,
        max_uses = 50,
        groupcaps = {},
        damage_groups = {},
    },

    on_use = function(itemstack, user, pointed_thing)
        -- Проверяем, что удар направлен на узел (блок)
        if pointed_thing.type ~= "node" then
            return
        end
        
        local pos = pointed_thing.under
        local node = minetest.get_node(pos)
        local node_name = node.name
        local player_name = user:get_player_name()

        -- Проверяем, соответствует ли имя узла нашему шаблону
        local brick_type_str, picture_num_str = node_name:match("^simple_brick:brick(%d+)_(%d+)$")
        
        if brick_type_str and picture_num_str then
            local current_picture = tonumber(picture_num_str)
            
            if current_picture then
                if current_picture < 7 then
                    local next_picture = current_picture + 1
                    local new_node_name = "simple_brick:brick" .. brick_type_str .. "_" .. next_picture
                    
                    minetest.set_node(pos, {name = new_node_name})
                    itemstack:add_wear(65535 / 50) -- 65535 - максимальный износ
                    minetest.sound_play("default_place_node", {pos = pos, gain = 0.5})
                else
                    minetest.remove_node(pos)
                    minetest.add_item(pos, "default:cobble 9")
                    itemstack:add_wear(65535 / 50)
                    minetest.sound_play("default_node_dig", {pos = pos, gain = 0.5})
                end
            end
        end
        
        return itemstack
    end
})

minetest.register_craft({
    output = "simple_brick:grinder",
    recipe = {
        {"default:diamond"},
        {"default:stick"}
    }
})