local shape = {}
local make_ok = {}

core.register_node("myappliances:machine", {
	description = "Appliance Machine",
	tiles = {
		"myappliances_machine.png",
		},
	drawtype = "mesh",
	mesh = "myappliances_machine.obj",
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {cracky=2},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.5, -0.5, -0.5, 0.5, 1.5, 0.5},
		}
	},

after_place_node = function(pos, placer)

	local meta = core.get_meta(pos);
	meta:set_string("owner",  (placer:get_player_name() or ""));
	meta:set_string("infotext",  "Appliance Machine (owned by " .. (placer:get_player_name() or "") .. ")");
	
	local inv = meta:get_inventory()
	if not inv:is_empty("ingot") then
		return false
	elseif not inv:is_empty("res") then
		return false
	end
	return true
end,

can_dig = function(pos,player)
	local meta = core.get_meta(pos);
	local inv = meta:get_inventory()
	if player:get_player_name() == meta:get_string("owner") and
	inv:is_empty("plastic") and
	inv:is_empty("copper") and
	inv:is_empty("steel") and
	inv:is_empty("res") then
		return true
	else
	return false
	end
end,

on_construct = function(pos)
		
	local meta = core.get_meta(pos)
	meta:set_string("formspec", "size[10,11;]"..
		"background[-0.15,-0.25;10.40,11.75;myappliances_background.png]"..
		"label[1,1;Pick Your Appliance]"..
		
		--Inputs
		"label[1,5;Plastic]"..
		"list[current_name;plastic;1,5.5;1,1;]"..
		
		"label[2.25,5;Copper Wire]"..
		"list[current_name;copper;2.5,5.5;1,1;]"..
		
		"label[4,5;Steel Sheet]"..
		"list[current_name;steel;4,5.5;1,1;]"..
		
		--Output
		"label[6,5;Output]"..
		"list[current_name;res;6,5.5;1,1;]"..

		--row 1
		"item_image_button[1,1.5;1,1;myappliances:stove;furn19; ]"..
		"item_image_button[2,1.5;1,1;myappliances:dishwasher;furn20; ]"..
		"item_image_button[3,1.5;1,1;myappliances:fridge;furn18; ]"..
		"item_image_button[4,1.5;1,1;myappliances:freezer;furn21; ]"..
		"item_image_button[5,1.5;1,1;myappliances:tv;furn22; ]"..
		"item_image_button[6,1.5;1,1;myappliances:tv_w_stand;furn23; ]"..
		"item_image_button[7,1.5;1,1;myappliances:stereo;furn24; ]"..
		"item_image_button[8,1.5;1,1;myappliances:speaker;furn25; ]"..
		--row 2
		"item_image_button[1,2.5;1,1;myappliances:computer;furn26; ]"..
		"item_image_button[2,2.5;1,1;myappliances:washer;furn27; ]"..
		"item_image_button[3,2.5;1,1;myappliances:dryer;furn28; ]"..
		"item_image_button[4,2.5;1,1;myappliances:microwave;furn29; ]"..
		"item_image_button[5,2.5;1,1;myappliances:watercooler;furn30; ]"..
		"item_image_button[6,2.5;1,1;myappliances:coffeemaker;furn31; ]"..
		"item_image_button[7,2.5;1,1;myappliances:airfryer;furn32; ]"..
		"item_image_button[8,2.5;1,1;myappliances:toaster;furn33; ]"..
		--row 3
		"item_image_button[1,3.5;1,1;myappliances:furnace;furn34; ]"..
		"item_image_button[2,3.5;1,1;myappliances:hotwater_heater;furn35; ]"..
		"item_image_button[3,3.5;1,1;myappliances:bathroom_light;furn36; ]"..

		"list[current_player;main;1,7;8,4;]")
	meta:set_string("infotext", "Appliance Machine")
	local inv = meta:get_inventory()
	inv:set_size("plastic", 1)
	inv:set_size("copper", 1)
	inv:set_size("steel", 1)
	inv:set_size("res", 1)
end,

on_receive_fields = function(pos, formname, fields, sender)
	local meta = core.get_meta(pos)
	local inv = meta:get_inventory()

if fields["furn18"]
or fields["furn19"]
or fields["furn20"]
or fields["furn21"]
or fields["furn22"]
or fields["furn23"]
or fields["furn24"]
or fields["furn25"]
or fields["furn26"]
or fields["furn27"]
or fields["furn28"]
or fields["furn29"]
or fields["furn30"]
or fields["furn31"]
or fields["furn32"]
or fields["furn33"]
or fields["furn34"]
or fields["furn35"]
or fields["furn36"]
then

	if fields["furn18"] then
		make_ok = "0"
		shape = "myappliances:fridge"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn19"] then
		make_ok = "0"
		shape = "myappliances:stove"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn20"] then
		make_ok = "0"
		shape = "myappliances:dishwasher"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn21"] then
		make_ok = "0"
		shape = "myappliances:freezer"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn22"] then
		make_ok = "0"
		shape = "myappliances:tv"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn23"] then
		make_ok = "0"
		shape = "myappliances:tv_w_stand"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn24"] then
		make_ok = "0"
		shape = "myappliances:stereo"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn25"] then
		make_ok = "0"
		shape = "myappliances:speaker"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn26"] then
		make_ok = "0"
		shape = "myappliances:computer"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn27"] then
		make_ok = "0"
		shape = "myappliances:washer"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn28"] then
		make_ok = "0"
		shape = "myappliances:dryer"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn29"] then
		make_ok = "0"
		shape = "myappliances:microwave"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn30"] then
		make_ok = "0"
		shape = "myappliances:watercooler"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn31"] then
		make_ok = "0"
		shape = "myappliances:coffeemaker"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn32"] then
		make_ok = "0"
		shape = "myappliances:airfryer"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn33"] then
		make_ok = "0"
		shape = "myappliances:toaster"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn34"] then
		make_ok = "0"
		shape = "myappliances:furnace"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn35"] then
		make_ok = "0"
		shape = "myappliances:hotwater_heater"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

	if fields["furn36"] then
		make_ok = "0"
		shape = "myappliances:bathroom_light"
		if inv:is_empty("plastic") or
		   inv:is_empty("copper") or
		   inv:is_empty("steel") then
			return
		end
	end

		local stack1 = inv:get_stack("plastic", 1)
		local stack2 = inv:get_stack("copper", 1)
		local stack3 = inv:get_stack("steel", 1)
		local resstack = inv:get_stack("res", 1)

------------------------------------------------------------------------------------------
--register nodes here
------------------------------------------------------------------------------------------
		if stack1:get_name()=="mystreets:plastic" and
		stack2:get_name()=="mypress:copper_wire" and
		stack3:get_name()=="mypress:sheet_steel" then
				make_ok = "1"
		end
----------------------------------------------------------------------------
    	if make_ok == "1" then
			inv:add_item("res",shape)
			stack1:take_item()
			stack2:take_item()
			stack3:take_item()
			inv:set_stack("plastic",1,stack1)
			inv:set_stack("copper",1,stack2)
			inv:set_stack("steel",1,stack3)
			make_ok = 0
		end
	end	
end,
})

--Craft

core.register_craft({
		output = 'myappliances:machine',
		recipe = {
			{"mypress:sheet_tin", "", "mypress:sheet_tin"},
			{"mypress:sheet_tin", "mypress:copper_wire", "mypress:sheet_tin"},
			{"mypress:sheet_tin", "mypress:sheet_tin", "mypress:sheet_tin"},		
		},
})













