
--Rope

core.register_node("myladders:rope", {
	description = "Rope",
	paramtype = "light",
	walkable = false,
	climbable = true,
	groups = {choppy=2,oddly_breakable_by_hand=3,flammable=2},
	sounds = default.node_sound_wood_defaults(),
	drawtype = "mesh",
	mesh = "myladders_rope.obj",
	tiles = {"wool_yellow.png",},
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	}
})

core.register_craft({
	output = 'myladders:rope 3',
	recipe = {
		{"", "wool:yellow", ""},
		{"", "wool:yellow", ""},
		{"", "wool:yellow", ""}
	}
})

--Rope Box
------------------------------------------------------------------------------


core.register_node("myladders:rope_for_box", {
    description = "Rope for Ropebox",
    drawtype = "mesh",
    mesh = "myladders_rope.obj",
    paramtype = "light",
    light_source = 3,
    sunlight_propagates = true,
	tiles = {
		"wool_yellow.png",
		"wool_yellow.png",
		"wool_yellow.png",
		"wool_yellow.png",
		"wool_yellow.png",
		"wool_yellow.png"
	},
    groups = {cracky = 1, choppy = 1, oddly_breakable_by_hand = 1, not_in_creative_inventory=1},
    climbable = true,
    walkable = false,
    diggable = false,
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	},
	collision_box = {
		type = "fixed",
		fixed = {
			{-0.0625, -0.5, -0.0625, 0.0625, 0.5, 0.0625},
		}
	},
    after_destruct = function(pos,oldnode)
        local node = core.get_node({x=pos.x,y=pos.y-1,z=pos.z})
        if node.name == "myladders:rope_for_box" then 
            core.remove_node({x=pos.x,y=pos.y-1,z=pos.z})
        end
    end,
})

core.register_node("myladders:ropebox", {
    description = "Ropebox Block",
    drawtype = "mesh",
    mesh = "myladders_ropebox.obj",
    sunlight_propagates = true,
    tiles = {"default_coal_block.png",
             "default_coal_block.png",
             "default_coal_block.png",
             "default_coal_block.png",
             "default_coal_block.png",
             "default_coal_block.png"},
    paramtype = "light",
    paramtype2 = "facedir",
    groups = {cracky = 1, choppy = 1, oddly_breakable_by_hand = 1, },
	selection_box = {
		type = "fixed",
		fixed = {
			{-0.25, -0.2, -0.375, 0.25, 0.5, 0.375},   
		},
	},
    after_destruct = function(pos,oldnode)
        local node = core.get_node({x=pos.x,y=pos.y-1,z=pos.z})
        if node.name == "myladders:rope_for_box" then 
            core.remove_node({x=pos.x,y=pos.y-1,z=pos.z})
        end
    end,
})

core.register_abm({
	nodenames = {"myladders:ropebox"},
	interval = 1,
	chance = 1,
	action = function(pos, node)
	if core.get_node({x=pos.x,y=pos.y-1,z=pos.z}).name ~= 'air'  then return end
	        core.add_node({x=pos.x,y=pos.y-1,z=pos.z}, {name="myladders:rope_for_box"})
	end
})

core.register_abm({
	nodenames = {"myladders:rope_for_box"},
	interval = 1,
	chance = 1,
	action = function(pos, node)
	if core.get_node({x=pos.x,y=pos.y-1,z=pos.z}).name ~= 'air'  then return end
	        core.add_node({x=pos.x,y=pos.y-1,z=pos.z}, {name="myladders:rope_for_box"})
	end
})

core.register_craft({
	output = "myladders:ropebox",
	recipe = {
		{"default:steel_ingot","default:steel_ingot","default:steel_ingot"},
		{"default:steel_ingot","default:steel_ingot","default:steel_ingot"},
		{"","default:steel_ingot",""},
	}
})
