local slope_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25, 0.5,     0, 0.5},
		{-0.5,     0,     0, 0.5,  0.25, 0.5},
		{-0.5,  0.25,  0.25, 0.5,   0.5, 0.5}
	}
}

local icorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.5, -0.25, 0.5, 0, 0.5},
		{-0.5, -0.5, -0.5, 0.25, 0, 0.5},
		{-0.5, 0, -0.5, 0, 0.25, 0.5},
		{-0.5, 0, 0, 0.5, 0.25, 0.5},
		{-0.5, 0.25, 0.25, 0.5, 0.5, 0.5},
		{-0.5, 0.25, -0.5, -0.25, 0.5, 0.5},
	}
}

local ocorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25,  0.25,     0, 0.5},
		{-0.5,     0,     0,     0,  0.25, 0.5},
		{-0.5,  0.25,  0.25, -0.25,   0.5, 0.5}
	}
}
local mymulch_slopes = {   --Material , Description , Item, Image
	{ "black","Black Mulch","mymulch:mulch_black","^[colorize:black:240"},
	{ "blue","Blue Mulch","mymulch:mulch_blue","^[colorize:#0404B4:100"},
	{ "brown","Brown Mulch","mymulch:mulch_brown","^[colorize:#190B07:160"},
	{ "cyan","Cyan Mulch","mymulch:mulch_cyan","^[colorize:cyan:120"},
	{ "dark_green","Dark Green Mulch","mymulch:mulch_dark_green","^[colorize:#071907:200"},
	{ "dark_grey","Dark Grey Mulch","mymulch:mulch_dark_grey","^[colorize:black:150"},
	{ "green","Green Mulch","mymulch:mulch_green","^[colorize:green:160"},
	{ "grey","Grey Mulch","mymulch:mulch_grey","^[colorize:black:150"},
	{ "magenta","Magenta Mulch","mymulch:mulch_magenta","^[colorize:magenta:160"},
	{ "orange","Orange Mulch","mymulch:mulch_orange","^[colorize:orange:150"},
	{ "pink","Pink Mulch","mymulch:mulch_pink","^[colorize:#FE2E9A:150"},
	{ "red","Red Mulch","mymulch:mulch_red","^[colorize:#B40404:150"},
	{ "violet","Violet Mulch","mymulch:mulch_violet","^[colorize:#2F0B3A:150"},
	{ "white","White Mulch","mymulch:mulch_white","^[colorize:white:150"},
	{ "yellow","Yellow Mulch","mymulch:mulch_yellow","^[colorize:yellow:150"},
}

for i in ipairs(mymulch_slopes) do
	local mat = mymulch_slopes[i][1]
	local desc = mymulch_slopes[i][2]
	local item = mymulch_slopes[i][3]
	local img = mymulch_slopes[i][4]

--slope
core.register_node("myslopes:"..mat.."_slope", {
	description = desc.." Slope",
	drawtype = "mesh",
	mesh = "twelve-twelve.obj",
	tiles = {"mymulch_tan.png"..img.."^mymulch_top.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = slope_cbox,
	selection_box = slope_cbox
})
--icorner
core.register_node("myslopes:"..mat.."_icorner", {
	description = desc.." Slope Inside Corner",
	drawtype = "mesh",
	mesh = "twelve-twelve-ic.obj",
	tiles = {"mymulch_tan.png"..img.."^mymulch_top.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = icorner_cbox,
	selection_box = icorner_cbox
})
--ocorner
core.register_node("myslopes:"..mat.."_ocorner", {
	description = desc.." Slope Outside Corner",
	drawtype = "mesh",
	mesh = "twelve-twelve-oc.obj",
	tiles = {"mymulch_tan.png"..img.."^mymulch_top.png"},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = ocorner_cbox,
	selection_box = ocorner_cbox
})

--Crafts--------------------------------------------------------

--slope
core.register_craft({
	output = "myslopes:"..mat.."_slope 3",
	recipe = {
		{"", "",""},
		{item, "",""},
		{item, item,""},
	}
})
--slope icorner
core.register_craft({
	output = "myslopes:"..mat.."_icorner 4",
	recipe = {
		{"", "",""},
		{"", item,""},
		{item,item, item},
	}
})
--slope ocorner
core.register_craft({
	output = "myslopes:"..mat.."_ocorner 4",
	recipe = {
		{"", "",""},
		{item, item,item},
		{"", item,""},
	}
})

--rotated-----------------------------------------------
--slope
core.register_craft({
	output = "myslopes:"..mat.."_slope_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_slope",""},
		{"", "",""},
	}
})
--slope icorner
core.register_craft({
	output = "myslopes:"..mat.."_icorner_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_icorner",""},
		{"", "",""},
	}
})
--slope ocorner
core.register_craft({
	output = "myslopes:"..mat.."_ocorner_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_ocorner",""},
		{"", "",""},
	}
})
--]]
end






