local slope_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25, 0.5,     0, 0.5},
		{-0.5,     0,     0, 0.5,  0.25, 0.5},
		{-0.5,  0.25,  0.25, 0.5,   0.5, 0.5}
	}
}

local icorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5, -0.5, -0.5, 0.5, -0.25, 0.5},
		{-0.5, -0.5, -0.25, 0.5, 0, 0.5},
		{-0.5, -0.5, -0.5, 0.25, 0, 0.5},
		{-0.5, 0, -0.5, 0, 0.25, 0.5},
		{-0.5, 0, 0, 0.5, 0.25, 0.5},
		{-0.5, 0.25, 0.25, 0.5, 0.5, 0.5},
		{-0.5, 0.25, -0.5, -0.25, 0.5, 0.5},
	}
}

local ocorner_cbox = {
	type = "fixed",
	fixed = {
		{-0.5,  -0.5,  -0.5,   0.5, -0.25, 0.5},
		{-0.5, -0.25, -0.25,  0.25,     0, 0.5},
		{-0.5,     0,     0,     0,  0.25, 0.5},
		{-0.5,  0.25,  0.25, -0.25,   0.5, 0.5}
	}
}
local mymulch_slopes = {   --Material , Description , Item, Image
	{ "black",		"Black Block",		"mywhiteblock:block_black",			"^[colorize:#000000"},
	{ "blue",		"Blue Block",		"mywhiteblock:block_blue",			"^[colorize:#2000c9"},
	{ "brown",		"Brown Block",		"mywhiteblock:block_brown",			"^[colorize:#954c05"},
	{ "cyan",		"Cyan Block",		"mywhiteblock:block_cyan",			"^[colorize:#01ffd8"},
	{ "dark_green",	"Dark Green Block",	"mywhiteblock:block_dark_green",	"^[colorize:#005b07"},
	{ "dark_grey",	"Dark Grey Block",	"mywhiteblock:block_dark_grey",		"^[colorize:#303030"},
	{ "green",		"Green Block",		"mywhiteblock:block_green",			"^[colorize:#61ff01"},
	{ "grey",		"Grey Block",		"mywhiteblock:block_grey",			"^[colorize:#5b5b5b"},
	{ "magenta",	"Magenta Block",	"mywhiteblock:block_magenta",		"^[colorize:#ff05bb"},
	{ "orange",		"Orange Block",		"mywhiteblock:block_orange",		"^[colorize:#ff8401"},
	{ "pink",		"Pink Block",		"mywhiteblock:block_pink",			"^[colorize:#ff65b5"},
	{ "red",		"Red Block",		"mywhiteblock:block_red",			"^[colorize:#ff0000"},
	{ "violet",		"Violet Block",		"mywhiteblock:block_violet",		"^[colorize:#ab23b0"},
	{ "white",		"White Block",		"mywhiteblock:block_white",			"^[colorize:#ffffff"},
	{ "yellow",		"Yellow Block",		"mywhiteblock:block_yellow",		"^[colorize:#e3ff00"},
}

if core.get_modpath("mydye") then
	mymulch_slopes = {
		{"black",		"Black",		"mywhiteblock:block_black",	 		"^[colorize:#000000:240"},
		{"blue",		"Blue",			"mywhiteblock:block_blaue",	 		"^[colorize:#272dc8:200"},
		{"brown",		"Brown",		"mywhiteblock:block_brown",	 		"^[colorize:#190B07:160"},
		{"cyan",		"Cyan",			"mywhiteblock:block_cyan",			"^[colorize:#00ffff:120"},
		{"darkgreen",	"Dark Green",	"mywhiteblock:block_darkgreen",		"^[colorize:#071907:200"},
		{"darkgrey",	"Dark Grey",	"mywhiteblock:block_darkgrey",		"^[colorize:#000000:200"},
		{"green",		"Green", 		"mywhiteblock:block_green",			"^[colorize:#00ff00:160"},
		{"grey",		"Grey", 		"mywhiteblock:block_grey",			"^[colorize:#000000:160"},
		{"magenta",		"Magenta",		"mywhiteblock:block_magenta",			"^[colorize:#ff00ff:160"},
		{"orange",		"Orange",		"mywhiteblock:block_orange",			"^[colorize:#ff7700:220"},
		{"pink",		"Pink",			"mywhiteblock:block_pink",			"^[colorize:#FE2E9A:200"},
		{"red",			"Red",			"mywhiteblock:block_red",			"^[colorize:#B40404:200"},
		{"violet",		"Violet",		"mywhiteblock:block_violet",			"^[colorize:#2F0B3A:220"},
		{"white",		"White",		"mywhiteblock:block_white",			"^[colorize:#ffffff:200"},
		{"yellow",		"Yellow",		"mywhiteblock:block_yellow",			"^[colorize:#ffff00:200"},
		{"peachpuff",	"Peachpuff",	"mywhiteblock:block_peachpuff",	 	"^[colorize:#FFDAB9:200"},
		{"navy",		"Navy", 		"mywhiteblock:block_navy",			"^[colorize:#000080:200"},
		{"coral",		"Coral", 		"mywhiteblock:block_coral",			"^[colorize:#FF7F50:200"},
		{"khaki",		"Khaki", 		"mywhiteblock:block_khaki",			"^[colorize:#F0E68C:200"},
		{"lime",		"Lime", 		"mywhiteblock:block_lime",			"^[colorize:#00FF00:200"},
		{"light_pink",	"Light Pink",	"mywhiteblock:block_light_pink",	 	"^[colorize:#FFB6C1:200"},
		{"light_grey",	"Light Grey",	"mywhiteblock:block_light_grey",	 	"^[colorize:#D3D3D3:200"},
		{"purple",		"Purple", 		"mywhiteblock:block_purple",		"^[colorize:#800080:200"},
		{"maroon",		"Maroon", 		"mywhiteblock:block_maroon",		"^[colorize:#800000:200"},
		{"aquamarine",	"Aqua Marine",	"mywhiteblock:block_aquamarine",	 	"^[colorize:#7FFFD4:200"},
		{"chocolate",	"Chocolate",	"mywhiteblock:block_chocolate",	 	"^[colorize:#D2691E:200"},
		{"crimson",		"Crimson", 		"mywhiteblock:block_crimson",		"^[colorize:#DC143C:200"},
		{"olive",		"Olive",		"mywhiteblock:block_olive",	 		"^[colorize:#808000:200"},
		{"white_smoke",	"White Smoke",	"mywhiteblock:block_white_smoke",	 	"^[colorize:#F5F5F5:200"},
		{"mistyrose",	"Misty Rose",	"mywhiteblock:block_mistyrose",	 	"^[colorize:#FFE4E1:200"},
		{"orchid",		"Orchid",		"mywhiteblock:block_orchid",	 		"^[colorize:#DA70D6:200"},
	}
end

for i in ipairs(mymulch_slopes) do
	local mat = mymulch_slopes[i][1]
	local desc = mymulch_slopes[i][2]
	local item = mymulch_slopes[i][3]
	local img = mymulch_slopes[i][4]

--slope
core.register_node("myslopes:"..mat.."_block_slope", {
	description = desc.." Slope",
	drawtype = "mesh",
	mesh = "twelve-twelve.obj",
	tiles = {"mywhiteblock_white.png"..img},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = slope_cbox,
	selection_box = slope_cbox
})
--icorner
core.register_node("myslopes:"..mat.."_block_icorner", {
	description = desc.." Slope Inside Corner",
	drawtype = "mesh",
	mesh = "twelve-twelve-ic.obj",
	tiles = {"mywhiteblock_white.png"..img},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = icorner_cbox,
	selection_box = icorner_cbox
})
--ocorner
core.register_node("myslopes:"..mat.."_block_ocorner", {
	description = desc.." Slope Outside Corner",
	drawtype = "mesh",
	mesh = "twelve-twelve-oc.obj",
	tiles = {"mywhiteblock_white.png"..img},
	paramtype = "light",
	paramtype2 = "facedir",
	groups = {choppy=2, oddly_breakable_by_hand=2, flammable=3},
	sounds = default.node_sound_wood_defaults(),
	on_place = core.rotate_node,
	collision_box = ocorner_cbox,
	selection_box = ocorner_cbox
})

--Crafts--------------------------------------------------------

--slope
core.register_craft({
	output = "myslopes:"..mat.."_block_slope 3",
	recipe = {
		{"", "",""},
		{item, "",""},
		{item, item,""},
	}
})
--slope icorner
core.register_craft({
	output = "myslopes:"..mat.."_block_icorner 4",
	recipe = {
		{"", "",""},
		{"", item,""},
		{item,item, item},
	}
})
--slope ocorner
core.register_craft({
	output = "myslopes:"..mat.."_block_ocorner 4",
	recipe = {
		{"", "",""},
		{item, item,item},
		{"", item,""},
	}
})

--rotated-----------------------------------------------
--slope
core.register_craft({
	output = "myslopes:"..mat.."_block_slope_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_block_slope",""},
		{"", "",""},
	}
})
--slope icorner
core.register_craft({
	output = "myslopes:"..mat.."_block_icorner_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_block_icorner",""},
		{"", "",""},
	}
})
--slope ocorner
core.register_craft({
	output = "myslopes:"..mat.."_block_ocorner_r 1",
	recipe = {
		{"", "",""},
		{"", "myslopes:"..mat.."_block_ocorner",""},
		{"", "",""},
	}
})
--]]
end






