core.register_node("mystreets:sewer_water", {
	description = "Sewer Water",
	inventory_image = core.inventorycube("mystreets_sewerwater_inv.png"),
	drawtype = "liquid",
	tiles = {"mystreets_sewerwater.png", },
	use_texture_alpha = "clip",
	paramtype = "light",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	drop = "",
	drowning = 1,
	liquidtype = "source",
	liquid_alternative_flowing = "mystreets:sewer_water_flowing",
	liquid_alternative_source = "mystreets:sewer_water",
	liquid_viscosity = 3,
	liquid_renewable = true,
	liquid_range = 2,
	damage_per_second = 0, 
	post_effect_color = {a=180, r=25, g=40, b=1},
	groups = {liquid=2},
})
core.register_node("mystreets:sewer_water_flowing", {
	description = "Flowing Sewer Water",
	inventory_image = core.inventorycube("mystreets_sewerwater_inv.png"),
	drawtype = "flowingliquid",
	tiles = {"mystreets_sewerwater.png"},
	special_tiles = {"mystreets_sewerwater.png"},
	use_texture_alpha = "clip", 
	paramtype = "light",
	paramtype2 = "flowingliquid",
	walkable = false,
	pointable = false,
	diggable = false,
	buildable_to = true,
	drop = "",
	drowning = 1,
	liquidtype = "flowing",
	liquid_alternative_flowing = "mystreets:sewer_water_flowing",
	liquid_alternative_source = "mystreets:sewer_water",
	liquid_viscosity = 3,
	liquid_renewable = true,
	liquid_range = 3,
	damage_per_second = 0, 
	post_effect_color = {a=180, r=25, g=40, b=1},
	groups = {liquid=2, not_in_creative_inventory=1},
})
--Crafting
core.register_craft({
	output = "mystreets:sewer_water 3",
	recipe = {
		{"bucket:bucket_water", "",""},
		{"group:grass", "",""},
		{"", "",""},
	}
})
