minetest.register_tool(":balrog_sword:balrog_sword", {
	description = minetest.colorize("orange", ("Balrog Sword")) .. minetest.get_background_escape_sequence("purple"),
	inventory_image = "sword_balrog.png",
	range = 18,
	damage = 40,
	   on_use = function(itemstack, user, pointed_thing)
      if pointed_thing.type == "nothing" then
         local dir = user:get_look_dir()
         local pos = user:get_pos()
         for i = 1, 50 do
            local new_pos = {
               x = pos.x + (dir.x * i),
               y = pos.y + (dir.y * i),
               z = pos.z + (dir.z * i),
            }
            if minetest.get_node(new_pos).name == "air"  and
            not minetest.is_protected(new_pos, user:get_player_name()) then
               minetest.set_node(new_pos, {name = "fire:basic_flame"})
            end
         end
         if not minetest.setting_getbool("creative_mode") then
            itemstack:add_wear(65535/49)
            return itemstack
         end
      elseif pointed_thing.type == "object" then
         local obj = pointed_thing.ref
         minetest.add_particlespawner({
            amount = 40,
            time = 6,
            minpos = {x = -1, y = -1, z = -1},
            maxpos = {x = 1, y = 1, z = 1},
            minvel = {x = -2, y = -2, z = -2},
            maxvel = {x = 2, y = 2, z = 2},
            minacc = {x = -1, y = -1, z = -1},
            maxacc = {x = 1, y = 1, z = 1},
            minexptime = 1,
            maxexptime = 2,
            minsize = 1,
            maxsize = 3,
            attached = obj,
            vertical = false,
            --  ^ vertical: if true faces player using y axis only
            texture = "fire_basic_flame.png",
         })
         obj:punch(user, 1, itemstack:get_tool_capabilities())
         for i = 1, 5 do
            minetest.after(i, function()
               if obj and user and itemstack then
                  obj:punch(user, 1, itemstack:get_tool_capabilities())
               end
            end)
         end
         if not minetest.setting_getbool("creative_mode") then
            itemstack:add_wear(65535/499)
            return itemstack
         end
      elseif pointed_thing.type == "node" then
         local pos = user:get_pos()
         local radius = 5
         for x = -radius, radius do
         for z = -radius, radius do
         for y = 10, -10, -1 do
            local new_pos = {
               x = pos.x + x,
               y = pos.y + y,
               z = pos.z + z,
            }

            local node =  minetest.get_node(new_pos)
            local nodeu = minetest.get_node({x = new_pos.x, y = new_pos.y - 1, z = new_pos.z})
            local value = x * x + z * z
            if value <= radius * radius + 1
            and node.name == "air" and nodeu.name ~= "air"
            and not minetest.is_protected(new_pos, name) then
               minetest.set_node(new_pos, {name = "fire:basic_flame"})
               break
            end
         end
         end
         end
         if not minetest.setting_getbool("creative_mode") then
            itemstack:add_wear(65535/49)
            return itemstack
         end
      end
   end,
   tool_capabilities = {
      full_punch_interval = 0.1,
      max_drop_level=2,
      groupcaps={
         snappy={times={[1]=1.60, [2]=1.30, [3]=0.90}, uses=500, maxlevel=3},
      },
      damage_groups = {fleshy=5, immortal=10},
   },
   on_die = function(self, pos)
		self.object:remove()

		-- This has been taken from ../tnt/init.lua @243
		minetest.add_particlespawner({
			amount = 128,
			time = 0.1,
			minpos = vector.subtract(pos, 10 / 2),
			maxpos = vector.add(pos, 10 / 2),
			minvel = {x = -3, y = 0, z = -3},
			maxvel = {x = 3, y = 5,  z = 3},
			minacc = {x = 0, y = -10, z = 0},
			maxacc = {x = 0, y = -10, z = 0},
			minexptime = 0.8,
			maxexptime = 2.0,
			minsize = 10 * 0.66,
			maxsize = 10 * 2,
			texture = "fire_basic_flame.png",
			collisiondetection = true,
		})
	end,
})

minetest.register_craft({
	output = "balrog_sword:balrog_sword",
	recipe = {
		{'mobs_balrog:balrog_whip', '', '' },
		{'default:sword_diamond', '', '' },
		{'', '', '' },
	}
})
