--======================--
--===SuperFlat Mapgen===--
--======================--

-- Node registration is required for this to have multi game support.

if minetest.get_modpath("default") then
minetest.register_node("mg_superflat:mapgen_stone", {
	description = ("Stone"),
	tiles = {"default_stone.png"},
	groups = {cracky = 3, stone = 1},
})
minetest.register_node("mg_superflat:mapgen_grass", {
	description = ("Dirt With Grass"),
	tiles = {"default_grass.png", "default_dirt.png",
		{name = "default_dirt.png^default_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, dirt = 1},
})
minetest.register_node("mg_superflat:mapgen_dirt", {
	description = ("Dirt"),
	tiles = {"default_dirt.png"},
	groups = {crumbly = 3, dirt = 1},
})
else
minetest.register_node("mg_superflat:mapgen_stone", {
	description = ("Stone"),
	tiles = {"mg_superflat_stone.png"},
	groups = {cracky = 3, stone = 1},
})
minetest.register_node("mg_superflat:mapgen_grass", {
	description = ("Dirt With Grass"),
	tiles = {"mg_superflat_grass.png", "mg_superflat_dirt.png",
		{name = "mg_superflat_dirt.png^mg_superflat_grass_side.png",
			tileable_vertical = false}},
	groups = {crumbly = 3, dirt = 1},
})
minetest.register_node("mg_superflat:mapgen_dirt", {
	description = ("Dirt"),
	tiles = {"mg_superflat_dirt.png"},
	groups = {crumbly = 3, dirt = 1},
})
end

--This is the function for map generation


local c_air = minetest.get_content_id("air")
local c_stone = minetest.get_content_id("mg_superflat:mapgen_stone")
local c_dirt_with_grass = minetest.get_content_id("mg_superflat:mapgen_grass")
local c_dirt = minetest.get_content_id("mg_superflat:mapgen_dirt")

minetest.set_mapgen_setting("mg_name", "singlenode", true)

minetest.register_on_generated(function(minp, maxp, seed)
	local vm, emin, emax = minetest.get_mapgen_object("voxelmanip")
	local data = vm:get_data()
	local area = VoxelArea:new{MinEdge=emin, MaxEdge=emax}
    
	for z = minp.z, maxp.z do
        	for y = minp.y, maxp.y do
            		for x = minp.x, maxp.x do
                	local vi = area:index(x, y, z)
                
                	if y < -1 then
                 	   data[vi] = c_stone
                	elseif y < 1 then
                	    data[vi] = c_dirt
               		elseif y < 2 then
        		data[vi] = c_dirt_with_grass
               	 	else
                 	data[vi] = c_air
             	   	end
           	 end
       	end
end
    
	vm:set_data(data)
	vm:write_to_map()
end)
